/*
 * Decompiled with CFR 0.152.
 */
package online.kingdomkeys.kingdomkeys.world.dimension.castle_oblivion.system.registry;

import java.util.List;
import java.util.function.Supplier;
import net.minecraft.resources.ResourceLocation;
import online.kingdomkeys.kingdomkeys.world.dimension.castle_oblivion.system.floor.FloorType;
import online.kingdomkeys.kingdomkeys.world.dimension.castle_oblivion.system.registry.JsonRegistry;
import online.kingdomkeys.kingdomkeys.world.dimension.castle_oblivion.system.registry.ModFloorTypes;
import online.kingdomkeys.kingdomkeys.world.dimension.castle_oblivion.system.registry.ModJsonRegistries;
import online.kingdomkeys.kingdomkeys.world.dimension.castle_oblivion.system.room.RoomStructure;
import online.kingdomkeys.kingdomkeys.world.dimension.castle_oblivion.system.room.RoomType;

public class ModRoomStructures {
    public static Supplier<JsonRegistry<RoomStructure>> registry = ModJsonRegistries.ROOM_STRUCTURE;
    public static final Supplier<RoomStructure> ENTRANCE_HALL_1F = () -> registry.get().getValue(ResourceLocation.fromNamespaceAndPath((String)"kingdomkeys", (String)"entrance_hall_1f"));
    public static final Supplier<RoomStructure> ENTRANCE_HALL = () -> registry.get().getValue(ResourceLocation.fromNamespaceAndPath((String)"kingdomkeys", (String)"entrance_hall"));
    public static final Supplier<RoomStructure> TEST_ROOM = () -> registry.get().getValue(ResourceLocation.fromNamespaceAndPath((String)"kingdomkeys", (String)"test_room"));
    public static final Supplier<RoomStructure> PLAINS_S_1 = () -> registry.get().getValue(ResourceLocation.fromNamespaceAndPath((String)"kingdomkeys", (String)"plains_s_1"));
    public static final Supplier<RoomStructure> PLAINS_S_2 = () -> registry.get().getValue(ResourceLocation.fromNamespaceAndPath((String)"kingdomkeys", (String)"plains_s_2"));
    public static final Supplier<RoomStructure> BOTTOMLESS_DARKNESS = () -> registry.get().getValue(ResourceLocation.fromNamespaceAndPath((String)"kingdomkeys", (String)"bottomless_darkness"));
    public static final Supplier<RoomStructure> NETHER_S_1 = () -> registry.get().getValue(ResourceLocation.fromNamespaceAndPath((String)"kingdomkeys", (String)"nether_s_1"));

    public static List<RoomStructure> getCompatibleStructures(FloorType floor, RoomType room) {
        if (room.getFixedRoom() != null) {
            return List.of(room.getFixedRoom());
        }
        return registry.get().getValues().stream().filter(s -> ModRoomStructures.isStructureCompatible(floor, s, room)).toList();
    }

    public static boolean isStructureCompatible(FloorType floor, RoomStructure structure, RoomType type) {
        if (!(structure.getFloor() == null || ModFloorTypes.isFloorCompatible(floor, type) && floor.equals(structure.getFloor()))) {
            return false;
        }
        if (structure.getRoomWhitelist().isEmpty()) {
            return type.getSize() == structure.getSize() && structure.getCategories().contains((Object)type.getCategory()) && (structure.getFloor() == null || type.isFloorCompatible(structure.getFloor()));
        }
        return structure.getRoomWhitelist().contains(type);
    }
}

