/*
 * Decompiled with CFR 0.152.
 */
package online.kingdomkeys.kingdomkeys.world.dimension.castle_oblivion.system.room;

import java.util.HashMap;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import online.kingdomkeys.kingdomkeys.data.CastleOblivionData;
import online.kingdomkeys.kingdomkeys.entity.block.CardDoorTileEntity;
import online.kingdomkeys.kingdomkeys.world.dimension.castle_oblivion.system.floor.Floor;
import online.kingdomkeys.kingdomkeys.world.dimension.castle_oblivion.system.registry.ModRoomStructures;
import online.kingdomkeys.kingdomkeys.world.dimension.castle_oblivion.system.registry.ModRoomTypes;
import online.kingdomkeys.kingdomkeys.world.dimension.castle_oblivion.system.room.DoorData;
import online.kingdomkeys.kingdomkeys.world.dimension.castle_oblivion.system.room.RoomData;
import online.kingdomkeys.kingdomkeys.world.dimension.castle_oblivion.system.room.RoomDirection;
import online.kingdomkeys.kingdomkeys.world.dimension.castle_oblivion.system.room.RoomPos;
import online.kingdomkeys.kingdomkeys.world.dimension.castle_oblivion.system.room.RoomStructure;
import online.kingdomkeys.kingdomkeys.world.dimension.castle_oblivion.system.room.RoomType;
import online.kingdomkeys.kingdomkeys.world.dimension.castle_oblivion.system.room.modifiers.RoomModifier;

public class Room {
    RoomType type;
    RoomStructure structure;
    BlockPos position;
    int mobsRemaining;
    public Map<RoomDirection, Door> doors;
    public int parentFloor;
    RoomPos roomPos;
    boolean generated;

    public Room(RoomType type, int parentFloor, RoomPos roomPos) {
        this.type = type;
        this.parentFloor = parentFloor;
        this.doors = new HashMap<RoomDirection, Door>();
        this.roomPos = roomPos;
    }

    public Room(CompoundTag tag) {
        this(ModRoomTypes.registry.get().getValue(ResourceLocation.parse((String)tag.getString("type"))), tag.getInt("parent"), new RoomPos(tag.getCompound("room_pos")));
        this.deserializeNBT(tag);
    }

    public RoomStructure getStructure() {
        return this.structure;
    }

    public void setStructure(RoomStructure structure) {
        this.structure = structure;
    }

    public void createRoomFromCard(RoomType type, ServerLevel level, Room currentRoom, RoomDirection doorDirection) {
        this.type = type;
        if (this.generated) {
            this.clearRoom(level);
        }
        Direction dir = doorDirection.toMCDirection();
        this.position = currentRoom.position.relative(dir, 128);
    }

    public BlockPos getPosition() {
        return this.position;
    }

    public void setPosition(BlockPos position) {
        this.position = position;
    }

    public BlockPos getExitDoor() {
        for (Door door : this.doors.values()) {
            if (door.data.getType() != DoorData.Type.EXIT) continue;
            return door.pos;
        }
        return null;
    }

    public CardDoorTileEntity getDoorTE(Level level, RoomDirection direction) {
        BlockPos pos;
        if (this.doors.containsKey((Object)direction) && (pos = this.doors.get((Object)direction).pos()) != null) {
            return (CardDoorTileEntity)level.getBlockEntity(pos);
        }
        return null;
    }

    public RoomType getType() {
        return this.type;
    }

    public RoomPos getRoomPos() {
        return this.roomPos;
    }

    public RoomData getRoomData(CastleOblivionData.InteriorData data) {
        return this.getParent(data).getRoom(this.getRoomPos());
    }

    public Floor getParent(CastleOblivionData.InteriorData data) {
        return data.getFloorByID(this.parentFloor);
    }

    public void tick() {
        this.type.getModifiers().forEach(RoomModifier::tick);
    }

    public boolean inRoom(BlockPos pos) {
        return pos.getX() >= this.position.getX() && pos.getX() <= this.position.getX() + this.structure.getWidth() && pos.getZ() >= this.position.getZ() && pos.getZ() <= this.position.getZ() + this.structure.getDepth();
    }

    public boolean clearRoom(ServerLevel level) {
        Floor parent = this.getParent(CastleOblivionData.InteriorData.get(level));
        if (parent != null) {
            if (!parent.shouldRoomTick(this)) {
                BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos(this.position.getX(), this.position.getY(), this.position.getZ());
                for (int z = 0; z < this.structure.getDepth(); ++z) {
                    for (int y = 0; y < 128; ++y) {
                        for (int x = 0; x < this.structure.getWidth(); ++x) {
                            pos.set(x, y, z);
                            level.setBlock((BlockPos)pos, Blocks.AIR.defaultBlockState(), 2);
                        }
                    }
                }
                this.generated = false;
                return true;
            }
            return false;
        }
        return false;
    }

    public CompoundTag serializeNBT() {
        CompoundTag tag = new CompoundTag();
        tag.putInt("parent", this.parentFloor);
        tag.put("room_pos", (Tag)this.roomPos.serializeNBT());
        tag.putString("type", this.type.getRegistryName().toString());
        tag.put("position", NbtUtils.writeBlockPos((BlockPos)this.position));
        tag.putInt("mobs", this.mobsRemaining);
        tag.putBoolean("generated", this.generated);
        tag.putInt("door_positions_size", this.doors.size());
        CompoundTag doorPosTag = new CompoundTag();
        int i = 0;
        for (Map.Entry<RoomDirection, Door> doorPos : this.doors.entrySet()) {
            doorPosTag.putInt("direction_" + i, doorPos.getKey().ordinal());
            doorPosTag.put("door_" + i, (Tag)doorPos.getValue().serializeNBT());
            ++i;
        }
        tag.put("door_positions", (Tag)doorPosTag);
        tag.putString("structure", this.structure.getRegistryName().toString());
        return tag;
    }

    public void deserializeNBT(CompoundTag tag) {
        this.position = (BlockPos)NbtUtils.readBlockPos((CompoundTag)tag, (String)"position").get();
        this.mobsRemaining = tag.getInt("mobs");
        this.generated = tag.getBoolean("generated");
        int doorPosSize = tag.getInt("door_positions_size");
        CompoundTag doorPosTag = tag.getCompound("door_positions");
        for (int i = 0; i < doorPosSize; ++i) {
            this.doors.put(RoomDirection.values()[doorPosTag.getInt("direction_" + i)], new Door(doorPosTag.getCompound("door_" + i)));
        }
        this.structure = ModRoomStructures.registry.get().getValue(ResourceLocation.parse((String)tag.getString("structure")));
    }

    public record Door(DoorData data, BlockPos pos) {
        public Door(CompoundTag tag) {
            this(new DoorData(tag.getCompound("data")), (BlockPos)NbtUtils.readBlockPos((CompoundTag)tag, (String)"pos").get());
        }

        public CompoundTag serializeNBT() {
            CompoundTag tag = new CompoundTag();
            tag.put("data", (Tag)this.data.serializeNBT());
            tag.put("pos", NbtUtils.writeBlockPos((BlockPos)this.pos));
            return tag;
        }
    }
}

