/*
 * Decompiled with CFR 0.152.
 */
package online.kingdomkeys.kingdomkeys.world.dimension.castle_oblivion.system.room;

import java.util.HashMap;
import java.util.Map;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.server.level.ServerLevel;
import online.kingdomkeys.kingdomkeys.data.CastleOblivionData;
import online.kingdomkeys.kingdomkeys.util.Utils;
import online.kingdomkeys.kingdomkeys.world.dimension.castle_oblivion.system.floor.Floor;
import online.kingdomkeys.kingdomkeys.world.dimension.castle_oblivion.system.room.DoorData;
import online.kingdomkeys.kingdomkeys.world.dimension.castle_oblivion.system.room.Room;
import online.kingdomkeys.kingdomkeys.world.dimension.castle_oblivion.system.room.RoomDirection;
import online.kingdomkeys.kingdomkeys.world.dimension.castle_oblivion.system.room.RoomPos;

public class RoomData {
    Map<RoomDirection, DoorData> doors;
    public final RoomPos pos;
    int parent;
    Room generatedRoom;
    Type type;
    int cardCost;
    public static final StreamCodec<FriendlyByteBuf, RoomData> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.COMPOUND_TAG, RoomData::serializeNBT, RoomData::new);

    public RoomData(RoomPos pos, Type type) {
        this(pos);
        this.type = type;
    }

    public RoomData(RoomPos pos) {
        this.pos = pos;
        this.doors = new HashMap<RoomDirection, DoorData>();
        this.cardCost = Utils.randomWithRange(0, 9);
    }

    public RoomData(CompoundTag tag) {
        this(new RoomPos(tag.getCompound("roompos")));
        this.deserializeNBT(tag);
    }

    public Type getType() {
        return this.type;
    }

    public void finalizeType(Type type) {
        if (this.type == null) {
            this.type = type;
        }
    }

    public int getParentID() {
        return this.parent;
    }

    public Floor getParentFloor(ServerLevel level) {
        return CastleOblivionData.InteriorData.get(level).getFloorByID(this.parent);
    }

    public void setParent(Floor parent) {
        this.parent = parent.getFloorID();
    }

    public void addDoor(DoorData.Type doorType, RoomDirection direction) {
        if (!this.doors.containsKey((Object)direction)) {
            this.setDoor(doorType, direction);
        }
    }

    public void setDoor(DoorData.Type doorType, RoomDirection direction) {
        this.doors.put(direction, new DoorData(this, doorType, direction));
    }

    public void setRemainingDoors(DoorData.Type doorType) {
        for (RoomDirection dir : RoomDirection.values()) {
            if (this.doors.containsKey((Object)dir)) continue;
            this.doors.put(dir, new DoorData(this, doorType, dir));
        }
    }

    public DoorData getDoor(RoomDirection direction) {
        return this.doors.get((Object)direction);
    }

    public Map<RoomDirection, DoorData> getDoors() {
        return this.doors;
    }

    public int getCardCost() {
        return this.cardCost;
    }

    public void setGenerated(Room room) {
        this.generatedRoom = room;
    }

    public Room getGenerated() {
        return this.generatedRoom;
    }

    public CompoundTag serializeNBT() {
        CompoundTag tag = new CompoundTag();
        tag.putInt("parent", this.parent);
        tag.putInt("door_count", this.doors.size());
        CompoundTag doorDataTag = new CompoundTag();
        int i = 0;
        for (Map.Entry<RoomDirection, DoorData> doorPair : this.doors.entrySet()) {
            doorDataTag.putInt("door_direction_" + i, doorPair.getKey().ordinal());
            doorDataTag.put("door_data_" + i, (Tag)doorPair.getValue().serializeNBT());
            ++i;
        }
        tag.put("doors", (Tag)doorDataTag);
        tag.put("roompos", (Tag)this.pos.serializeNBT());
        tag.putBoolean("generated", this.generatedRoom != null);
        if (this.generatedRoom != null) {
            tag.put("generated_room", (Tag)this.generatedRoom.serializeNBT());
        }
        tag.putInt("card_cost", this.cardCost);
        if (this.type != null) {
            tag.putInt("type", this.type.ordinal());
        }
        return tag;
    }

    public void deserializeNBT(CompoundTag tag) {
        this.parent = tag.getInt("parent");
        int doorCount = tag.getInt("door_count");
        this.doors.clear();
        CompoundTag doorDataTag = tag.getCompound("doors");
        for (int i = 0; i < doorCount; ++i) {
            int dir = doorDataTag.getInt("door_direction_" + i);
            this.doors.put(RoomDirection.values()[dir], new DoorData(doorDataTag.getCompound("door_data_" + i)));
        }
        if (tag.getBoolean("generated")) {
            this.generatedRoom = new Room(tag.getCompound("generated_room"));
        }
        this.cardCost = tag.getInt("card_cost");
        if (tag.contains("type")) {
            this.type = Type.values()[tag.getInt("type")];
        }
    }

    public static enum Type {
        ENTRANCE,
        EXIT,
        BOSS,
        NORMAL;

    }
}

