/*
 * Decompiled with CFR 0.152.
 */
package online.kingdomkeys.kingdomkeys.world.dimension.castle_oblivion.system.room;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtAccounter;
import net.minecraft.nbt.NbtIo;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.StructureBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.StructureBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.StructureMode;
import net.neoforged.bus.api.Event;
import net.neoforged.neoforge.common.NeoForge;
import online.kingdomkeys.kingdomkeys.KingdomKeys;
import online.kingdomkeys.kingdomkeys.block.CardDoorBlock;
import online.kingdomkeys.kingdomkeys.block.ModBlocks;
import online.kingdomkeys.kingdomkeys.data.CastleOblivionData;
import online.kingdomkeys.kingdomkeys.entity.block.CardDoorTileEntity;
import online.kingdomkeys.kingdomkeys.network.stc.SCSyncCastleOblivionInteriorData;
import online.kingdomkeys.kingdomkeys.util.Utils;
import online.kingdomkeys.kingdomkeys.world.dimension.castle_oblivion.system.CastleOblivionEvent;
import online.kingdomkeys.kingdomkeys.world.dimension.castle_oblivion.system.floor.Floor;
import online.kingdomkeys.kingdomkeys.world.dimension.castle_oblivion.system.registry.ModRoomStructures;
import online.kingdomkeys.kingdomkeys.world.dimension.castle_oblivion.system.registry.ModRoomTypes;
import online.kingdomkeys.kingdomkeys.world.dimension.castle_oblivion.system.room.DoorData;
import online.kingdomkeys.kingdomkeys.world.dimension.castle_oblivion.system.room.Room;
import online.kingdomkeys.kingdomkeys.world.dimension.castle_oblivion.system.room.RoomData;
import online.kingdomkeys.kingdomkeys.world.dimension.castle_oblivion.system.room.RoomDirection;
import online.kingdomkeys.kingdomkeys.world.dimension.castle_oblivion.system.room.RoomPos;
import online.kingdomkeys.kingdomkeys.world.dimension.castle_oblivion.system.room.RoomStructure;
import online.kingdomkeys.kingdomkeys.world.dimension.castle_oblivion.system.room.RoomType;

public class RoomGenerator {
    public static final RoomGenerator INSTANCE = new RoomGenerator();

    private RoomGenerator() {
    }

    public Room generateNewFloor(ServerLevel level) {
        CastleOblivionData.InteriorData interiorData = CastleOblivionData.InteriorData.get(level);
        Floor currentFloor = new Floor(level);
        Room room = new Room(ModRoomTypes.ENTRANCE_HALL.get(), currentFloor.getFloorID(), RoomPos.ZERO);
        Floor prevFloor = interiorData.getFloorByID(currentFloor.getFloorID() - 1);
        room.setPosition(prevFloor.getNorthernMostRoomPosition().relative(Direction.SOUTH, 512));
        return this.generateRoom(level, currentFloor.getRoom(RoomPos.ZERO), room, null);
    }

    public Room generateRoom(ServerLevel level, RoomData data, RoomType type, @Nullable Room currentRoom, @Nullable RoomDirection doorDirection) {
        if (type.equals(ModRoomTypes.ENTRANCE_HALL.get()) && data.pos.equals(RoomPos.ZERO)) {
            KingdomKeys.LOGGER.warn("Tried to generate room type {} at entrance hall position", (Object)type.getRegistryName().toString());
            return null;
        }
        CastleOblivionData.InteriorData interiorData = CastleOblivionData.InteriorData.get(level);
        Floor currentFloor = interiorData.getFloorByID(currentRoom.parentFloor);
        Room room = new Room(type, currentFloor.getFloorID(), data.pos);
        room.createRoomFromCard(type, level, currentRoom, doorDirection);
        return this.generateRoom(level, data, room, currentRoom);
    }

    private Room generateRoom(ServerLevel level, RoomData data, Room newRoom, @Nullable Room currentRoom) {
        try {
            int i;
            CastleOblivionData.InteriorData interiorData = CastleOblivionData.InteriorData.get(level);
            Floor currentFloor = interiorData.getFloorByID(newRoom.parentFloor);
            BlockPos pos = newRoom.position;
            List<RoomStructure> possibleRooms = ModRoomStructures.getCompatibleStructures(currentFloor.getType(), newRoom.type);
            if (possibleRooms.isEmpty()) {
                throw new IOException(String.format("No compatible room structure files found for %s", newRoom.type.getRegistryName()));
            }
            RoomStructure structureToGenerate = possibleRooms.get(Utils.randomWithRange(0, possibleRooms.size() - 1));
            String floorFolder = structureToGenerate.getFloor() == null ? "all" : structureToGenerate.getFloor().getRegistryName().getPath();
            Resource resource = (Resource)level.getServer().getResourceManager().getResource(ResourceLocation.fromNamespaceAndPath((String)"kingdomkeys", (String)("structure/castle_oblivion/rooms/" + floorFolder + "/" + structureToGenerate.getPath() + ".nbt"))).get();
            CompoundTag main = NbtIo.readCompressed((InputStream)resource.open(), (NbtAccounter)NbtAccounter.unlimitedHeap());
            newRoom.setStructure(structureToGenerate);
            ListTag palette = main.getList("palette", 10);
            ListTag blocks = main.getList("blocks", 10);
            ArrayList<BlockState> blockStates = new ArrayList<BlockState>();
            CompoundTag block = blocks.getCompound(0);
            BlockPos.MutableBlockPos blockpos = new BlockPos.MutableBlockPos(block.getList("pos", 3).getInt(0), block.getList("pos", 3).getInt(1), block.getList("pos", 3).getInt(2));
            for (i = 0; i < palette.size(); ++i) {
                block = palette.getCompound(i);
                blockStates.add(NbtUtils.readBlockState((HolderGetter)level.holderLookup(Registries.BLOCK), (CompoundTag)block));
            }
            for (i = 0; i < blocks.size(); ++i) {
                block = blocks.getCompound(i);
                blockpos.set(block.getList("pos", 3).getInt(0) + pos.getX(), block.getList("pos", 3).getInt(1) + pos.getY(), block.getList("pos", 3).getInt(2) + pos.getZ());
                BlockState state = (BlockState)blockStates.get(block.getInt("state"));
                if (state.getBlock() == Blocks.STRUCTURE_BLOCK) {
                    RoomDirection facing;
                    if (!((StructureMode)state.getValue((Property)StructureBlock.MODE)).equals((Object)StructureMode.DATA)) continue;
                    StructureBlockEntity be = new StructureBlockEntity((BlockPos)blockpos, state);
                    be.loadCustomOnly(block.getCompound("nbt"), (HolderLookup.Provider)level.registryAccess());
                    BlockState cardDoorState = (BlockState)ModBlocks.cardDoor.get().defaultBlockState().setValue((Property)CardDoorBlock.GENERATED, (Comparable)Boolean.valueOf(true));
                    switch (be.getMetaData()) {
                        case "north": {
                            RoomDirection roomDirection = RoomDirection.SOUTH;
                            break;
                        }
                        case "west": {
                            RoomDirection roomDirection = RoomDirection.EAST;
                            break;
                        }
                        case "east": {
                            RoomDirection roomDirection = RoomDirection.WEST;
                            break;
                        }
                        case "south": {
                            RoomDirection roomDirection = RoomDirection.NORTH;
                            break;
                        }
                        default: {
                            RoomDirection roomDirection = facing = null;
                        }
                    }
                    if (facing == null) continue;
                    cardDoorState = (BlockState)cardDoorState.setValue((Property)CardDoorBlock.FACING, (Comparable)facing.toMCDirection().getOpposite());
                    DoorData doorData = data.getDoor(facing);
                    if (doorData != null && doorData.getType() != DoorData.Type.NONE) {
                        BlockPos adjacentDoorPos;
                        CardDoorTileEntity adjacentDoorTE;
                        newRoom.doors.put(facing, new Room.Door(doorData, blockpos.immutable()));
                        if (doorData.getType() == DoorData.Type.EXIT || doorData.getType() == DoorData.Type.ENTRANCE) {
                            cardDoorState = (BlockState)cardDoorState.setValue((Property)CardDoorBlock.OPEN, (Comparable)Boolean.valueOf(true));
                            level.setBlock((BlockPos)blockpos, cardDoorState, 2);
                            CardDoorTileEntity cardDoorTileEntity = new CardDoorTileEntity((BlockPos)blockpos, cardDoorState);
                            cardDoorTileEntity.setParent(data);
                            cardDoorTileEntity.setDirection(facing);
                            cardDoorTileEntity.setData(doorData);
                            cardDoorTileEntity.openDoor(false);
                            level.setBlockEntity((BlockEntity)cardDoorTileEntity);
                            continue;
                        }
                        if (doorData.getType() == DoorData.Type.HALL) {
                            level.setBlock((BlockPos)blockpos, cardDoorState, 2);
                            CardDoorTileEntity cardDoorTileEntity = new CardDoorTileEntity((BlockPos)blockpos, cardDoorState);
                            cardDoorTileEntity.setParent(data);
                            cardDoorTileEntity.setDirection(facing);
                            cardDoorTileEntity.setData(doorData);
                            level.setBlockEntity((BlockEntity)cardDoorTileEntity);
                            continue;
                        }
                        RoomData adjacentRoom = currentFloor.getAdjacentRoom(data, facing);
                        if (adjacentRoom == null) continue;
                        if (adjacentRoom.getGenerated() != null && (adjacentDoorTE = (CardDoorTileEntity)level.getBlockEntity(adjacentDoorPos = adjacentRoom.getGenerated().doors.get((Object)facing.opposite()).pos())) != null && adjacentDoorTE.isOpen()) {
                            cardDoorState = (BlockState)cardDoorState.setValue((Property)CardDoorBlock.OPEN, (Comparable)Boolean.valueOf(true));
                            adjacentDoorTE.setDestinationRoom(data);
                        }
                        if (adjacentRoom.getDoors().get((Object)facing.opposite()) == null) continue;
                        level.setBlock((BlockPos)blockpos, cardDoorState, 2);
                        CardDoorTileEntity cardDoorTileEntity = new CardDoorTileEntity((BlockPos)blockpos, cardDoorState);
                        cardDoorTileEntity.setParent(data);
                        cardDoorTileEntity.setDirection(facing);
                        cardDoorTileEntity.setDestinationRoom(adjacentRoom);
                        cardDoorTileEntity.setData(doorData);
                        cardDoorTileEntity.openDoor(false);
                        level.setBlockEntity((BlockEntity)cardDoorTileEntity);
                        continue;
                    }
                    level.setBlock((BlockPos)blockpos, Blocks.AIR.defaultBlockState(), 2);
                    continue;
                }
                level.setBlock((BlockPos)blockpos, state, 2);
            }
            data.setGenerated(newRoom);
            SCSyncCastleOblivionInteriorData.syncClients(level);
            KingdomKeys.LOGGER.info("Generated room:{} at {}", (Object)newRoom.type.getRegistryName().toString(), (Object)pos);
            NeoForge.EVENT_BUS.post((Event)new CastleOblivionEvent.RoomGeneratedEvent(level, data, currentRoom));
            return newRoom;
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }
}

