/*
 * Decompiled with CFR 0.152.
 */
package online.kingdomkeys.kingdomkeys.world.dimension.castle_oblivion.system.room;

import java.util.Objects;
import net.minecraft.nbt.CompoundTag;
import online.kingdomkeys.kingdomkeys.world.dimension.castle_oblivion.system.room.RoomDirection;

public record RoomPos(int x, int y) {
    public static final RoomPos ZERO = new RoomPos(0, 0);

    public RoomPos(RoomPos pos) {
        this(pos.x, pos.y);
    }

    public RoomPos(CompoundTag tag) {
        this(tag.getInt("roompos_x"), tag.getInt("roompos_y"));
    }

    public static RoomPos inDirection(RoomPos prevPos, RoomDirection direction) {
        return new RoomPos(prevPos.add(direction));
    }

    public RoomPos add(RoomDirection direction) {
        return new RoomPos(this.x + direction.xDir, this.y + direction.yDir);
    }

    public CompoundTag serializeNBT() {
        CompoundTag tag = new CompoundTag();
        tag.putInt("roompos_x", this.x);
        tag.putInt("roompos_y", this.y);
        return tag;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof RoomPos)) return false;
        RoomPos other = (RoomPos)obj;
        if (this.x != other.x) return false;
        if (this.y != other.y) return false;
        return true;
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.x, this.y);
    }

    @Override
    public String toString() {
        return "[" + this.x + " " + this.y + "]";
    }
}

