/*
 * Decompiled with CFR 0.152.
 */
package online.kingdomkeys.kingdomkeys.world.dimension.castle_oblivion.system.room;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import online.kingdomkeys.kingdomkeys.world.dimension.castle_oblivion.system.floor.FloorType;
import online.kingdomkeys.kingdomkeys.world.dimension.castle_oblivion.system.registry.JsonRegistryObject;
import online.kingdomkeys.kingdomkeys.world.dimension.castle_oblivion.system.registry.ModFloorTypes;
import online.kingdomkeys.kingdomkeys.world.dimension.castle_oblivion.system.registry.ModRoomTypes;
import online.kingdomkeys.kingdomkeys.world.dimension.castle_oblivion.system.room.RoomCategory;
import online.kingdomkeys.kingdomkeys.world.dimension.castle_oblivion.system.room.RoomSize;
import online.kingdomkeys.kingdomkeys.world.dimension.castle_oblivion.system.room.RoomType;
import org.jetbrains.annotations.Nullable;

public class RoomStructure
extends JsonRegistryObject {
    private String path;
    private RoomSize size;
    private List<RoomCategory> categories;
    @Nullable
    private ResourceLocation floor;
    private int width;
    private int depth;
    private List<ResourceLocation> roomWhitelist;

    public RoomStructure(CompoundTag tag) {
        super(tag);
    }

    public RoomStructure(JsonElement element) {
        super(element);
    }

    public List<RoomType> getRoomWhitelist() {
        return this.roomWhitelist.stream().map(resourceLocation -> ModRoomTypes.registry.get().getValue((ResourceLocation)resourceLocation)).toList();
    }

    public FloorType getFloor() {
        if (this.floor != null) {
            return ModFloorTypes.registry.get().getValue(this.floor);
        }
        return null;
    }

    public String getPath() {
        return this.path;
    }

    public RoomSize getSize() {
        return this.size;
    }

    public int getWidth() {
        return this.width;
    }

    public int getDepth() {
        return this.depth;
    }

    public List<RoomCategory> getCategories() {
        return this.categories;
    }

    @Override
    public CompoundTag serializeNBT() {
        CompoundTag tag = new CompoundTag();
        tag.putString("structure", this.path);
        tag.putInt("size", this.size.ordinal());
        tag.putInt("width", this.width);
        tag.putInt("depth", this.depth);
        CompoundTag categories = new CompoundTag();
        this.categories.forEach(roomCategory -> categories.putInt(roomCategory.name(), roomCategory.ordinal()));
        tag.put("categories", (Tag)categories);
        if (this.floor != null) {
            tag.putString("floor", this.floor.toString());
        }
        CompoundTag whiteList = new CompoundTag();
        if (this.roomWhitelist != null) {
            this.roomWhitelist.forEach(resourceLocation -> whiteList.putString(resourceLocation.toString(), resourceLocation.toString()));
        }
        tag.put("white_list", (Tag)whiteList);
        return tag;
    }

    @Override
    public void deserializeNBT(CompoundTag tag) {
        this.path = tag.getString("structure");
        this.size = RoomSize.values()[tag.getInt("size")];
        this.width = tag.getInt("width");
        this.depth = tag.getInt("depth");
        this.categories = new ArrayList<RoomCategory>();
        CompoundTag cats = tag.getCompound("categories");
        cats.getAllKeys().forEach(s -> this.categories.add(RoomCategory.values()[cats.getInt(s)]));
        if (tag.contains("floor")) {
            this.floor = ResourceLocation.parse((String)tag.getString("floor"));
        }
        this.roomWhitelist = new ArrayList<ResourceLocation>();
        tag.getCompound("white_list").getAllKeys().forEach(s -> this.roomWhitelist.add(ResourceLocation.parse((String)s)));
    }

    @Override
    public void deserializeJson(JsonElement element) throws JsonParseException {
        JsonObject root = RoomStructure.getJsonObject(element);
        root.entrySet().forEach(entry -> {
            JsonElement entryElement = (JsonElement)entry.getValue();
            switch ((String)entry.getKey()) {
                case "structure": {
                    String s = entryElement.getAsString();
                    if (!s.isEmpty()) {
                        this.path = s;
                        break;
                    }
                    throw new JsonParseException("Structure should not be empty");
                }
                case "size": {
                    String s = entryElement.getAsString();
                    if (!s.isEmpty()) {
                        try {
                            this.size = RoomSize.valueOf(s.toUpperCase());
                            break;
                        }
                        catch (IllegalArgumentException e) {
                            throw new JsonParseException("Invalid size, valid values are: S, M, L, SPECIAL");
                        }
                    }
                    throw new JsonParseException("Size should not be empty");
                }
                case "dimensions": {
                    JsonArray dimensions = entryElement.getAsJsonArray();
                    if (dimensions.size() >= 2) {
                        this.width = dimensions.get(0).getAsInt();
                        this.depth = dimensions.get(1).getAsInt();
                        break;
                    }
                    throw new JsonParseException("Dimensions should have 2 values");
                }
                case "categories": {
                    JsonArray categories = entryElement.getAsJsonArray();
                    if (!categories.isEmpty()) {
                        this.categories = new ArrayList<RoomCategory>();
                        categories.forEach(cat -> {
                            String s = cat.getAsString();
                            if (!s.isEmpty()) {
                                try {
                                    this.categories.add(RoomCategory.valueOf(s.toUpperCase()));
                                }
                                catch (IllegalArgumentException e) {
                                    throw new JsonParseException("Invalid category, valid values are: ENEMY, STATUS, BOUNTY, SPECIAL, ANY");
                                }
                            } else {
                                throw new JsonParseException("Category should not be empty");
                            }
                        });
                        break;
                    }
                    throw new JsonParseException("Categories should not be empty");
                }
                case "floor": {
                    String s = entryElement.getAsString();
                    if (s.isEmpty()) break;
                    this.floor = ResourceLocation.parse((String)s);
                    break;
                }
                case "white_list": {
                    JsonArray whitelist = entryElement.getAsJsonArray();
                    if (whitelist.isEmpty()) break;
                    this.roomWhitelist = new ArrayList<ResourceLocation>();
                    whitelist.forEach(wlentry -> {
                        String roomtype = wlentry.getAsString();
                        this.roomWhitelist.add(ResourceLocation.parse((String)roomtype));
                    });
                }
            }
            if (this.roomWhitelist == null) {
                this.roomWhitelist = new ArrayList<ResourceLocation>();
            }
        });
    }

    @Nonnull
    private static JsonObject getJsonObject(JsonElement element) {
        JsonObject root = element.getAsJsonObject();
        if (!root.has("structure")) {
            throw new JsonParseException("Missing required element \"structure\"");
        }
        if (!root.has("size")) {
            throw new JsonParseException("Missing required element \"size\"");
        }
        if (!root.has("dimensions")) {
            throw new JsonParseException("Missing required element \"dimensions\"");
        }
        if (!root.has("categories")) {
            throw new JsonParseException("Missing required element \"categories\"");
        }
        return root;
    }
}

