/*
 * Decompiled with CFR 0.152.
 */
package online.kingdomkeys.kingdomkeys.world.dimension.castle_oblivion.system.room;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import online.kingdomkeys.kingdomkeys.world.dimension.castle_oblivion.system.floor.FloorType;
import online.kingdomkeys.kingdomkeys.world.dimension.castle_oblivion.system.registry.JsonRegistryObject;
import online.kingdomkeys.kingdomkeys.world.dimension.castle_oblivion.system.registry.ModFloorTypes;
import online.kingdomkeys.kingdomkeys.world.dimension.castle_oblivion.system.registry.ModRoomStructures;
import online.kingdomkeys.kingdomkeys.world.dimension.castle_oblivion.system.room.RoomCategory;
import online.kingdomkeys.kingdomkeys.world.dimension.castle_oblivion.system.room.RoomEnemies;
import online.kingdomkeys.kingdomkeys.world.dimension.castle_oblivion.system.room.RoomSize;
import online.kingdomkeys.kingdomkeys.world.dimension.castle_oblivion.system.room.RoomStructure;
import online.kingdomkeys.kingdomkeys.world.dimension.castle_oblivion.system.room.modifiers.RoomModifier;

public class RoomType
extends JsonRegistryObject {
    private boolean entranceHall = false;
    private RoomSize size;
    private RoomCategory category;
    private RoomEnemies enemies;
    private Color colour;
    private List<ResourceLocation> modifiers;
    private List<ResourceLocation> compatibleFloors;
    private ResourceLocation fixedRoom;
    private ResourceLocation music;

    public RoomType(CompoundTag tag) {
        super(tag);
    }

    public RoomType(JsonElement element) {
        super(element);
    }

    @Override
    public ResourceLocation getRegistryName() {
        return this.registryName;
    }

    public String getTranslationKey() {
        return "room." + this.registryName.getPath();
    }

    public boolean isEntranceHall() {
        return this.entranceHall;
    }

    public RoomSize getSize() {
        return this.size;
    }

    public RoomEnemies getEnemies() {
        return this.enemies;
    }

    public RoomCategory getCategory() {
        return this.category;
    }

    public Color getColour() {
        return this.colour;
    }

    public List<RoomModifier> getModifiers() {
        return List.of();
    }

    public boolean isFloorCompatible(FloorType floor) {
        if (this.compatibleFloors.isEmpty()) {
            return true;
        }
        return this.compatibleFloors.contains(floor.getRegistryName());
    }

    public List<FloorType> getCompatibleFloors() {
        return this.compatibleFloors.stream().map(resourceLocation -> ModFloorTypes.registry.get().getValue((ResourceLocation)resourceLocation)).toList();
    }

    public RoomStructure getFixedRoom() {
        if (this.fixedRoom != null) {
            return ModRoomStructures.registry.get().getValue(this.fixedRoom);
        }
        return null;
    }

    public SoundEvent getMusic() {
        if (this.music != null) {
            return (SoundEvent)BuiltInRegistries.SOUND_EVENT.get(this.music);
        }
        return null;
    }

    @Override
    public CompoundTag serializeNBT() {
        CompoundTag tag = new CompoundTag();
        tag.putBoolean("entrance_hall", this.entranceHall);
        tag.putInt("size", this.size.ordinal());
        tag.putInt("category", this.category.ordinal());
        CompoundTag compatibleFloors = new CompoundTag();
        if (this.compatibleFloors != null) {
            this.compatibleFloors.forEach(resourceLocation -> compatibleFloors.putString(resourceLocation.toString(), resourceLocation.toString()));
        }
        tag.put("compatible_floors", (Tag)compatibleFloors);
        CompoundTag modifiers = new CompoundTag();
        if (this.modifiers != null) {
            this.modifiers.forEach(resourceLocation -> modifiers.putString(resourceLocation.toString(), resourceLocation.toString()));
        }
        tag.put("modifiers", (Tag)modifiers);
        if (this.fixedRoom != null) {
            tag.putString("fixed_room", this.fixedRoom.toString());
        }
        if (this.enemies != null) {
            tag.putInt("enemies", this.enemies.ordinal());
        }
        if (this.music != null) {
            tag.putString("music", this.music.toString());
        }
        if (this.colour != null) {
            tag.putInt("colour", this.colour.getRGB());
        }
        return tag;
    }

    @Override
    public void deserializeNBT(CompoundTag tag) {
        this.entranceHall = tag.getBoolean("entrance_hall");
        this.size = RoomSize.values()[tag.getInt("size")];
        this.category = RoomCategory.values()[tag.getInt("category")];
        CompoundTag compatibleFloors = tag.getCompound("compatible_floors");
        this.compatibleFloors = new ArrayList<ResourceLocation>();
        compatibleFloors.getAllKeys().forEach(s -> this.compatibleFloors.add(ResourceLocation.parse((String)s)));
        CompoundTag modifiers = tag.getCompound("modifiers");
        this.modifiers = new ArrayList<ResourceLocation>();
        modifiers.getAllKeys().forEach(s -> this.modifiers.add(ResourceLocation.parse((String)s)));
        if (tag.contains("fixed_room")) {
            this.fixedRoom = ResourceLocation.parse((String)tag.getString("fixed_room"));
        }
        if (tag.contains("enemies")) {
            this.enemies = RoomEnemies.values()[tag.getInt("enemies")];
        }
        if (tag.contains("music")) {
            this.music = ResourceLocation.parse((String)tag.getString("music"));
        }
        if (tag.contains("colour")) {
            this.colour = new Color(tag.getInt("colour"));
        }
    }

    @Override
    public void deserializeJson(JsonElement element) throws JsonParseException {
        JsonObject root = RoomType.getJsonObject(element);
        root.entrySet().forEach(entry -> {
            JsonElement entryElement = (JsonElement)entry.getValue();
            switch ((String)entry.getKey()) {
                case "size": {
                    String s = entryElement.getAsString();
                    if (!s.isEmpty()) {
                        try {
                            this.size = RoomSize.valueOf(s.toUpperCase());
                            break;
                        }
                        catch (IllegalArgumentException e) {
                            throw new JsonParseException("Invalid size, valid values are: S, M, L, SPECIAL");
                        }
                    }
                    throw new JsonParseException("Size should not be empty");
                }
                case "category": {
                    String s = entryElement.getAsString();
                    if (!s.isEmpty()) {
                        try {
                            this.category = RoomCategory.valueOf(s.toUpperCase());
                            break;
                        }
                        catch (IllegalArgumentException e) {
                            throw new JsonParseException("Invalid category, valid values are: ENEMY, STATUS, BOUNTY, SPECIAL, ANY");
                        }
                    }
                    throw new JsonParseException("Category should not be empty");
                }
                case "entrance_hall": {
                    this.entranceHall = entryElement.getAsBoolean();
                    break;
                }
                case "colour": {
                    JsonArray colourArray = entryElement.getAsJsonArray();
                    if (colourArray.size() >= 3) {
                        int r = Math.max(0, Math.min(colourArray.get(0).getAsInt(), 255));
                        int g = Math.max(0, Math.min(colourArray.get(1).getAsInt(), 255));
                        int b = Math.max(0, Math.min(colourArray.get(2).getAsInt(), 255));
                        this.colour = new Color(r, g, b);
                        break;
                    }
                    throw new JsonParseException("Colour should have 3 values");
                }
                case "enemies": {
                    String s = entryElement.getAsString();
                    if (!s.isEmpty()) {
                        try {
                            this.enemies = RoomEnemies.valueOf(s.toUpperCase());
                            break;
                        }
                        catch (IllegalArgumentException e) {
                            throw new JsonParseException("Invalid enemies, valid values are: NONE, S, M, L");
                        }
                    }
                    throw new JsonParseException("Category should not be empty");
                }
                case "compatible_floors": {
                    JsonArray floors = entryElement.getAsJsonArray();
                    if (floors.isEmpty()) break;
                    this.compatibleFloors = new ArrayList<ResourceLocation>();
                    floors.forEach(ftentry -> {
                        String floorType = ftentry.getAsString();
                        this.compatibleFloors.add(ResourceLocation.parse((String)floorType));
                    });
                    break;
                }
                case "modifiers": {
                    JsonArray modifiers = entryElement.getAsJsonArray();
                    if (modifiers.isEmpty()) break;
                    this.modifiers = new ArrayList<ResourceLocation>();
                    modifiers.forEach(mentry -> {
                        String modifier = mentry.getAsString();
                        this.modifiers.add(ResourceLocation.parse((String)modifier));
                    });
                    break;
                }
                case "fixed_room": {
                    String s = entryElement.getAsString();
                    if (s.isEmpty()) break;
                    this.fixedRoom = ResourceLocation.parse((String)s);
                    break;
                }
                case "music": {
                    String s = entryElement.getAsString();
                    if (s.isEmpty()) break;
                    if (BuiltInRegistries.SOUND_EVENT.containsKey(ResourceLocation.parse((String)s))) {
                        this.music = ResourceLocation.parse((String)s);
                        break;
                    }
                    throw new JsonParseException("Supplied music does not exist");
                }
            }
        });
        if (this.enemies == null) {
            this.enemies = RoomEnemies.NONE;
        }
        if (this.modifiers == null) {
            this.modifiers = new ArrayList<ResourceLocation>();
        }
        if (this.compatibleFloors == null) {
            this.compatibleFloors = new ArrayList<ResourceLocation>();
        }
    }

    @Nonnull
    private static JsonObject getJsonObject(JsonElement element) {
        JsonObject root = element.getAsJsonObject();
        if (!root.has("size")) {
            throw new JsonParseException("Missing required element \"size\"");
        }
        if (!root.has("category")) {
            throw new JsonParseException("Missing required element \"category\"");
        }
        return root;
    }
}

