/*
 * Decompiled with CFR 0.152.
 */
package online.kingdomkeys.kingdomkeys.world.dimension.realm_of_darkness;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.MeshData;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.math.Axis;
import net.minecraft.client.Camera;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.DimensionSpecialEffects;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.client.event.RegisterDimensionSpecialEffectsEvent;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4f;

@EventBusSubscriber(value={Dist.CLIENT}, bus=EventBusSubscriber.Bus.MOD)
public class RealmOfDarknessEffects
extends DimensionSpecialEffects {
    static final int r = 100;
    static final int g = 100;
    static final int b = 160;

    public RealmOfDarknessEffects(float pCloudLevel, boolean pHasGround, DimensionSpecialEffects.SkyType pSkyType, boolean pForceBrightLightmap, boolean pConstantAmbientLight) {
        super(pCloudLevel, pHasGround, pSkyType, pForceBrightLightmap, pConstantAmbientLight);
    }

    @SubscribeEvent
    public static void specialEffects(RegisterDimensionSpecialEffectsEvent event) {
        event.register(ResourceLocation.fromNamespaceAndPath((String)"kingdomkeys", (String)"realm_of_darkness"), (DimensionSpecialEffects)new RealmOfDarknessEffects(Float.NaN, true, DimensionSpecialEffects.SkyType.NONE, false, true));
    }

    public Vec3 getBrightnessDependentFogColor(Vec3 pFogColor, float pBrightness) {
        return new Vec3(0.0, 0.0, 0.0);
    }

    public boolean isFoggyAt(int pX, int pY) {
        return true;
    }

    public boolean renderSky(ClientLevel level, int ticks, float partialTick, Matrix4f modelViewMatrix, Camera camera, Matrix4f projectionMatrix, boolean isFoggy, Runnable setupFog) {
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.depthMask((boolean)false);
        RenderSystem.setShader(GameRenderer::getPositionTexColorShader);
        Tesselator tesselator = Tesselator.getInstance();
        Matrix4f frustumMatrix = modelViewMatrix;
        PoseStack posestack = new PoseStack();
        posestack.mulPose(frustumMatrix);
        for (int i = 0; i < 6; ++i) {
            posestack.pushPose();
            RenderSystem.setShaderTexture((int)0, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"kingdomkeys", (String)("textures/environment/skybox_" + i + ".png")));
            if (i == 1) {
                posestack.mulPose(Axis.XP.rotationDegrees(90.0f));
            }
            if (i == 2) {
                posestack.mulPose(Axis.ZP.rotationDegrees(180.0f));
                posestack.mulPose(Axis.XP.rotationDegrees(-90.0f));
            }
            if (i == 3) {
                posestack.mulPose(Axis.XP.rotationDegrees(180.0f));
                posestack.mulPose(Axis.YP.rotationDegrees(-90.0f));
            }
            if (i == 4) {
                posestack.mulPose(Axis.XP.rotationDegrees(90.0f));
                posestack.mulPose(Axis.ZP.rotationDegrees(90.0f));
            }
            if (i == 5) {
                posestack.mulPose(Axis.XP.rotationDegrees(90.0f));
                posestack.mulPose(Axis.ZP.rotationDegrees(-90.0f));
            }
            Matrix4f matrix4f = posestack.last().pose();
            BufferBuilder bufferbuilder = tesselator.begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_TEX_COLOR);
            bufferbuilder.addVertex(matrix4f, -100.0f, -100.0f, -100.0f).setUv(0.0f, 0.0f).setColor(100, 100, 160, 255);
            bufferbuilder.addVertex(matrix4f, -100.0f, -100.0f, 100.0f).setUv(0.0f, 1.0f).setColor(100, 100, 160, 255);
            bufferbuilder.addVertex(matrix4f, 100.0f, -100.0f, 100.0f).setUv(1.0f, 1.0f).setColor(100, 100, 160, 255);
            bufferbuilder.addVertex(matrix4f, 100.0f, -100.0f, -100.0f).setUv(1.0f, 0.0f).setColor(100, 100, 160, 255);
            BufferUploader.drawWithShader((MeshData)bufferbuilder.buildOrThrow());
            posestack.popPose();
        }
        posestack.pushPose();
        RenderSystem.blendFuncSeparate((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
        float f11 = 1.0f - level.getRainLevel(partialTick);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)f11);
        posestack.mulPose(Axis.YP.rotationDegrees(-90.0f));
        posestack.mulPose(Axis.XP.rotationDegrees(level.getTimeOfDay(partialTick) * 360.0f));
        Matrix4f matrix4f1 = posestack.last().pose();
        RenderSystem.setShader(GameRenderer::getPositionTexShader);
        float f12 = 20.0f;
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)ResourceLocation.withDefaultNamespace((String)"textures/environment/moon_phases.png"));
        int k = 0;
        int l = k % 4;
        int i1 = k / 4 % 2;
        float f13 = (float)l / 4.0f;
        float f14 = (float)i1 / 2.0f;
        float f15 = (float)(l + 1) / 4.0f;
        float f16 = (float)(i1 + 1) / 2.0f;
        BufferBuilder bufferbuilder = tesselator.begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_TEX);
        bufferbuilder.addVertex(matrix4f1, -f12, -100.0f, f12).setUv(f15, f16);
        bufferbuilder.addVertex(matrix4f1, f12, -100.0f, f12).setUv(f13, f16);
        bufferbuilder.addVertex(matrix4f1, f12, -100.0f, -f12).setUv(f13, f14);
        bufferbuilder.addVertex(matrix4f1, -f12, -100.0f, -f12).setUv(f15, f14);
        BufferUploader.drawWithShader((MeshData)bufferbuilder.buildOrThrow());
        posestack.popPose();
        RenderSystem.depthMask((boolean)true);
        RenderSystem.disableBlend();
        return true;
    }

    @Nullable
    public float[] getSunriseColor(float pTimeOfDay, float pPartialTicks) {
        return null;
    }
}

