/*
 * Decompiled with CFR 0.152.
 */
package online.kingdomkeys.kingdomkeys.world.structure;

import com.google.common.collect.Lists;
import com.mojang.logging.LogUtils;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.Pools;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.util.SequencedPriorityIterator;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.block.JigsawBlock;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.RandomState;
import net.minecraft.world.level.levelgen.WorldgenRandom;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.PoolElementStructurePiece;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePiecesBuilder;
import net.minecraft.world.level.levelgen.structure.pools.DimensionPadding;
import net.minecraft.world.level.levelgen.structure.pools.EmptyPoolElement;
import net.minecraft.world.level.levelgen.structure.pools.JigsawJunction;
import net.minecraft.world.level.levelgen.structure.pools.StructurePoolElement;
import net.minecraft.world.level.levelgen.structure.pools.StructureTemplatePool;
import net.minecraft.world.level.levelgen.structure.pools.alias.PoolAliasLookup;
import net.minecraft.world.level.levelgen.structure.templatesystem.LiquidSettings;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplateManager;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.apache.commons.lang3.mutable.MutableObject;
import org.slf4j.Logger;

public class JigsawPlacementRotation {
    static final Logger LOGGER = LogUtils.getLogger();

    public static Optional<Structure.GenerationStub> addPieces(Structure.GenerationContext context, Holder<StructureTemplatePool> startPool, Optional<ResourceLocation> startJigsawName, int maxDepth, BlockPos pos, boolean useExpansionHack, Optional<Heightmap.Types> projectStartToHeightmap, int maxDistanceFromCenter, PoolAliasLookup aliasLookup, DimensionPadding dimensionPadding, LiquidSettings liquidSettings, Rotation rotation) {
        BlockPos blockpos;
        RegistryAccess registryaccess = context.registryAccess();
        ChunkGenerator chunkgenerator = context.chunkGenerator();
        StructureTemplateManager structuretemplatemanager = context.structureTemplateManager();
        LevelHeightAccessor levelheightaccessor = context.heightAccessor();
        WorldgenRandom worldgenrandom = context.random();
        Registry registry = registryaccess.registryOrThrow(Registries.TEMPLATE_POOL);
        StructureTemplatePool structuretemplatepool = startPool.unwrapKey().flatMap(p_314915_ -> registry.getOptional(aliasLookup.lookup(p_314915_))).orElse((StructureTemplatePool)startPool.value());
        StructurePoolElement structurepoolelement = structuretemplatepool.getRandomTemplate((RandomSource)worldgenrandom);
        if (structurepoolelement == EmptyPoolElement.INSTANCE) {
            return Optional.empty();
        }
        if (startJigsawName.isPresent()) {
            ResourceLocation resourcelocation = startJigsawName.get();
            Optional<BlockPos> optional = JigsawPlacementRotation.getRandomNamedJigsaw(structurepoolelement, resourcelocation, pos, rotation, structuretemplatemanager, worldgenrandom);
            if (optional.isEmpty()) {
                LOGGER.error("No starting jigsaw {} found in start pool {}", (Object)resourcelocation, (Object)startPool.unwrapKey().map(p_248484_ -> p_248484_.location().toString()).orElse("<unregistered>"));
                return Optional.empty();
            }
            blockpos = optional.get();
        } else {
            blockpos = pos;
        }
        BlockPos vec3i = blockpos.subtract((Vec3i)pos);
        BlockPos blockpos1 = pos.subtract((Vec3i)vec3i);
        PoolElementStructurePiece poolelementstructurepiece = new PoolElementStructurePiece(structuretemplatemanager, structurepoolelement, blockpos1, structurepoolelement.getGroundLevelDelta(), rotation, structurepoolelement.getBoundingBox(structuretemplatemanager, blockpos1, rotation), liquidSettings);
        BoundingBox boundingbox = poolelementstructurepiece.getBoundingBox();
        int i = (boundingbox.maxX() + boundingbox.minX()) / 2;
        int j = (boundingbox.maxZ() + boundingbox.minZ()) / 2;
        int k = projectStartToHeightmap.isPresent() ? pos.getY() + chunkgenerator.getFirstFreeHeight(i, j, projectStartToHeightmap.get(), levelheightaccessor, context.randomState()) : blockpos1.getY();
        int l = boundingbox.minY() + poolelementstructurepiece.getGroundLevelDelta();
        poolelementstructurepiece.move(0, k - l, 0);
        int i1 = k + vec3i.getY();
        return Optional.of(new Structure.GenerationStub(new BlockPos(i, i1, j), p_352014_ -> {
            ArrayList list = Lists.newArrayList();
            list.add(poolelementstructurepiece);
            if (maxDepth > 0) {
                AABB aabb = new AABB((double)(i - maxDistanceFromCenter), (double)Math.max(i1 - maxDistanceFromCenter, levelheightaccessor.getMinBuildHeight() + dimensionPadding.bottom()), (double)(j - maxDistanceFromCenter), (double)(i + maxDistanceFromCenter + 1), (double)Math.min(i1 + maxDistanceFromCenter + 1, levelheightaccessor.getMaxBuildHeight() - dimensionPadding.top()), (double)(j + maxDistanceFromCenter + 1));
                VoxelShape voxelshape = Shapes.join((VoxelShape)Shapes.create((AABB)aabb), (VoxelShape)Shapes.create((AABB)AABB.of((BoundingBox)boundingbox)), (BooleanOp)BooleanOp.ONLY_FIRST);
                JigsawPlacementRotation.addPieces(context.randomState(), maxDepth, useExpansionHack, chunkgenerator, structuretemplatemanager, levelheightaccessor, (RandomSource)worldgenrandom, (Registry<StructureTemplatePool>)registry, poolelementstructurepiece, list, voxelshape, aliasLookup, liquidSettings);
                list.forEach(arg_0 -> ((StructurePiecesBuilder)p_352014_).addPiece(arg_0));
            }
        }));
    }

    private static Optional<BlockPos> getRandomNamedJigsaw(StructurePoolElement element, ResourceLocation startJigsawName, BlockPos pos, Rotation rotation, StructureTemplateManager structureTemplateManager, WorldgenRandom random) {
        List list = element.getShuffledJigsawBlocks(structureTemplateManager, pos, rotation, (RandomSource)random);
        Optional<BlockPos> optional = Optional.empty();
        for (StructureTemplate.StructureBlockInfo structuretemplate$structureblockinfo : list) {
            ResourceLocation resourcelocation = ResourceLocation.tryParse((String)Objects.requireNonNull(structuretemplate$structureblockinfo.nbt(), () -> String.valueOf(structuretemplate$structureblockinfo) + " nbt was null").getString("name"));
            if (!startJigsawName.equals((Object)resourcelocation)) continue;
            optional = Optional.of(structuretemplate$structureblockinfo.pos());
            break;
        }
        return optional;
    }

    private static void addPieces(RandomState randomState, int maxDepth, boolean useExpansionHack, ChunkGenerator chunkGenerator, StructureTemplateManager structureTemplateManager, LevelHeightAccessor level, RandomSource random, Registry<StructureTemplatePool> pools, PoolElementStructurePiece startPiece, List<PoolElementStructurePiece> pieces, VoxelShape free, PoolAliasLookup aliasLookup, LiquidSettings liquidSettings) {
        Placer jigsawplacement$placer = new Placer(pools, maxDepth, chunkGenerator, structureTemplateManager, pieces, random);
        jigsawplacement$placer.tryPlacingChildren(startPiece, (MutableObject<VoxelShape>)new MutableObject((Object)free), 0, useExpansionHack, level, randomState, aliasLookup, liquidSettings);
        while (jigsawplacement$placer.placing.hasNext()) {
            PieceState jigsawplacement$piecestate = (PieceState)jigsawplacement$placer.placing.next();
            jigsawplacement$placer.tryPlacingChildren(jigsawplacement$piecestate.piece, jigsawplacement$piecestate.free, jigsawplacement$piecestate.depth, useExpansionHack, level, randomState, aliasLookup, liquidSettings);
        }
    }

    static final class Placer {
        private final Registry<StructureTemplatePool> pools;
        private final int maxDepth;
        private final ChunkGenerator chunkGenerator;
        private final StructureTemplateManager structureTemplateManager;
        private final List<? super PoolElementStructurePiece> pieces;
        private final RandomSource random;
        final SequencedPriorityIterator<PieceState> placing = new SequencedPriorityIterator();

        Placer(Registry<StructureTemplatePool> pools, int maxDepth, ChunkGenerator chunkGenerator, StructureTemplateManager structureTemplateManager, List<? super PoolElementStructurePiece> pieces, RandomSource random) {
            this.pools = pools;
            this.maxDepth = maxDepth;
            this.chunkGenerator = chunkGenerator;
            this.structureTemplateManager = structureTemplateManager;
            this.pieces = pieces;
            this.random = random;
        }

        void tryPlacingChildren(PoolElementStructurePiece piece, MutableObject<VoxelShape> free, int depth, boolean useExpansionHack, LevelHeightAccessor level, RandomState random, PoolAliasLookup poolAliasLookup, LiquidSettings liquidSettings) {
            StructurePoolElement structurepoolelement = piece.getElement();
            BlockPos blockpos = piece.getPosition();
            Rotation rotation = piece.getRotation();
            StructureTemplatePool.Projection structuretemplatepool$projection = structurepoolelement.getProjection();
            boolean flag = structuretemplatepool$projection == StructureTemplatePool.Projection.RIGID;
            MutableObject<VoxelShape> mutableobject = new MutableObject<VoxelShape>();
            BoundingBox boundingbox = piece.getBoundingBox();
            int i = boundingbox.minY();
            block0: for (StructureTemplate.StructureBlockInfo structuretemplate$structureblockinfo : structurepoolelement.getShuffledJigsawBlocks(this.structureTemplateManager, blockpos, rotation, this.random)) {
                StructurePoolElement structurepoolelement1;
                MutableObject<VoxelShape> mutableobject1;
                Direction direction = JigsawBlock.getFrontFacing((BlockState)structuretemplate$structureblockinfo.state());
                BlockPos blockpos1 = structuretemplate$structureblockinfo.pos();
                BlockPos blockpos2 = blockpos1.relative(direction);
                int j = blockpos1.getY() - i;
                int k = -1;
                ResourceKey<StructureTemplatePool> resourcekey = Placer.readPoolKey(structuretemplate$structureblockinfo, poolAliasLookup);
                Optional optional = this.pools.getHolder(resourcekey);
                if (optional.isEmpty()) {
                    LOGGER.warn("Empty or non-existent pool: {}", (Object)resourcekey.location());
                    continue;
                }
                Holder holder = (Holder)optional.get();
                if (((StructureTemplatePool)holder.value()).size() == 0 && !holder.is(Pools.EMPTY)) {
                    LOGGER.warn("Empty or non-existent pool: {}", (Object)resourcekey.location());
                    continue;
                }
                Holder holder1 = ((StructureTemplatePool)holder.value()).getFallback();
                if (((StructureTemplatePool)holder1.value()).size() == 0 && !holder1.is(Pools.EMPTY)) {
                    LOGGER.warn("Empty or non-existent fallback pool: {}", (Object)holder1.unwrapKey().map(p_255599_ -> p_255599_.location().toString()).orElse("<unregistered>"));
                    continue;
                }
                boolean flag1 = boundingbox.isInside((Vec3i)blockpos2);
                if (flag1) {
                    mutableobject1 = mutableobject;
                    if (mutableobject.getValue() == null) {
                        mutableobject.setValue((Object)Shapes.create((AABB)AABB.of((BoundingBox)boundingbox)));
                    }
                } else {
                    mutableobject1 = free;
                }
                ArrayList list = Lists.newArrayList();
                if (depth != this.maxDepth) {
                    list.addAll(((StructureTemplatePool)holder.value()).getShuffledTemplates(this.random));
                }
                list.addAll(((StructureTemplatePool)holder1.value()).getShuffledTemplates(this.random));
                int l = structuretemplate$structureblockinfo.nbt() != null ? structuretemplate$structureblockinfo.nbt().getInt("placement_priority") : 0;
                Iterator iterator = list.iterator();
                while (iterator.hasNext() && (structurepoolelement1 = (StructurePoolElement)iterator.next()) != EmptyPoolElement.INSTANCE) {
                    for (Rotation rotation1 : Rotation.getShuffled((RandomSource)this.random)) {
                        List list1 = structurepoolelement1.getShuffledJigsawBlocks(this.structureTemplateManager, BlockPos.ZERO, rotation1, this.random);
                        BoundingBox boundingbox1 = structurepoolelement1.getBoundingBox(this.structureTemplateManager, BlockPos.ZERO, rotation1);
                        int i1 = useExpansionHack && boundingbox1.getYSpan() <= 16 ? list1.stream().mapToInt(p_255598_ -> {
                            if (!boundingbox1.isInside((Vec3i)p_255598_.pos().relative(JigsawBlock.getFrontFacing((BlockState)p_255598_.state())))) {
                                return 0;
                            }
                            ResourceKey<StructureTemplatePool> resourcekey1 = Placer.readPoolKey(p_255598_, poolAliasLookup);
                            Optional optional1 = this.pools.getHolder(resourcekey1);
                            Optional<Holder> optional2 = optional1.map(p_255600_ -> ((StructureTemplatePool)p_255600_.value()).getFallback());
                            int k3 = optional1.map(p_255596_ -> ((StructureTemplatePool)p_255596_.value()).getMaxSize(this.structureTemplateManager)).orElse(0);
                            int l3 = optional2.map(p_255601_ -> ((StructureTemplatePool)p_255601_.value()).getMaxSize(this.structureTemplateManager)).orElse(0);
                            return Math.max(k3, l3);
                        }).max().orElse(0) : 0;
                        for (StructureTemplate.StructureBlockInfo structuretemplate$structureblockinfo1 : list1) {
                            int i3;
                            int i2;
                            if (!JigsawBlock.canAttach((StructureTemplate.StructureBlockInfo)structuretemplate$structureblockinfo, (StructureTemplate.StructureBlockInfo)structuretemplate$structureblockinfo1)) continue;
                            BlockPos blockpos3 = structuretemplate$structureblockinfo1.pos();
                            BlockPos blockpos4 = blockpos2.subtract((Vec3i)blockpos3);
                            BoundingBox boundingbox2 = structurepoolelement1.getBoundingBox(this.structureTemplateManager, blockpos4, rotation1);
                            int j1 = boundingbox2.minY();
                            StructureTemplatePool.Projection structuretemplatepool$projection1 = structurepoolelement1.getProjection();
                            boolean flag2 = structuretemplatepool$projection1 == StructureTemplatePool.Projection.RIGID;
                            int k1 = blockpos3.getY();
                            int l1 = j - k1 + JigsawBlock.getFrontFacing((BlockState)structuretemplate$structureblockinfo.state()).getStepY();
                            if (flag && flag2) {
                                i2 = i + l1;
                            } else {
                                if (k == -1) {
                                    k = this.chunkGenerator.getFirstFreeHeight(blockpos1.getX(), blockpos1.getZ(), Heightmap.Types.WORLD_SURFACE_WG, level, random);
                                }
                                i2 = k - k1;
                            }
                            int j2 = i2 - j1;
                            BoundingBox boundingbox3 = boundingbox2.moved(0, j2, 0);
                            BlockPos blockpos5 = blockpos4.offset(0, j2, 0);
                            if (i1 > 0) {
                                int k2 = Math.max(i1 + 1, boundingbox3.maxY() - boundingbox3.minY());
                                boundingbox3.encapsulate(new BlockPos(boundingbox3.minX(), boundingbox3.minY() + k2, boundingbox3.minZ()));
                            }
                            if (Shapes.joinIsNotEmpty((VoxelShape)((VoxelShape)mutableobject1.getValue()), (VoxelShape)Shapes.create((AABB)AABB.of((BoundingBox)boundingbox3).deflate(0.25)), (BooleanOp)BooleanOp.ONLY_SECOND)) continue;
                            mutableobject1.setValue((Object)Shapes.joinUnoptimized((VoxelShape)((VoxelShape)mutableobject1.getValue()), (VoxelShape)Shapes.create((AABB)AABB.of((BoundingBox)boundingbox3)), (BooleanOp)BooleanOp.ONLY_FIRST));
                            int j3 = piece.getGroundLevelDelta();
                            int l2 = flag2 ? j3 - l1 : structurepoolelement1.getGroundLevelDelta();
                            PoolElementStructurePiece poolelementstructurepiece = new PoolElementStructurePiece(this.structureTemplateManager, structurepoolelement1, blockpos5, l2, rotation1, boundingbox3, liquidSettings);
                            if (flag) {
                                i3 = i + j;
                            } else if (flag2) {
                                i3 = i2 + k1;
                            } else {
                                if (k == -1) {
                                    k = this.chunkGenerator.getFirstFreeHeight(blockpos1.getX(), blockpos1.getZ(), Heightmap.Types.WORLD_SURFACE_WG, level, random);
                                }
                                i3 = k + l1 / 2;
                            }
                            piece.addJunction(new JigsawJunction(blockpos2.getX(), i3 - j + j3, blockpos2.getZ(), l1, structuretemplatepool$projection1));
                            poolelementstructurepiece.addJunction(new JigsawJunction(blockpos1.getX(), i3 - k1 + l2, blockpos1.getZ(), -l1, structuretemplatepool$projection));
                            this.pieces.add((PoolElementStructurePiece)poolelementstructurepiece);
                            if (depth + 1 > this.maxDepth) continue block0;
                            PieceState jigsawplacement$piecestate = new PieceState(poolelementstructurepiece, mutableobject1, depth + 1);
                            this.placing.add((Object)jigsawplacement$piecestate, l);
                            continue block0;
                        }
                    }
                }
            }
        }

        private static ResourceKey<StructureTemplatePool> readPoolKey(StructureTemplate.StructureBlockInfo blockInfo, PoolAliasLookup aliasLookup) {
            CompoundTag compoundtag = Objects.requireNonNull(blockInfo.nbt(), () -> String.valueOf(blockInfo) + " nbt was null");
            ResourceKey resourcekey = Pools.parseKey((String)compoundtag.getString("pool"));
            return aliasLookup.lookup(resourcekey);
        }
    }

    record PieceState(PoolElementStructurePiece piece, MutableObject<VoxelShape> free, int depth) {
    }
}

