/*
 * Decompiled with CFR 0.152.
 */
package online.kingdomkeys.kingdomkeys;

import com.google.common.base.Suppliers;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.datafixers.util.Pair;
import java.util.List;
import java.util.Objects;
import java.util.function.Supplier;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.advancements.CriterionTrigger;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.levelgen.structure.pools.SinglePoolElement;
import net.minecraft.world.level.levelgen.structure.pools.StructurePoolElement;
import net.minecraft.world.level.levelgen.structure.pools.StructureTemplatePool;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.AddReloadListenerEvent;
import net.minecraftforge.event.RegisterCommandsEvent;
import net.minecraftforge.event.server.ServerAboutToStartEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLLoadCompleteEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.RegistryObject;
import online.kingdomkeys.kingdomkeys.ability.ModAbilities;
import online.kingdomkeys.kingdomkeys.advancements.KKLevelUpTrigger;
import online.kingdomkeys.kingdomkeys.api.event.client.CommandMenuEvent;
import online.kingdomkeys.kingdomkeys.block.ModBlocks;
import online.kingdomkeys.kingdomkeys.capability.ModCapabilities;
import online.kingdomkeys.kingdomkeys.client.gui.overlay.CommandMenuGui;
import online.kingdomkeys.kingdomkeys.client.sound.ModSounds;
import online.kingdomkeys.kingdomkeys.command.ModCommands;
import online.kingdomkeys.kingdomkeys.config.ModConfigs;
import online.kingdomkeys.kingdomkeys.container.ModContainers;
import online.kingdomkeys.kingdomkeys.datagen.DataGeneration;
import online.kingdomkeys.kingdomkeys.driveform.DriveFormDataLoader;
import online.kingdomkeys.kingdomkeys.driveform.ModDriveForms;
import online.kingdomkeys.kingdomkeys.effects.ModMobEffects;
import online.kingdomkeys.kingdomkeys.entity.ModEntities;
import online.kingdomkeys.kingdomkeys.handler.ClientEvents;
import online.kingdomkeys.kingdomkeys.handler.EntityEvents;
import online.kingdomkeys.kingdomkeys.integration.epicfight.EpicFightRendering;
import online.kingdomkeys.kingdomkeys.integration.epicfight.init.EpicKKWeapons;
import online.kingdomkeys.kingdomkeys.integration.epicfight.init.KKAnimations;
import online.kingdomkeys.kingdomkeys.integration.epicfight.skills.ComboExtender;
import online.kingdomkeys.kingdomkeys.integration.epicfight.skills.KKSkills;
import online.kingdomkeys.kingdomkeys.item.KKAccessoryItem;
import online.kingdomkeys.kingdomkeys.item.KKArmorItem;
import online.kingdomkeys.kingdomkeys.item.KKPotionItem;
import online.kingdomkeys.kingdomkeys.item.KeybladeItem;
import online.kingdomkeys.kingdomkeys.item.KeychainItem;
import online.kingdomkeys.kingdomkeys.item.ModItems;
import online.kingdomkeys.kingdomkeys.item.organization.IOrgWeapon;
import online.kingdomkeys.kingdomkeys.item.organization.OrganizationDataLoader;
import online.kingdomkeys.kingdomkeys.leveling.LevelingDataLoader;
import online.kingdomkeys.kingdomkeys.leveling.ModLevels;
import online.kingdomkeys.kingdomkeys.limit.LimitDataLoader;
import online.kingdomkeys.kingdomkeys.limit.ModLimits;
import online.kingdomkeys.kingdomkeys.loot.ModLootModifier;
import online.kingdomkeys.kingdomkeys.magic.MagicDataLoader;
import online.kingdomkeys.kingdomkeys.magic.ModMagic;
import online.kingdomkeys.kingdomkeys.network.PacketHandler;
import online.kingdomkeys.kingdomkeys.reactioncommands.ModReactionCommands;
import online.kingdomkeys.kingdomkeys.shotlock.ModShotlocks;
import online.kingdomkeys.kingdomkeys.synthesis.keybladeforge.KeybladeDataLoader;
import online.kingdomkeys.kingdomkeys.synthesis.recipe.RecipeDataLoader;
import online.kingdomkeys.kingdomkeys.synthesis.shop.ShopListDataLoader;
import online.kingdomkeys.kingdomkeys.synthesis.shop.names.NamesListLoader;
import online.kingdomkeys.kingdomkeys.world.SavePointStorage;
import online.kingdomkeys.kingdomkeys.world.dimension.ModDimensions;
import online.kingdomkeys.kingdomkeys.world.dimension.castle_oblivion.CastleOblivionHandler;
import online.kingdomkeys.kingdomkeys.world.dimension.castle_oblivion.system.registry.ModJsonRegistries;
import online.kingdomkeys.kingdomkeys.world.features.ModFeatures;
import online.kingdomkeys.kingdomkeys.world.structure.ModStructures;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="kingdomkeys")
public class KingdomKeys {
    public static final Logger LOGGER = LogManager.getLogger();
    public static final String MODID = "kingdomkeys";
    public static final String MODNAME = "Kingdom Keys";
    public static boolean efmLoaded = false;
    public static final DeferredRegister<CreativeModeTab> TABS = DeferredRegister.create((ResourceKey)Registries.f_279569_, (String)"kingdomkeys");
    private static final Supplier<List<ItemStack>> kkItems = Suppliers.memoize(() -> ModItems.ITEMS.getEntries().stream().map(RegistryObject::get).map(ItemStack::new).toList());
    private static final Supplier<List<ItemStack>> orgWeapons = Suppliers.memoize(() -> kkItems.get().stream().filter(item -> item.m_41720_() instanceof IOrgWeapon).toList());
    private static final Supplier<List<ItemStack>> keyblades = Suppliers.memoize(() -> kkItems.get().stream().filter(item -> item.m_41720_() instanceof KeybladeItem).toList());
    private static final Supplier<List<ItemStack>> keychains = Suppliers.memoize(() -> kkItems.get().stream().filter(item -> item.m_41720_() instanceof KeychainItem).toList());
    private static final Supplier<List<ItemStack>> equipables = Suppliers.memoize(() -> kkItems.get().stream().filter(item -> item.m_41720_() instanceof KKPotionItem || item.m_41720_() instanceof KKArmorItem || item.m_41720_() instanceof KKAccessoryItem).toList());
    private static final Supplier<List<ItemStack>> misc = Suppliers.memoize(() -> kkItems.get().stream().filter(item -> !(item.m_41720_() instanceof KeybladeItem) && !(item.m_41720_() instanceof KeychainItem) && !(item.m_41720_() instanceof IOrgWeapon) && !(item.m_41720_() instanceof KKPotionItem) && !(item.m_41720_() instanceof KKArmorItem) && !(item.m_41720_() instanceof KKAccessoryItem)).toList());
    public static final RegistryObject<CreativeModeTab> keyblades_tab = TABS.register("kingdomkeys_keyblades", () -> CreativeModeTab.builder().m_257941_((Component)Component.m_237115_((String)"itemGroup.kingdomkeys_keyblades")).m_257737_(() -> {
        List<ItemStack> keybladesList = keyblades.get();
        return keybladesList.get((int)(System.currentTimeMillis() / 1500L) % keybladesList.size());
    }).m_257501_((params, output) -> {
        keyblades.get().forEach(arg_0 -> ((CreativeModeTab.Output)output).m_246342_(arg_0));
        keychains.get().forEach(arg_0 -> ((CreativeModeTab.Output)output).m_246342_(arg_0));
    }).withSearchBar(71).withBackgroundLocation(new ResourceLocation(MODID, "textures/gui/container/tab_kk.png")).m_257809_().m_257652_());
    public static final RegistryObject<CreativeModeTab> organization_tab = TABS.register("kingdomkeys_org_weapons", () -> CreativeModeTab.builder().m_257941_((Component)Component.m_237115_((String)"itemGroup.kingdomkeys_org_weapons")).m_257737_(() -> {
        List<ItemStack> orgWeaponsList = orgWeapons.get();
        return orgWeaponsList.get((int)(System.currentTimeMillis() / 1500L) % orgWeaponsList.size());
    }).m_257501_((params, output) -> orgWeapons.get().forEach(arg_0 -> ((CreativeModeTab.Output)output).m_246342_(arg_0))).withSearchBar(71).withBackgroundLocation(new ResourceLocation(MODID, "textures/gui/container/tab_kk.png")).m_257809_().m_257652_());
    public static final RegistryObject<CreativeModeTab> equipables_tab = TABS.register("kingdomkeys_equipables", () -> CreativeModeTab.builder().m_257941_((Component)Component.m_237115_((String)"itemGroup.kingdomkeys_equipables")).m_257737_(() -> {
        List<ItemStack> equipablesList = equipables.get();
        return equipablesList.get((int)(System.currentTimeMillis() / 1500L) % equipablesList.size());
    }).m_257501_((params, output) -> equipables.get().forEach(arg_0 -> ((CreativeModeTab.Output)output).m_246342_(arg_0))).withSearchBar(71).withBackgroundLocation(new ResourceLocation(MODID, "textures/gui/container/tab_kk.png")).m_257809_().m_257652_());
    public static final RegistryObject<CreativeModeTab> misc_tab = TABS.register("kingdomkeys_misc", () -> CreativeModeTab.builder().m_257941_((Component)Component.m_237115_((String)"itemGroup.kingdomkeys_misc")).m_257737_(() -> new ItemStack((ItemLike)ModBlocks.normalBlox.get())).m_257501_((params, output) -> {
        misc.get().forEach(arg_0 -> ((CreativeModeTab.Output)output).m_246342_(arg_0));
        ItemStack linkedSavePoint = new ItemStack((ItemLike)ModBlocks.savepoint.get());
        linkedSavePoint.m_41751_(new CompoundTag());
        linkedSavePoint.m_41783_().m_128359_("tier", SavePointStorage.SavePointType.LINKED.m_7912_().toUpperCase());
        ItemStack warpPoint = new ItemStack((ItemLike)ModBlocks.savepoint.get());
        warpPoint.m_41751_(new CompoundTag());
        warpPoint.m_41783_().m_128359_("tier", SavePointStorage.SavePointType.WARP.m_7912_().toUpperCase());
        output.m_246342_(linkedSavePoint);
        output.m_246342_(warpPoint);
    }).withSearchBar(71).withBackgroundLocation(new ResourceLocation(MODID, "textures/gui/container/tab_kk.png")).m_257809_().m_257652_());

    public KingdomKeys() {
        ModLoadingContext modLoadingContext = ModLoadingContext.get();
        final IEventBus modEventBus = FMLJavaModLoadingContext.get().getModEventBus();
        ModMagic.MAGIC.register(modEventBus);
        ModDriveForms.DRIVE_FORMS.register(modEventBus);
        ModAbilities.ABILITIES.register(modEventBus);
        ModLevels.LEVELS.register(modEventBus);
        ModLimits.LIMITS.register(modEventBus);
        ModShotlocks.SHOTLOCKS.register(modEventBus);
        ModReactionCommands.REACTION_COMMANDS.register(modEventBus);
        ModBlocks.BLOCKS.register(modEventBus);
        ModItems.ITEMS.register(modEventBus);
        ModSounds.SOUNDS.register(modEventBus);
        ModEntities.TILE_ENTITIES.register(modEventBus);
        ModContainers.CONTAINERS.register(modEventBus);
        ModLootModifier.LOOT_MODIFIERS.register(modEventBus);
        ModMobEffects.MOB_EFFECTS.register(modEventBus);
        TABS.register(modEventBus);
        ModEntities.ENTITIES.register(modEventBus);
        ModFeatures.RULE_TESTS.register(modEventBus);
        ModFeatures.FEATURES.register(modEventBus);
        ModDimensions.CHUNK_GENERATORS.register(modEventBus);
        ModStructures.STRUCTURES.register(modEventBus);
        ModJsonRegistries.JSON_REGISTRIES.register(modEventBus);
        modEventBus.addListener(this::setup);
        modEventBus.addListener(this::modLoaded);
        DistExecutor.safeRunWhenOn((Dist)Dist.CLIENT, () -> new DistExecutor.SafeRunnable(){

            public void run() {
                modEventBus.addListener(ClientEvents::colourTint);
                modEventBus.addListener(ClientEvents::itemColour);
            }
        });
        if (ModList.get().isLoaded("epicfight")) {
            efmLoaded = true;
            modEventBus.addListener(KKAnimations::register);
            modEventBus.addListener(EpicKKWeapons::register);
            MinecraftForge.EVENT_BUS.register((Object)new KKSkills());
            KKSkills.SKILLS.register(modEventBus);
            ComboExtender.DATA_KEYS.register(modEventBus);
        }
        MinecraftForge.EVENT_BUS.register((Object)this);
        MinecraftForge.EVENT_BUS.register((Object)new DataGeneration());
        MinecraftForge.EVENT_BUS.register((Object)new CastleOblivionHandler());
        modLoadingContext.registerConfig(ModConfig.Type.CLIENT, (IConfigSpec)ModConfigs.CLIENT_SPEC);
        modLoadingContext.registerConfig(ModConfig.Type.COMMON, (IConfigSpec)ModConfigs.COMMON_SPEC);
        modLoadingContext.registerConfig(ModConfig.Type.SERVER, (IConfigSpec)ModConfigs.SERVER_SPEC);
        MinecraftForge.EVENT_BUS.register((Object)new EntityEvents());
        MinecraftForge.EVENT_BUS.register((Object)new ModCapabilities());
    }

    private void setup(FMLCommonSetupEvent event) {
        event.enqueueWork(PacketHandler::register);
        KKLevelUpTrigger.TRIGGER_LEVELUP = (KKLevelUpTrigger)CriteriaTriggers.m_10595_((CriterionTrigger)new KKLevelUpTrigger());
    }

    private void modLoaded(FMLLoadCompleteEvent event) {
        DistExecutor.safeRunWhenOn((Dist)Dist.CLIENT, () -> new DistExecutor.SafeRunnable(){

            public void run() {
                if (ModList.get().isLoaded("epicfight")) {
                    FMLJavaModLoadingContext.get().getModEventBus().addListener(EpicFightRendering::patchedRenderersEventModify);
                }
                CommandMenuGui.INSTANCE.initCommandMenu();
                MinecraftForge.EVENT_BUS.post((Event)new CommandMenuEvent.Construct(CommandMenuGui.INSTANCE));
            }
        });
    }

    @SubscribeEvent
    public void addMoogleHouse(ServerAboutToStartEvent event) {
        this.addPieceToPattern((RegistryAccess)event.getServer().m_206579_(), new ResourceLocation("village/plains/houses"), new ResourceLocation(MODID, "village/moogle_house_plains"), 2);
        this.addPieceToPattern((RegistryAccess)event.getServer().m_206579_(), new ResourceLocation("village/desert/houses"), new ResourceLocation(MODID, "village/moogle_house_desert"), 2);
        this.addPieceToPattern((RegistryAccess)event.getServer().m_206579_(), new ResourceLocation("village/savanna/houses"), new ResourceLocation(MODID, "village/moogle_house_savanna"), 2);
        this.addPieceToPattern((RegistryAccess)event.getServer().m_206579_(), new ResourceLocation("village/snowy/houses"), new ResourceLocation(MODID, "village/moogle_house_snowy"), 2);
        this.addPieceToPattern((RegistryAccess)event.getServer().m_206579_(), new ResourceLocation("village/taiga/houses"), new ResourceLocation(MODID, "village/moogle_house_taiga"), 2);
    }

    public void addPieceToPattern(RegistryAccess registryAccess, ResourceLocation pattern, ResourceLocation structure, int weight) {
        Registry registry = registryAccess.m_175515_(Registries.f_256948_);
        StructureTemplatePool pat = Objects.requireNonNull((StructureTemplatePool)registry.m_7745_(pattern));
        SinglePoolElement piece = (SinglePoolElement)StructurePoolElement.m_210507_((String)structure.toString()).apply(StructureTemplatePool.Projection.RIGID);
        for (int i = 0; i < weight; ++i) {
            pat.f_210560_.add((Object)piece);
        }
        pat.f_210559_ = List.of(Pair.of((Object)piece, (Object)weight));
    }

    @SubscribeEvent
    public void registerCommands(RegisterCommandsEvent event) {
        CommandDispatcher dispatcher = event.getDispatcher();
        ModCommands.register((CommandDispatcher<CommandSourceStack>)dispatcher);
    }

    @SubscribeEvent
    public void addReloadListeners(AddReloadListenerEvent event) {
        event.addListener((PreparableReloadListener)new KeybladeDataLoader());
        event.addListener((PreparableReloadListener)new OrganizationDataLoader());
        event.addListener((PreparableReloadListener)new RecipeDataLoader());
        event.addListener((PreparableReloadListener)new DriveFormDataLoader());
        event.addListener((PreparableReloadListener)new MagicDataLoader());
        event.addListener((PreparableReloadListener)new LevelingDataLoader());
        event.addListener((PreparableReloadListener)new NamesListLoader.Loader());
        event.addListener((PreparableReloadListener)new ShopListDataLoader());
        event.addListener((PreparableReloadListener)new LimitDataLoader());
        ModJsonRegistries.registry.get().forEach(arg_0 -> ((AddReloadListenerEvent)event).addListener(arg_0));
    }
}

