/*
 * Decompiled with CFR 0.152.
 */
package online.kingdomkeys.kingdomkeys.block;

import java.util.List;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import online.kingdomkeys.kingdomkeys.block.BaseBlock;
import online.kingdomkeys.kingdomkeys.block.INoDataGen;
import online.kingdomkeys.kingdomkeys.capability.IWorldCapabilities;
import online.kingdomkeys.kingdomkeys.capability.ModCapabilities;
import online.kingdomkeys.kingdomkeys.entity.ModEntities;
import online.kingdomkeys.kingdomkeys.entity.block.OrgPortalTileEntity;
import online.kingdomkeys.kingdomkeys.lib.PortalData;
import online.kingdomkeys.kingdomkeys.network.PacketHandler;
import online.kingdomkeys.kingdomkeys.network.stc.SCShowOrgPortalGUI;
import online.kingdomkeys.kingdomkeys.util.Utils;

public class OrgPortalBlock
extends BaseBlock
implements EntityBlock,
INoDataGen {
    private static final VoxelShape collisionShape = Block.m_49796_((double)1.0, (double)0.0, (double)1.0, (double)16.0, (double)1.0, (double)16.0);

    public OrgPortalBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    public VoxelShape m_5939_(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        return collisionShape;
    }

    public VoxelShape m_7952_(BlockState state, BlockGetter worldIn, BlockPos pos) {
        return collisionShape;
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        return Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)2.0, (double)16.0);
    }

    public RenderShape m_7514_(BlockState state) {
        return RenderShape.MODEL;
    }

    public void m_6402_(Level worldIn, BlockPos pos, BlockState state, LivingEntity placer, ItemStack stack) {
        if (!worldIn.f_46443_ && placer instanceof Player) {
            Player player = (Player)placer;
            OrgPortalTileEntity te = (OrgPortalTileEntity)worldIn.m_7702_(pos);
            IWorldCapabilities worldData = ModCapabilities.getWorld(worldIn);
            List<UUID> portals = worldData.getAllPortalsFromOwnerID(player.m_20148_());
            if (portals.size() < 3) {
                UUID portalUUID = UUID.randomUUID();
                worldData.addPortal(portalUUID, new PortalData(portalUUID, "Portal", pos.m_123341_(), pos.m_123342_() - 1, pos.m_123343_(), (ResourceKey<Level>)player.m_9236_().m_46472_(), player.m_20148_()));
                Utils.syncWorldData(worldIn, worldData);
                player.m_5661_((Component)Component.m_237115_((String)(String.valueOf(ChatFormatting.GREEN) + "This is now your portal")), true);
                te.setUUID(portalUUID);
                te.m_6596_();
                PacketHandler.sendTo(new SCShowOrgPortalGUI(te.m_58899_()), (ServerPlayer)player);
            } else {
                player.m_5661_((Component)Component.m_237115_((String)(String.valueOf(ChatFormatting.RED) + "You have no empty slots for portals")), true);
            }
        }
        super.m_6402_(worldIn, pos, state, placer, stack);
    }

    public InteractionResult m_6227_(BlockState state, Level worldIn, BlockPos pos, Player player, InteractionHand handIn, BlockHitResult hit) {
        if (!worldIn.f_46443_ && ModCapabilities.getPlayer(player).getAlignment() != Utils.OrgMember.NONE && worldIn.m_7702_(pos) instanceof OrgPortalTileEntity) {
            OrgPortalTileEntity te = (OrgPortalTileEntity)worldIn.m_7702_(pos);
            IWorldCapabilities worldData = ModCapabilities.getWorld(worldIn);
            if (te.getUUID() != null) {
                if (worldData.getOwnerIDFromUUID(te.getUUID()).equals(player.m_20148_())) {
                    List<UUID> portals = worldData.getAllPortalsFromOwnerID(player.m_20148_());
                    int i = 0;
                    for (i = 0; i < portals.size() && !portals.get(i).equals(te.getUUID()); i = (int)((byte)(i + 1))) {
                    }
                    PacketHandler.sendTo(new SCShowOrgPortalGUI(te.m_58899_()), (ServerPlayer)player);
                    player.m_5661_((Component)Component.m_237115_((String)(String.valueOf(ChatFormatting.YELLOW) + "This is your portal " + (i + 1) + ": " + worldData.getPortalFromUUID(portals.get(i)).getName())), true);
                } else {
                    player.m_5661_((Component)Component.m_237115_((String)(String.valueOf(ChatFormatting.RED) + "This portal belongs to " + worldIn.m_46003_(worldData.getOwnerIDFromUUID(te.getUUID())).m_5446_().getString())), true);
                    return InteractionResult.SUCCESS;
                }
            }
        }
        return InteractionResult.SUCCESS;
    }

    public void m_6810_(BlockState state, Level worldIn, BlockPos pos, BlockState newState, boolean isMoving) {
        if (!worldIn.f_46443_ && worldIn.m_7702_(pos) instanceof OrgPortalTileEntity) {
            OrgPortalTileEntity te = (OrgPortalTileEntity)worldIn.m_7702_(pos);
            UUID portalID = te.getUUID();
            te.m_7651_();
            if (portalID != null) {
                IWorldCapabilities worldData = ModCapabilities.getWorld(worldIn);
                UUID ownerUUID = worldData.getOwnerIDFromUUID(portalID);
                ModCapabilities.getWorld(worldIn).removePortal(portalID);
                ServerPlayer player = worldIn.m_7654_().m_6846_().m_11259_(ownerUUID);
                if (player != null) {
                    Utils.syncWorldData(worldIn, worldData);
                    player.m_5661_((Component)Component.m_237115_((String)(String.valueOf(ChatFormatting.RED) + "Portal destination disappeared")), true);
                }
            }
        }
        super.m_6810_(state, worldIn, pos, newState, isMoving);
    }

    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level level, BlockState state, BlockEntityType<T> type) {
        return type == ModEntities.TYPE_ORG_PORTAL_TE.get() ? OrgPortalTileEntity::tick : null;
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pPos, BlockState pState) {
        return ((BlockEntityType)ModEntities.TYPE_ORG_PORTAL_TE.get()).m_155264_(pPos, pState);
    }
}

