/*
 * Decompiled with CFR 0.152.
 */
package online.kingdomkeys.kingdomkeys.capability;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.common.util.LazyOptional;
import online.kingdomkeys.kingdomkeys.capability.ModCapabilities;
import online.kingdomkeys.kingdomkeys.world.dimension.castle_oblivion.system.floor.Floor;
import online.kingdomkeys.kingdomkeys.world.dimension.castle_oblivion.system.room.Room;
import online.kingdomkeys.kingdomkeys.world.dimension.castle_oblivion.system.room.RoomData;

public class CastleOblivionCapabilities {

    public static class ExteriorProvider
    implements ICapabilitySerializable<CompoundTag> {
        private final ICastleOblivionExteriorCapability instance = new ExteriorImplementation();

        public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction side) {
            return ModCapabilities.CASTLE_OBLIVION_EXTERIOR_CAPABILITY.orEmpty(cap, LazyOptional.of(() -> this.instance));
        }

        public CompoundTag serializeNBT() {
            return (CompoundTag)this.instance.serializeNBT();
        }

        public void deserializeNBT(CompoundTag nbt) {
            this.instance.deserializeNBT((Tag)nbt);
        }
    }

    public static class ExteriorImplementation
    implements ICastleOblivionExteriorCapability {
        Map<UUID, ResourceLocation> interiors = new HashMap<UUID, ResourceLocation>();

        public CompoundTag serializeNBT() {
            CompoundTag tag = new CompoundTag();
            tag.m_128405_("interiors_size", this.interiors.size());
            List entries = this.interiors.entrySet().stream().toList();
            for (int i = 0; i < this.interiors.size(); ++i) {
                tag.m_128362_("interior_uuid_" + i, (UUID)((Map.Entry)entries.get(i)).getKey());
                tag.m_128359_("interior_dimensionrl_" + i, ((ResourceLocation)((Map.Entry)entries.get(i)).getValue()).toString());
            }
            return tag;
        }

        public void deserializeNBT(CompoundTag tag) {
            if (this.interiors == null) {
                this.interiors = new HashMap<UUID, ResourceLocation>();
            }
            int size = tag.m_128451_("interiors_size");
            this.interiors.clear();
            for (int i = 0; i < size; ++i) {
                this.interiors.put(tag.m_128342_("interior_uuid_" + i), new ResourceLocation(tag.m_128461_("interior_dimensionrl_" + i)));
            }
        }

        @Override
        public Map<UUID, ResourceLocation> getInteriors() {
            return this.interiors;
        }

        @Override
        public void addInterior(UUID uuid, ResourceLocation dimension) {
            this.interiors.put(uuid, dimension);
        }

        @Override
        public ResourceLocation getInterior(UUID id) {
            return this.interiors.get(id);
        }
    }

    public static interface ICastleOblivionExteriorCapability
    extends INBTSerializable<CompoundTag> {
        public Map<UUID, ResourceLocation> getInteriors();

        public void addInterior(UUID var1, ResourceLocation var2);

        public ResourceLocation getInterior(UUID var1);
    }

    public static class InteriorProvider
    implements ICapabilitySerializable<CompoundTag> {
        private final ICastleOblivionInteriorCapability instance = new InteriorImplementation();

        public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction side) {
            return ModCapabilities.CASTLE_OBLIVION_INTERIOR_CAPABILITY.orEmpty(cap, LazyOptional.of(() -> this.instance));
        }

        public CompoundTag serializeNBT() {
            return (CompoundTag)this.instance.serializeNBT();
        }

        public void deserializeNBT(CompoundTag nbt) {
            this.instance.deserializeNBT((Tag)nbt);
        }
    }

    public static class InteriorImplementation
    implements ICastleOblivionInteriorCapability {
        List<Floor> floors = new ArrayList<Floor>();

        public CompoundTag serializeNBT() {
            CompoundTag tag = new CompoundTag();
            tag.m_128405_("floors_size", this.floors.size());
            for (int i = 0; i < this.floors.size(); ++i) {
                tag.m_128365_("floors_" + i, (Tag)this.floors.get(i).serializeNBT());
            }
            return tag;
        }

        public void deserializeNBT(CompoundTag tag) {
            if (this.floors == null) {
                this.floors = new ArrayList<Floor>();
            }
            this.floors.clear();
            int size = tag.m_128451_("floors_size");
            for (int i = 0; i < size; ++i) {
                this.floors.add(new Floor((CompoundTag)tag.m_128423_("floors_" + i)));
            }
        }

        @Override
        public List<Floor> getFloors() {
            return this.floors;
        }

        @Override
        public void addFloor(Floor floor) {
            this.floors.add(floor);
        }

        @Override
        public Room getRoomAtPos(Level level, BlockPos pos) {
            Floor floor = this.getFloorAtPos(level, pos);
            for (RoomData room : floor.getRooms()) {
                Room r = room.getGenerated();
                if (r == null || !r.inRoom(pos)) continue;
                return r;
            }
            return null;
        }

        @Override
        public Floor getFloorAtPos(Level level, BlockPos pos) {
            Room closestEntrance = this.floors.get(0).getEntranceHall().getGenerated();
            if (closestEntrance != null) {
                double closestDistance = closestEntrance.getPosition().m_123331_((Vec3i)pos);
                for (Floor floor : this.getFloors()) {
                    if (!(floor.getEntranceHallPosition().m_123331_((Vec3i)pos) < closestDistance)) continue;
                    closestEntrance = floor.getEntranceHall().getGenerated();
                    closestDistance = floor.getEntranceHallPosition().m_123331_((Vec3i)pos);
                }
                return closestEntrance.getParent(level);
            }
            return null;
        }

        @Override
        public Floor getFloorByID(int id) {
            List<Floor> f = this.getFloors().stream().filter(floor -> floor.getFloorID() == id).toList();
            return !f.isEmpty() ? f.get(0) : null;
        }

        @Override
        public boolean isInRoom(BlockPos pos) {
            return false;
        }
    }

    public static interface ICastleOblivionInteriorCapability
    extends INBTSerializable<CompoundTag> {
        public List<Floor> getFloors();

        public void addFloor(Floor var1);

        public Room getRoomAtPos(Level var1, BlockPos var2);

        public Floor getFloorAtPos(Level var1, BlockPos var2);

        public Floor getFloorByID(int var1);

        public boolean isInRoom(BlockPos var1);
    }
}

