/*
 * Decompiled with CFR 0.152.
 */
package online.kingdomkeys.kingdomkeys.capability;

import java.util.HashMap;
import java.util.Map;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.CapabilityToken;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.capabilities.RegisterCapabilitiesEvent;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import online.kingdomkeys.kingdomkeys.KingdomKeys;
import online.kingdomkeys.kingdomkeys.capability.CastleOblivionCapabilities;
import online.kingdomkeys.kingdomkeys.capability.GlobalCapabilitiesProvider;
import online.kingdomkeys.kingdomkeys.capability.IGlobalCapabilities;
import online.kingdomkeys.kingdomkeys.capability.IPlayerCapabilities;
import online.kingdomkeys.kingdomkeys.capability.IWorldCapabilities;
import online.kingdomkeys.kingdomkeys.capability.PlayerCapabilitiesProvider;
import online.kingdomkeys.kingdomkeys.capability.WorldCapabilitiesProvider;

@Mod.EventBusSubscriber(modid="kingdomkeys", bus=Mod.EventBusSubscriber.Bus.MOD)
public class ModCapabilities {
    public static final Capability<IPlayerCapabilities> PLAYER_CAPABILITIES = CapabilityManager.get((CapabilityToken)new CapabilityToken<IPlayerCapabilities>(){});
    public static final Capability<IGlobalCapabilities> GLOBAL_CAPABILITIES = CapabilityManager.get((CapabilityToken)new CapabilityToken<IGlobalCapabilities>(){});
    public static final Capability<IWorldCapabilities> WORLD_CAPABILITIES = CapabilityManager.get((CapabilityToken)new CapabilityToken<IWorldCapabilities>(){});
    public static final Capability<CastleOblivionCapabilities.ICastleOblivionInteriorCapability> CASTLE_OBLIVION_INTERIOR_CAPABILITY = CapabilityManager.get((CapabilityToken)new CapabilityToken<CastleOblivionCapabilities.ICastleOblivionInteriorCapability>(){});
    public static final Capability<CastleOblivionCapabilities.ICastleOblivionExteriorCapability> CASTLE_OBLIVION_EXTERIOR_CAPABILITY = CapabilityManager.get((CapabilityToken)new CapabilityToken<CastleOblivionCapabilities.ICastleOblivionExteriorCapability>(){});
    public static Map<Integer, IGlobalCapabilities> mobDataClientCache = new HashMap<Integer, IGlobalCapabilities>();

    public static IPlayerCapabilities getPlayer(Player player) {
        LazyOptional playerData = player.getCapability(PLAYER_CAPABILITIES, null);
        return (IPlayerCapabilities)playerData.orElse(null);
    }

    public static IGlobalCapabilities getGlobal(LivingEntity e) {
        LazyOptional globalData = e.getCapability(GLOBAL_CAPABILITIES, null);
        return (IGlobalCapabilities)globalData.orElse(null);
    }

    public static IGlobalCapabilities getCachedGlobal(LivingEntity e) {
        return mobDataClientCache.get(e.m_19879_());
    }

    public static IWorldCapabilities getWorld(Level w) {
        LazyOptional worldData = w.getCapability(WORLD_CAPABILITIES, null);
        return (IWorldCapabilities)worldData.orElse(null);
    }

    public static CastleOblivionCapabilities.ICastleOblivionInteriorCapability getCastleOblivionInterior(Level level) {
        LazyOptional castleOblivionData = level.getCapability(CASTLE_OBLIVION_INTERIOR_CAPABILITY, null);
        if (!castleOblivionData.isPresent()) {
            KingdomKeys.LOGGER.warn("Castle Oblivion data not present in this dimension");
            return null;
        }
        return (CastleOblivionCapabilities.ICastleOblivionInteriorCapability)castleOblivionData.orElse(null);
    }

    public static CastleOblivionCapabilities.ICastleOblivionExteriorCapability getCastleOblivionExterior(Level level) {
        LazyOptional castleOblivionData = level.getCapability(CASTLE_OBLIVION_EXTERIOR_CAPABILITY, null);
        if (!castleOblivionData.isPresent()) {
            KingdomKeys.LOGGER.warn("Castle Oblivion data not present in this dimension");
            return null;
        }
        return (CastleOblivionCapabilities.ICastleOblivionExteriorCapability)castleOblivionData.orElse(null);
    }

    @SubscribeEvent
    public static void register(RegisterCapabilitiesEvent event) {
        event.register(IPlayerCapabilities.class);
        event.register(IGlobalCapabilities.class);
        event.register(IWorldCapabilities.class);
        event.register(CastleOblivionCapabilities.ICastleOblivionInteriorCapability.class);
        event.register(CastleOblivionCapabilities.ICastleOblivionExteriorCapability.class);
    }

    @SubscribeEvent
    public void attachCapabilities(AttachCapabilitiesEvent<Entity> event) {
        if (event.getObject() instanceof LivingEntity) {
            event.addCapability(new ResourceLocation("kingdomkeys", "global_capabilities"), (ICapabilityProvider)new GlobalCapabilitiesProvider());
            if (event.getObject() instanceof Player) {
                event.addCapability(new ResourceLocation("kingdomkeys", "player_capabilities"), (ICapabilityProvider)new PlayerCapabilitiesProvider());
            }
        }
    }

    @SubscribeEvent
    public void attachWorldCapabilities(AttachCapabilitiesEvent<Level> event) {
        event.addCapability(new ResourceLocation("kingdomkeys", "world_capabilities"), (ICapabilityProvider)new WorldCapabilitiesProvider());
        if (((Level)event.getObject()).m_46472_().m_135782_().toString().contains("kingdomkeys:castle_oblivion_interior_")) {
            event.addCapability(new ResourceLocation("kingdomkeys", "castle_oblivion_interior_capability"), (ICapabilityProvider)new CastleOblivionCapabilities.InteriorProvider());
        }
        if (((Level)event.getObject()).m_46472_().equals((Object)ResourceKey.m_135785_((ResourceKey)Registries.f_256858_, (ResourceLocation)new ResourceLocation("kingdomkeys", "castle_oblivion")))) {
            event.addCapability(new ResourceLocation("kingdomkeys", "castle_oblivion_exterior_capability"), (ICapabilityProvider)new CastleOblivionCapabilities.ExteriorProvider());
        }
    }
}

