/*
 * Decompiled with CFR 0.152.
 */
package online.kingdomkeys.kingdomkeys.capability;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.entity.LivingEntity;
import online.kingdomkeys.kingdomkeys.KingdomKeys;
import online.kingdomkeys.kingdomkeys.capability.IWorldCapabilities;
import online.kingdomkeys.kingdomkeys.lib.Party;
import online.kingdomkeys.kingdomkeys.lib.PortalData;
import online.kingdomkeys.kingdomkeys.lib.Struggle;
import online.kingdomkeys.kingdomkeys.util.Utils;

public class WorldCapabilities
implements IWorldCapabilities {
    private List<Party> parties = new ArrayList<Party>();
    private List<Struggle> struggles = new ArrayList<Struggle>();
    int heartlessSpawnLevel = 0;
    Map<UUID, PortalData> portals = new HashMap<UUID, PortalData>();

    public CompoundTag serializeNBT() {
        CompoundTag storage = new CompoundTag();
        storage.m_128405_("heartless", this.getHeartlessSpawnLevel());
        ListTag parties = new ListTag();
        ArrayList<String> partyNames = new ArrayList<String>();
        int dupeCount = 0;
        for (Party party : this.getParties()) {
            if (partyNames.contains(party.getName())) {
                ++dupeCount;
                continue;
            }
            partyNames.add(party.getName());
            parties.add((Object)party.write());
        }
        if (dupeCount > 0) {
            KingdomKeys.LOGGER.warn("Discarded {} duplicate parties while writing", (Object)dupeCount);
        }
        storage.m_128365_("parties", (Tag)parties);
        ListTag portals = new ListTag();
        for (Map.Entry<UUID, PortalData> entry : this.getPortals().entrySet()) {
            portals.add((Object)entry.getValue().write());
        }
        storage.m_128365_("portals", (Tag)portals);
        ListTag listTag = new ListTag();
        ArrayList<String> arrayList = new ArrayList<String>();
        int struggleDupeCount = 0;
        for (Struggle struggle : this.getStruggles()) {
            if (arrayList.contains(struggle.getName())) {
                ++struggleDupeCount;
                continue;
            }
            arrayList.add(struggle.getName());
            listTag.add((Object)struggle.write());
        }
        if (struggleDupeCount > 0) {
            KingdomKeys.LOGGER.warn("Discarded {} duplicate struggles while writing", (Object)struggleDupeCount);
        }
        storage.m_128365_("struggles", (Tag)listTag);
        return storage;
    }

    public void deserializeNBT(CompoundTag nbt) {
        this.setHeartlessSpawnLevel(nbt.m_128451_("heartless"));
        List<Party> partiesList = this.getParties();
        ArrayList<String> partyNames = new ArrayList<String>();
        int dupeCount = 0;
        ListTag parties = nbt.m_128437_("parties", 10);
        for (int i = 0; i < parties.size(); ++i) {
            CompoundTag partyNBT = parties.m_128728_(i);
            Party party = new Party();
            party.read(partyNBT);
            if (partyNames.contains(party.getName())) {
                ++dupeCount;
                continue;
            }
            partyNames.add(party.getName());
            partiesList.add(party);
        }
        if (dupeCount > 0) {
            KingdomKeys.LOGGER.warn("Discarded {} duplicate parties while reading", (Object)dupeCount);
        }
        this.setParties(partiesList);
        Map<UUID, PortalData> portalList = this.getPortals();
        ListTag portals = nbt.m_128437_("portals", 10);
        for (int i = 0; i < portals.size(); ++i) {
            CompoundTag portalNBT = portals.m_128728_(i);
            PortalData portal = new PortalData(null, null, 0.0, 0.0, 0.0, null, null);
            portal.read(portalNBT);
            portalList.put(portal.getUUID(), portal);
        }
        this.setPortals(portalList);
        List<Struggle> strugglesList = this.getStruggles();
        ArrayList<String> struggleNames = new ArrayList<String>();
        int struggleDupeCount = 0;
        ListTag struggles = nbt.m_128437_("struggles", 10);
        for (int i = 0; i < struggles.size(); ++i) {
            CompoundTag struggleNBT = struggles.m_128728_(i);
            Struggle struggle = new Struggle();
            struggle.read(struggleNBT);
            if (struggleNames.contains(struggle.getName())) {
                ++struggleDupeCount;
                continue;
            }
            struggleNames.add(struggle.getName());
            strugglesList.add(struggle);
        }
        if (struggleDupeCount > 0) {
            KingdomKeys.LOGGER.warn("Discarded {} duplicate struggles while reading", (Object)struggleDupeCount);
        }
        this.setParties(partiesList);
    }

    @Override
    public Map<UUID, PortalData> getPortals() {
        return this.portals;
    }

    @Override
    public void setPortals(Map<UUID, PortalData> portals) {
        this.portals = portals;
    }

    @Override
    public void addPortal(UUID uuid, PortalData data) {
        this.portals.put(uuid, data);
    }

    @Override
    public boolean removePortal(UUID id) {
        if (this.portals.containsKey(id)) {
            this.portals.remove(id);
            return true;
        }
        return false;
    }

    @Override
    public PortalData getPortalFromUUID(UUID uuid) {
        return this.portals.getOrDefault(uuid, null);
    }

    @Override
    public UUID getOwnerIDFromUUID(UUID portalUUID) {
        for (Map.Entry<UUID, PortalData> p : this.portals.entrySet()) {
            if (!p.getValue().getUUID().equals(portalUUID)) continue;
            return p.getValue().getOwnerID();
        }
        return null;
    }

    @Override
    public List<UUID> getAllPortalsFromOwnerID(UUID ownerID) {
        ArrayList<UUID> portals = new ArrayList<UUID>();
        for (Map.Entry<UUID, PortalData> p : this.getPortals().entrySet()) {
            if (!p.getValue().getOwnerID().equals(ownerID)) continue;
            portals.add(p.getValue().getUUID());
        }
        return portals;
    }

    @Override
    public int getHeartlessSpawnLevel() {
        return this.heartlessSpawnLevel;
    }

    @Override
    public void setHeartlessSpawnLevel(int level) {
        this.heartlessSpawnLevel = level;
    }

    @Override
    public void setParties(List<Party> list) {
        this.parties = list;
    }

    @Override
    public List<Party> getParties() {
        return this.parties;
    }

    @Override
    @Nullable
    public Party getPartyFromMember(UUID memId) {
        for (Party party : this.parties) {
            for (Party.Member member : party.getMembers()) {
                if (!member.getUUID().equals(memId)) continue;
                return party;
            }
        }
        return null;
    }

    @Override
    @Nullable
    public Party getPartyFromName(String name) {
        for (Party party : this.parties) {
            if (!party.getName().equalsIgnoreCase(name)) continue;
            return party;
        }
        return null;
    }

    @Override
    public void removeParty(Party party) {
        String key = Utils.getResourceName(party.getName());
        int pos = -1;
        for (int i = 0; i < this.parties.size(); ++i) {
            if (!Utils.getResourceName(this.parties.get(i).getName()).equalsIgnoreCase(key)) continue;
            pos = i;
            break;
        }
        if (pos > -1) {
            this.parties.remove(pos);
        }
    }

    @Override
    public void addParty(Party party) {
        String key = Utils.getResourceName(party.getName());
        boolean found = false;
        for (Party p : this.parties) {
            if (!Utils.getResourceName(p.getName()).equalsIgnoreCase(key)) continue;
            found = true;
        }
        if (!found) {
            this.parties.add(party);
        }
    }

    @Override
    public void removeLeaderMember(Party party, LivingEntity entity) {
        party.removeMember(entity.m_20148_());
    }

    @Override
    public void addPartyMember(Party party, LivingEntity entity) {
        party.addMember(entity);
    }

    @Override
    public void setStruggles(List<Struggle> list) {
        this.struggles = list;
    }

    @Override
    public List<Struggle> getStruggles() {
        return this.struggles;
    }

    @Override
    public Struggle getStruggleFromParticipant(UUID memId) {
        for (Struggle struggle : this.struggles) {
            for (Struggle.Participant participant : struggle.getParticipants()) {
                if (!participant.getUUID().equals(memId)) continue;
                return struggle;
            }
        }
        return null;
    }

    @Override
    public void addStruggleParticipant(Struggle struggle, LivingEntity entity) {
        struggle.addParticipant(entity);
    }

    @Override
    public void addStruggle(Struggle struggle) {
        String key = Utils.getResourceName(struggle.getName());
        boolean found = false;
        for (Struggle p : this.struggles) {
            if (!Utils.getResourceName(p.getName()).equalsIgnoreCase(key)) continue;
            found = true;
        }
        if (!found) {
            this.struggles.add(struggle);
        }
    }

    @Override
    public void removeStruggle(Struggle struggle) {
        String key = Utils.getResourceName(struggle.getName());
        int pos = -1;
        for (int i = 0; i < this.struggles.size(); ++i) {
            if (!Utils.getResourceName(this.struggles.get(i).getName()).equalsIgnoreCase(key)) continue;
            pos = i;
            break;
        }
        if (pos > -1) {
            this.struggles.remove(pos);
        }
    }

    @Override
    public Struggle getStruggleFromName(String name) {
        for (Struggle struggle : this.struggles) {
            if (!struggle.getName().equalsIgnoreCase(name)) continue;
            return struggle;
        }
        return null;
    }

    @Override
    public Struggle getStruggleFromBlockPos(BlockPos boardPos) {
        for (Struggle struggle : this.struggles) {
            if (!struggle.getPos().equals((Object)boardPos)) continue;
            return struggle;
        }
        return null;
    }

    @Override
    public void read(CompoundTag nbt) {
        this.parties.clear();
        ListTag parties = nbt.m_128437_("parties", 10);
        for (int i = 0; i < parties.size(); ++i) {
            CompoundTag partyNBT = parties.m_128728_(i);
            Party party = new Party();
            party.read(partyNBT);
            this.addParty(party);
        }
        this.heartlessSpawnLevel = nbt.m_128451_("heartless");
        this.portals.clear();
        ListTag portals = nbt.m_128437_("portals", 10);
        for (int i = 0; i < portals.size(); ++i) {
            CompoundTag portalNBT = portals.m_128728_(i);
            PortalData portal = new PortalData(null, null, 0.0, 0.0, 0.0, null, null);
            portal.read(portalNBT);
            this.portals.put(portal.getUUID(), portal);
        }
        this.struggles.clear();
        ListTag struggles = nbt.m_128437_("struggles", 10);
        for (int i = 0; i < struggles.size(); ++i) {
            CompoundTag struggleNBT = struggles.m_128728_(i);
            Struggle struggle = new Struggle();
            struggle.read(struggleNBT);
            this.addStruggle(struggle);
        }
    }

    @Override
    public CompoundTag write(CompoundTag nbt) {
        ListTag parties = new ListTag();
        HashSet<String> names = new HashSet<String>();
        for (Party party : this.parties) {
            if (names.contains(party.getName())) continue;
            parties.add((Object)party.write());
            names.add(party.getName());
        }
        nbt.m_128365_("parties", (Tag)parties);
        nbt.m_128405_("heartless", this.heartlessSpawnLevel);
        ListTag portals = new ListTag();
        for (Map.Entry<UUID, PortalData> entry : this.getPortals().entrySet()) {
            portals.add((Object)entry.getValue().write());
        }
        nbt.m_128365_("portals", (Tag)portals);
        ListTag listTag = new ListTag();
        HashSet<String> hashSet = new HashSet<String>();
        for (Struggle struggle : this.struggles) {
            if (hashSet.contains(struggle.getName())) continue;
            listTag.add((Object)struggle.write());
            hashSet.add(struggle.getName());
        }
        nbt.m_128365_("struggles", (Tag)listTag);
        return nbt;
    }
}

