/*
 * Decompiled with CFR 0.152.
 */
package online.kingdomkeys.kingdomkeys.client.gui.elements.buttons;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.awt.Color;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.client.sounds.SoundManager;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.registries.ForgeRegistries;
import online.kingdomkeys.kingdomkeys.api.item.ItemCategory;
import online.kingdomkeys.kingdomkeys.capability.IPlayerCapabilities;
import online.kingdomkeys.kingdomkeys.capability.ModCapabilities;
import online.kingdomkeys.kingdomkeys.client.ClientUtils;
import online.kingdomkeys.kingdomkeys.client.gui.elements.MenuFilterable;
import online.kingdomkeys.kingdomkeys.client.gui.synthesis.ShopScreen;
import online.kingdomkeys.kingdomkeys.client.gui.synthesis.SynthesisCreateScreen;
import online.kingdomkeys.kingdomkeys.client.gui.synthesis.SynthesisForgeScreen;
import online.kingdomkeys.kingdomkeys.client.sound.ModSounds;
import online.kingdomkeys.kingdomkeys.config.ModConfigs;
import online.kingdomkeys.kingdomkeys.item.KeybladeItem;
import online.kingdomkeys.kingdomkeys.item.KeychainItem;
import online.kingdomkeys.kingdomkeys.synthesis.recipe.Recipe;
import online.kingdomkeys.kingdomkeys.synthesis.recipe.RecipeRegistry;
import online.kingdomkeys.kingdomkeys.synthesis.shop.ShopItem;
import online.kingdomkeys.kingdomkeys.synthesis.shop.ShopList;
import online.kingdomkeys.kingdomkeys.util.Utils;

public class MenuStockItem
extends Button {
    MenuFilterable parent;
    ResourceLocation rl;
    ItemStack stack;
    boolean showAmount;
    String customName = null;
    public int offsetY;
    public Color backgroundColor;
    final ResourceLocation texture = new ResourceLocation("kingdomkeys", "textures/gui/menu/menu_button.png");

    public MenuStockItem(MenuFilterable parent, ResourceLocation rl, ItemStack displayStack, int x, int y, int width, boolean showAmount) {
        super(new Button.Builder((Component)Component.m_237113_((String)""), b -> parent.action(rl, displayStack)).m_252987_(x, y, width, 14));
        this.parent = parent;
        this.rl = rl;
        this.showAmount = showAmount;
        this.stack = displayStack;
    }

    public MenuStockItem(MenuFilterable parent, ItemStack stack, int x, int y, int width, boolean showAmount) {
        super(new Button.Builder((Component)Component.m_237113_((String)""), b -> parent.action(ForgeRegistries.ITEMS.getKey((Object)stack.m_41720_()), stack)).m_252987_(x, y, width, 14));
        this.parent = parent;
        this.rl = ForgeRegistries.ITEMS.getKey((Object)stack.m_41720_());
        this.stack = stack;
        this.showAmount = showAmount;
    }

    public MenuStockItem(MenuFilterable parent, ResourceLocation rl, ItemStack displayStack, int x, int y, int width, boolean showAmount, String customName) {
        this(parent, rl, displayStack, x, y, width, showAmount);
        this.customName = customName;
    }

    public MenuStockItem(MenuFilterable parent, ItemStack stack, int x, int y, int width, boolean showAmount, String customName) {
        this(parent, stack, x, y, width, showAmount);
        this.customName = customName;
    }

    public void setBackgroundColor(Color color) {
        this.backgroundColor = color;
    }

    public Color getBackgroundColor() {
        return this.backgroundColor;
    }

    public int m_252907_() {
        return super.m_252907_() - this.offsetY;
    }

    public void m_88315_(GuiGraphics gui, int mouseX, int mouseY, float partialTicks) {
        PoseStack matrixStack = gui.m_280168_();
        this.f_93622_ = mouseX > this.m_252754_() && mouseY >= this.m_252907_() && mouseX < this.m_252754_() + this.f_93618_ && mouseY < this.m_252907_() + this.f_93619_;
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        if (this.f_93624_) {
            Set<String> recipeList;
            Object item;
            Minecraft mc = Minecraft.m_91087_();
            if (this.parent.selectedItemStack == null) {
                this.parent.selectedItemStack = new ItemStack((ItemLike)ForgeRegistries.ITEMS.getValue(this.parent.selectedRL));
            }
            if (this.f_93622_ || this.parent.selectedItemStack == this.stack) {
                matrixStack.m_85836_();
                RenderSystem.enableBlend();
                matrixStack.m_252880_((float)this.m_252754_() + 0.6f, (float)this.m_252907_(), 0.0f);
                scale = 0.5f;
                matrixStack.m_85841_(scale, scale, 1.0f);
                gui.m_280218_(this.texture, 0, 0, 27, 0, 18, 28);
                gui.m_280411_(this.texture, 16, 0, (int)((float)this.f_93618_ * (1.0f / scale) - 17.0f * (1.0f / scale)) + 1, 28, 47.0f, 0.0f, 2, 28, 256, 256);
                gui.m_280218_(this.texture, (int)((float)this.f_93618_ * (1.0f / scale)) - 18, 0, 47, 0, 17, 28);
                matrixStack.m_85849_();
            } else if (this.getBackgroundColor() != null) {
                matrixStack.m_85836_();
                RenderSystem.enableBlend();
                matrixStack.m_252880_((float)this.m_252754_() + 0.6f, (float)this.m_252907_(), 0.0f);
                scale = 0.5f;
                matrixStack.m_85841_(scale, scale, 1.0f);
                RenderSystem.setShaderColor((float)((float)this.getBackgroundColor().getRed() / 255.0f), (float)((float)this.getBackgroundColor().getGreen() / 255.0f), (float)((float)this.getBackgroundColor().getBlue() / 255.0f), (float)1.0f);
                gui.m_280218_(this.texture, 0, 0, 219, 0, 18, 28);
                gui.m_280411_(this.texture, 16, 0, (int)((float)this.f_93618_ * (1.0f / scale) - 17.0f * (1.0f / scale)) + 1, 28, 239.0f, 0.0f, 2, 28, 256, 256);
                gui.m_280218_(this.texture, (int)((float)this.f_93618_ * (1.0f / scale)) - 18, 0, 239, 0, 17, 28);
                RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                matrixStack.m_85849_();
            }
            ItemCategory category = Utils.getCategoryForStack(this.stack);
            matrixStack.m_85836_();
            matrixStack.m_252880_((float)(this.m_252754_() + 3), (float)(this.m_252907_() + 2), 0.0f);
            float scale = 0.5f;
            int categorySize = 20;
            matrixStack.m_85841_(scale, scale, 1.0f);
            gui.m_280218_(this.texture, 0, 0, category.getU(), category.getV(), categorySize, categorySize);
            matrixStack.m_85849_();
            ChatFormatting color = ChatFormatting.WHITE;
            IPlayerCapabilities playerData = ModCapabilities.getPlayer((Player)mc.f_91074_);
            boolean displayTick = false;
            if (this.parent instanceof SynthesisCreateScreen) {
                Recipe recipe;
                displayTick = true;
                color = ChatFormatting.DARK_GRAY;
                if (RecipeRegistry.getInstance().containsKey(this.rl) && ((recipe = RecipeRegistry.getInstance().getValue(this.rl)).getTier() <= playerData.getSynthLevel() || !ModConfigs.requireSynthTier) && playerData.getMunny() >= recipe.getCost()) {
                    color = ChatFormatting.WHITE;
                    for (Map.Entry entry : recipe.getMaterials().entrySet()) {
                        if (playerData.getMaterialAmount((Item)entry.getKey()) >= (Integer)entry.getValue()) continue;
                        color = ChatFormatting.DARK_GRAY;
                    }
                }
            }
            if (this.parent instanceof SynthesisForgeScreen) {
                displayTick = true;
                color = ChatFormatting.DARK_GRAY;
                Item item2 = this.stack.m_41720_();
                if (item2 instanceof KeychainItem) {
                    KeychainItem kcItem = (KeychainItem)item2;
                    item = kcItem.getKeyblade();
                    if (((KeybladeItem)item).getKeybladeLevel(this.stack) >= ((KeybladeItem)item).getMaxLevel()) {
                        color = ChatFormatting.GOLD;
                    } else {
                        Iterator<Map.Entry<Item, Integer>> iterator = ((KeybladeItem)item).data.getLevelData(((KeybladeItem)item).getKeybladeLevel(this.stack)).getMaterialList().entrySet().iterator();
                        color = ChatFormatting.WHITE;
                        while (iterator.hasNext()) {
                            Map.Entry<Item, Integer> m = iterator.next();
                            if (playerData.getMaterialAmount(m.getKey()) >= m.getValue()) continue;
                            color = ChatFormatting.DARK_GRAY;
                        }
                    }
                }
            }
            if ((item = this.parent) instanceof ShopScreen) {
                ShopScreen shop = (ShopScreen)((Object)item);
                displayTick = true;
                ShopList shopList = shop.getShopList();
                for (ShopItem item3 : shopList.getList()) {
                    if (!this.rl.equals((Object)Utils.getItemRegistryName(item3.getResult()))) continue;
                    color = item3.getCost() > playerData.getMunny() ? ChatFormatting.DARK_GRAY : ChatFormatting.WHITE;
                    break;
                }
            }
            int rightMargin = 5;
            if (this.showAmount) {
                String count = Component.m_237110_((String)"x%s ", (Object[])new Object[]{this.stack.m_41613_()}).getString();
                gui.m_280488_(mc.f_91062_, count, this.m_252754_() + this.f_93618_ - mc.f_91062_.m_92895_(count), this.m_252907_() + 3, 16316177);
                rightMargin += mc.f_91062_.m_92895_(count);
            }
            ClientUtils.drawScrollingString(gui, mc.f_91062_, (Component)Component.m_237113_((String)(String.valueOf(color) + (this.customName == null ? this.stack.m_41786_().getString() : this.customName))), this.m_252754_() + 15, this.m_252754_() + this.f_93618_ - rightMargin, this.m_252907_() + 3, 0xFFFFFF, false);
            if (displayTick && (recipeList = playerData.getSynthesisedRecipes()).contains(this.rl.toString())) {
                gui.m_280488_(mc.f_91062_, "\u2714", (int)((double)this.m_5711_() * 1.49), this.m_252907_() + 3, 65280);
            }
        }
    }

    public void m_7435_(SoundManager soundHandler) {
        soundHandler.m_120367_((SoundInstance)SimpleSoundInstance.m_119755_((SoundEvent)((SoundEvent)ModSounds.menu_select.get()), (float)1.0f, (float)1.0f));
    }
}

