/*
 * Decompiled with CFR 0.152.
 */
package online.kingdomkeys.kingdomkeys.client.gui.elements.buttons;

import java.awt.Color;
import java.util.Objects;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.network.chat.Component;
import net.minecraft.world.level.block.entity.BlockEntity;
import online.kingdomkeys.kingdomkeys.client.gui.SavePointScreen;
import online.kingdomkeys.kingdomkeys.client.gui.elements.buttons.ScrollableButtonBase;
import online.kingdomkeys.kingdomkeys.entity.block.SavepointTileEntity;
import online.kingdomkeys.kingdomkeys.util.Utils;
import online.kingdomkeys.kingdomkeys.world.SavePointStorage;

public class SavePointButton
extends ScrollableButtonBase {
    SavePointScreen parent;
    UUID destination;

    public SavePointButton(SavePointScreen parent, int pX, int pY, int pWidth, int pHeight, Component pMessage, UUID destination) {
        super(new Button.Builder(pMessage, pButton -> parent.clickSavePoint(destination)).m_252987_(pX, pY, pWidth, pHeight));
        this.parent = parent;
        this.destination = destination;
    }

    public UUID getDestination() {
        return this.destination;
    }

    protected void m_87963_(GuiGraphics gui, int pMouseX, int pMouseY, float pPartialTick) {
        this.f_93622_ = this.m_5953_(pMouseX, pMouseY);
        Objects.requireNonNull(Minecraft.m_91087_().f_91062_);
        int labelHeight = 9 + 2;
        if (this.f_93624_) {
            SavePointScreen.Screenshot screenshot;
            if (!this.f_93623_ || this.f_93622_) {
                gui.m_280509_(this.m_252754_() - 1, this.m_252907_() - 1, this.m_252754_() + this.m_5711_() + 1, this.m_252907_() + this.m_93694_() + 1, Color.GREEN.getRGB());
            } else {
                gui.m_280509_(this.m_252754_(), this.m_252907_(), this.m_252754_() + this.m_5711_(), this.m_252907_() + this.m_93694_(), Color.GREEN.getRGB());
            }
            if (!this.parent.savePointScreenshots.isEmpty() && (screenshot = this.parent.savePointScreenshots.get(this.destination)) != null && screenshot.textureLocation() != null) {
                gui.m_280163_(screenshot.textureLocation(), this.m_252754_(), this.m_252907_(), 0.0f, 0.0f, this.m_5711_(), this.m_93694_(), this.m_5711_(), this.m_93694_());
            }
            if (this.f_93622_) {
                SavePointStorage.SavePoint sPoint = (SavePointStorage.SavePoint)this.parent.savePoints.get(this.destination).getFirst();
                if (sPoint == null) {
                    return;
                }
                BlockEntity blockEntity = Minecraft.m_91087_().f_91073_.m_7702_(sPoint.pos());
                if (blockEntity instanceof SavepointTileEntity) {
                    SavepointTileEntity savepoint = (SavepointTileEntity)blockEntity;
                    Tooltip tooltip = Tooltip.m_257550_((Component)Component.m_237113_((String)("UUID: " + String.valueOf(savepoint.getID()) + "\nDimension: " + String.valueOf(sPoint.dimension().m_135782_()) + "\nOwner: " + (String)sPoint.owner().getSecond() + "\nHealing: " + Utils.getSavepointPercent(savepoint.getHeal()) + "%\nFood: " + Utils.getSavepointPercent(savepoint.getHunger()) + "%\nMagic: " + Utils.getSavepointPercent(savepoint.getMagic()) + "%\nFocus: " + Utils.getSavepointPercent(savepoint.getFocus()) + "%\nDrive: " + Utils.getSavepointPercent(savepoint.getDrive()) + "%")));
                    this.m_257544_(tooltip);
                }
                this.drawLabel(this.m_6035_(), gui, labelHeight);
            }
            if (this.parent.hovered == null || !this.parent.hovered.equals(this.destination)) {
                this.drawDark(gui, Color.BLACK);
            }
        }
        if (!this.f_93623_) {
            this.drawLabel((Component)Component.m_237115_((String)"gui.save.main.here"), gui, labelHeight);
        }
    }

    public void drawDark(GuiGraphics gui, Color colour) {
        gui.m_280246_(1.0f, 1.0f, 1.0f, 0.4f);
        gui.m_280509_(this.m_252754_(), this.m_252907_(), this.m_252754_() + this.m_5711_(), this.m_252907_() + this.m_93694_(), colour.getRGB());
        gui.m_280246_(1.0f, 1.0f, 1.0f, 1.0f);
    }

    public void drawLabel(Component text, GuiGraphics gui, int labelHeight) {
        gui.m_280246_(1.0f, 1.0f, 1.0f, 0.5f);
        gui.m_280509_(this.m_252754_(), this.m_252907_() + (this.m_93694_() - labelHeight), this.m_252754_() + this.m_5711_(), this.m_252907_() + this.m_93694_(), Color.BLACK.getRGB());
        gui.m_280246_(1.0f, 1.0f, 1.0f, 1.0f);
        if (Minecraft.m_91087_().f_91062_.m_92724_(this.m_6035_().m_7532_()) > this.m_5711_()) {
            gui.m_280588_(this.m_252754_(), this.m_252907_() + (this.m_93694_() - labelHeight), this.m_252754_() + this.m_5711_(), this.m_252907_() + this.m_93694_());
            gui.m_280430_(Minecraft.m_91087_().f_91062_, text, this.m_252754_() + 1, this.m_252907_() + (this.m_93694_() - labelHeight) + 1, Color.WHITE.getRGB());
            gui.m_280618_();
        } else {
            gui.m_280653_(Minecraft.m_91087_().f_91062_, text, this.m_252754_() + this.m_5711_() / 2, this.m_252907_() + (this.m_93694_() - labelHeight) + 1, Color.WHITE.getRGB());
        }
    }

    public boolean isMouseOverInactive(double pMouseX, double pMouseY) {
        return !this.f_93623_ && this.f_93624_ && pMouseX >= (double)this.m_252754_() && pMouseY >= (double)this.m_252907_() && pMouseX < (double)(this.m_252754_() + this.f_93618_) && pMouseY < (double)(this.m_252907_() + this.f_93619_);
    }

    public boolean m_5953_(double pMouseX, double pMouseY) {
        boolean hovered = super.m_5953_(pMouseX, pMouseY);
        if (hovered) {
            this.parent.hovered = this.destination;
        } else if (this.parent.hovered != null && this.parent.hovered.equals(this.destination)) {
            this.parent.hovered = null;
        }
        return hovered;
    }
}

