/*
 * Decompiled with CFR 0.152.
 */
package online.kingdomkeys.kingdomkeys.client.gui.menu.struggle;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.awt.Color;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import online.kingdomkeys.kingdomkeys.capability.IPlayerCapabilities;
import online.kingdomkeys.kingdomkeys.capability.ModCapabilities;
import online.kingdomkeys.kingdomkeys.client.ClientUtils;
import online.kingdomkeys.kingdomkeys.client.gui.elements.MenuBackground;
import online.kingdomkeys.kingdomkeys.client.gui.elements.buttons.MenuButton;
import online.kingdomkeys.kingdomkeys.client.gui.menu.struggle.StruggleCreate;
import online.kingdomkeys.kingdomkeys.client.gui.menu.struggle.StruggleJoin;
import online.kingdomkeys.kingdomkeys.client.gui.menu.struggle.StruggleSettings;
import online.kingdomkeys.kingdomkeys.lib.Struggle;
import online.kingdomkeys.kingdomkeys.util.Utils;
import org.jetbrains.annotations.NotNull;

public class MenuStruggle
extends MenuBackground {
    BlockPos boardPos;
    MenuButton create;
    MenuButton join;
    MenuButton settings;
    final ResourceLocation texture = new ResourceLocation("kingdomkeys", "textures/gui/menu/menu_button.png");

    public MenuStruggle(BlockPos pos) {
        super("Menu", new Color(252, 173, 3));
        this.f_96541_ = Minecraft.m_91087_();
        this.boardPos = pos;
    }

    protected void action(buttons buttonID) {
        switch (buttonID) {
            case CREATE: {
                this.f_96541_.m_91152_((Screen)new StruggleCreate(this.boardPos));
                break;
            }
            case JOIN: {
                this.f_96541_.m_91152_((Screen)new StruggleJoin(this.boardPos));
                break;
            }
            case SETTINGS: {
                this.f_96541_.m_91152_((Screen)new StruggleSettings(this.boardPos));
            }
        }
        this.updateButtons();
    }

    @Override
    public void m_7856_() {
        this.f_96543_ = this.f_96543_;
        this.f_96544_ = this.f_96544_;
        super.m_7856_();
        float topBarHeight = (float)this.f_96544_ * 0.17f;
        int start = (int)topBarHeight + 5;
        int pos = 0;
        float buttonPosX = (float)this.f_96543_ * 0.03f;
        float buttonWidth = (float)this.f_96543_ * 0.1744f - 22.0f;
        this.create = new MenuButton((int)buttonPosX, start, (int)buttonWidth, "Create match", MenuButton.ButtonType.BUTTON, true, e -> this.action(buttons.CREATE));
        this.m_142416_((GuiEventListener)this.create);
        this.join = new MenuButton((int)buttonPosX, start + 18 * ++pos, (int)buttonWidth, "Join match", MenuButton.ButtonType.BUTTON, true, e -> this.action(buttons.JOIN));
        this.m_142416_((GuiEventListener)this.join);
        this.settings = new MenuButton((int)buttonPosX, start + 18 * ++pos, (int)buttonWidth, "Struggle Settings", MenuButton.ButtonType.BUTTON, true, e -> this.action(buttons.SETTINGS));
        this.m_142416_((GuiEventListener)this.settings);
        Struggle s = ModCapabilities.getWorld((Level)this.f_96541_.f_91073_).getStruggleFromParticipant(this.f_96541_.f_91074_.m_20148_());
        if (s != null) {
            System.out.println(s.getOwner().getUsername());
        }
        this.updateButtons();
    }

    private void updateButtons() {
        this.create.f_93624_ = true;
        this.join.f_93624_ = true;
        Struggle s = ModCapabilities.getWorld((Level)this.f_96541_.f_91073_).getStruggleFromParticipant(this.f_96541_.f_91074_.m_20148_());
        if (s != null) {
            this.settings.f_93624_ = s.getOwner().getUUID().equals(this.f_96541_.f_91074_.m_20148_());
        }
    }

    @Override
    public void m_88315_(@NotNull GuiGraphics gui, int mouseX, int mouseY, float partialTicks) {
        super.m_88315_(gui, mouseX, mouseY, partialTicks);
        this.drawPlayer(gui);
    }

    public void drawPlayer(GuiGraphics gui) {
        PoseStack matrixStack = gui.m_280168_();
        float playerHeight = (float)this.f_96544_ * 0.45f;
        float playerPosX = (float)this.f_96543_ * 0.5229f;
        float playerPosY = (float)this.f_96544_ * 0.7f;
        IPlayerCapabilities playerData = ModCapabilities.getPlayer((Player)this.f_96541_.f_91074_);
        if (playerData != null) {
            int i;
            matrixStack.m_85836_();
            LocalPlayer player = this.f_96541_.f_91074_;
            ClientUtils.renderPlayerNoAnims(matrixStack, (int)playerPosX, (int)playerPosY, (int)playerHeight / 2, 0.0f, 0.0f, (LivingEntity)player);
            matrixStack.m_85849_();
            matrixStack.m_85836_();
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            matrixStack.m_252880_(1.0f, 1.0f, 100.0f);
            RenderSystem.enableBlend();
            int infoBoxWidth = (int)((float)this.f_96543_ * 0.1385f - 14.0f);
            int infoBoxPosX = (int)((float)this.f_96543_ * 0.4354f);
            int infoBoxPosY = (int)((float)this.f_96544_ * 0.54f);
            gui.m_280218_(this.texture, infoBoxPosX, infoBoxPosY, 123, 67, 11, 22);
            for (i = 0; i < infoBoxWidth; ++i) {
                gui.m_280218_(this.texture, infoBoxPosX + 11 + i, infoBoxPosY, 135, 67, 1, 22);
            }
            gui.m_280218_(this.texture, infoBoxPosX + 11 + infoBoxWidth, infoBoxPosY, 137, 67, 3, 22);
            gui.m_280218_(this.texture, infoBoxPosX, infoBoxPosY + 22, 123, 90, 3, 35);
            for (i = 0; i < infoBoxWidth + 8; ++i) {
                gui.m_280218_(this.texture, infoBoxPosX + 3 + i, infoBoxPosY + 22, 127, 90, 1, 35);
            }
            gui.m_280218_(this.texture, infoBoxPosX + 3 + infoBoxWidth + 8, infoBoxPosY + 22, 129, 90, 3, 35);
            RenderSystem.disableBlend();
            matrixStack.m_85849_();
            matrixStack.m_85836_();
            matrixStack.m_252880_(2.0f, 2.0f, 100.0f);
            matrixStack.m_85836_();
            float f = infoBoxPosX + 8;
            Objects.requireNonNull(this.f_96541_.f_91062_);
            matrixStack.m_252880_(f, (float)(infoBoxPosY + (11 - 9 / 2)), 1.0f);
            gui.m_280488_(this.f_96541_.f_91062_, this.f_96541_.f_91074_.m_5446_().getString(), 0, 0, 0xFFFFFF);
            matrixStack.m_85849_();
            gui.m_280488_(this.f_96541_.f_91062_, Utils.translateToLocal("gui.menu.status.level", new Object[0]) + ": " + playerData.getLevel(), infoBoxPosX + 4, infoBoxPosY + 26, 16767232);
            Font font = this.f_96541_.f_91062_;
            String string = Utils.translateToLocal("gui.menu.status.hp", new Object[0]) + ": " + (int)this.f_96541_.f_91074_.m_21223_() + "/" + (int)this.f_96541_.f_91074_.m_21233_();
            Objects.requireNonNull(this.f_96541_.f_91062_);
            gui.m_280488_(font, string, infoBoxPosX + 4, infoBoxPosY + 26 + 9, 65280);
            Font font2 = this.f_96541_.f_91062_;
            String string2 = Utils.translateToLocal("gui.menu.status.mp", new Object[0]) + ": " + (int)playerData.getMP() + "/" + (int)playerData.getMaxMP();
            Objects.requireNonNull(this.f_96541_.f_91062_);
            gui.m_280488_(font2, string2, infoBoxPosX + 4, infoBoxPosY + 26 + 9 * 2, 0x4444FF);
            matrixStack.m_85849_();
        }
    }

    public static enum buttons {
        CREATE,
        JOIN,
        SETTINGS;

    }
}

