/*
 * Decompiled with CFR 0.152.
 */
package online.kingdomkeys.kingdomkeys.client.gui.synthesis;

import com.mojang.blaze3d.vertex.PoseStack;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.Renderable;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.registries.ForgeRegistries;
import online.kingdomkeys.kingdomkeys.KingdomKeys;
import online.kingdomkeys.kingdomkeys.ability.Ability;
import online.kingdomkeys.kingdomkeys.ability.ModAbilities;
import online.kingdomkeys.kingdomkeys.capability.IPlayerCapabilities;
import online.kingdomkeys.kingdomkeys.capability.ModCapabilities;
import online.kingdomkeys.kingdomkeys.client.ClientUtils;
import online.kingdomkeys.kingdomkeys.client.gui.elements.MenuBox;
import online.kingdomkeys.kingdomkeys.client.gui.elements.MenuFilterBar;
import online.kingdomkeys.kingdomkeys.client.gui.elements.MenuFilterable;
import online.kingdomkeys.kingdomkeys.client.gui.elements.buttons.MenuButton;
import online.kingdomkeys.kingdomkeys.client.gui.elements.buttons.MenuScrollBar;
import online.kingdomkeys.kingdomkeys.client.gui.elements.buttons.MenuStockItem;
import online.kingdomkeys.kingdomkeys.client.gui.synthesis.SynthesisScreen;
import online.kingdomkeys.kingdomkeys.client.sound.ModSounds;
import online.kingdomkeys.kingdomkeys.config.ModConfigs;
import online.kingdomkeys.kingdomkeys.item.KKAccessoryItem;
import online.kingdomkeys.kingdomkeys.item.KKArmorItem;
import online.kingdomkeys.kingdomkeys.item.KeybladeItem;
import online.kingdomkeys.kingdomkeys.item.KeychainItem;
import online.kingdomkeys.kingdomkeys.network.PacketHandler;
import online.kingdomkeys.kingdomkeys.network.cts.CSCloseMoogleGUI;
import online.kingdomkeys.kingdomkeys.network.cts.CSShopBuy;
import online.kingdomkeys.kingdomkeys.synthesis.shop.ShopItem;
import online.kingdomkeys.kingdomkeys.synthesis.shop.ShopList;
import online.kingdomkeys.kingdomkeys.synthesis.shop.ShopListRegistry;
import online.kingdomkeys.kingdomkeys.util.Utils;
import org.jetbrains.annotations.NotNull;

public class ShopScreen
extends MenuFilterable {
    MenuBox boxL;
    MenuBox boxM;
    MenuButton create;
    int itemsPerPage;
    private MenuButton back;
    SynthesisScreen parent;

    public ShopScreen(SynthesisScreen parent) {
        super("gui.shop.main.title", new Color(255, 0, 0));
        this.drawSeparately = true;
        this.parent = parent;
    }

    public ShopScreen(String nbt, SynthesisScreen parent) {
        this(parent);
    }

    public ShopList getShopList() {
        return ShopListRegistry.getInstance().getRegistry().get(new ResourceLocation(this.parent.invFile));
    }

    protected void action(String string) {
        switch (string) {
            case "create": {
                PacketHandler.sendToServer(new CSShopBuy(new ResourceLocation(this.parent.invFile), this.selectedItemStack));
                this.f_96541_.f_91073_.m_5594_((Player)this.f_96541_.f_91074_, this.f_96541_.f_91074_.m_20183_(), (SoundEvent)ModSounds.itemget.get(), SoundSource.MASTER, 1.0f, 1.0f);
            }
        }
    }

    @Override
    public void m_7856_() {
        float boxPosX = (float)this.f_96543_ * 0.2f;
        float topBarHeight = (float)this.f_96544_ * 0.17f;
        float boxWidth = (float)this.f_96543_ * 0.3f;
        float middleHeight = (float)this.f_96544_ * 0.6f;
        this.boxL = new MenuBox((int)boxPosX, (int)topBarHeight, (int)boxWidth, (int)middleHeight, 1.0f, new Color(100, 4, 4));
        this.boxM = new MenuBox((int)boxPosX + (int)boxWidth, (int)topBarHeight, (int)(boxWidth * 0.7f), (int)middleHeight, 1.0f, new Color(100, 4, 4));
        int scrollTop = (int)topBarHeight;
        int scrollBot = (int)((float)scrollTop + middleHeight);
        float filterPosX = (float)this.f_96543_ * 0.3f;
        float filterPosY = (float)this.f_96544_ * 0.02f;
        this.filterBar = new MenuFilterBar((int)filterPosX, (int)filterPosY, this);
        this.filterBar.init();
        this.scrollBar = new MenuScrollBar((int)(boxPosX + boxWidth - 17.0f), scrollTop, scrollBot, (int)middleHeight, 0);
        this.m_142416_((GuiEventListener)this.scrollBar);
        this.initItems();
        this.buttonPosX -= 10.0f;
        this.buttonWidth = (float)this.f_96543_ * 0.07f;
        super.m_7856_();
        this.itemsPerPage = (int)(middleHeight / 14.0f);
    }

    @Override
    public void initItems() {
        int i;
        float invPosX = (float)this.boxL.m_252754_() + 4.0f;
        float invPosY = (float)this.f_96544_ * 0.1851f;
        this.inventory.clear();
        this.m_6702_().clear();
        this.f_169369_.clear();
        this.filterBar.buttons.forEach(x$0 -> {
            Button cfr_ignored_0 = (Button)this.m_7787_((GuiEventListener)x$0);
        });
        ShopList shopList = this.getShopList();
        ArrayList<ResourceLocation> items = new ArrayList<ResourceLocation>();
        for (i = 0; i < shopList.getList().size(); ++i) {
            Object itemName = null;
            ShopItem shopItem = shopList.getList().get(i);
            if (shopItem != null) {
                ResourceLocation recipeRL = Utils.getItemRegistryName(shopItem.getResult());
                ItemStack stack = new ItemStack((ItemLike)shopItem.getResult());
                if (shopItem.getResult() instanceof KeychainItem) {
                    stack = new ItemStack((ItemLike)((KeychainItem)shopItem.getResult()).getKeyblade());
                }
                if (!this.filterItem(stack)) continue;
                items.add(recipeRL);
                continue;
            }
            KingdomKeys.LOGGER.error(String.valueOf(itemName) + " is not a valid recipe, check it");
        }
        items.sort(Comparator.comparing(Utils::getCategoryForShop).thenComparing(stackRL -> new ItemStack((ItemLike)ForgeRegistries.ITEMS.getValue(stackRL)).m_41786_().m_214077_().toString()));
        for (i = 0; i < items.size(); ++i) {
            ItemStack itemStack = new ItemStack((ItemLike)ForgeRegistries.ITEMS.getValue((ResourceLocation)items.get(i)));
            if (itemStack != null && itemStack.m_41720_() instanceof KeychainItem) {
                itemStack = new ItemStack((ItemLike)((KeychainItem)itemStack.m_41720_()).getKeyblade());
            }
            MenuStockItem item = new MenuStockItem((MenuFilterable)this, (ResourceLocation)items.get(i), itemStack, (int)invPosX, (int)invPosY + i * 14, this.boxL.m_5711_() - this.scrollBar.m_5711_() - 6, false);
            item.setBackgroundColor(new Color(80, 10, 10));
            this.inventory.add(item);
        }
        this.inventory.forEach(x$0 -> {
            MenuStockItem cfr_ignored_0 = (MenuStockItem)this.m_7787_((GuiEventListener)x$0);
        });
        super.m_7856_();
        this.create = new MenuButton(this.boxM.m_252754_() + this.boxM.m_5711_() / 2 - (int)(this.buttonWidth + 22.0f) / 2, (int)((double)this.f_96544_ * 0.67), (int)this.buttonWidth, "gui.shop.buy", MenuButton.ButtonType.ROUNDBUTTON, e -> this.action("create"));
        this.create.setCenterText(true);
        this.m_142416_((GuiEventListener)this.create);
        this.back = new MenuButton((int)this.buttonPosX, this.buttonPosY, (int)this.buttonWidth / 2, Component.m_237115_((String)"gui.menu.back").getString(), MenuButton.ButtonType.BUTTON, b -> this.f_96541_.m_91152_((Screen)new SynthesisScreen(this.parent.invFile, this.parent.name, this.parent.moogle)));
        this.m_142416_((GuiEventListener)this.back);
    }

    @Override
    public void m_88315_(@NotNull GuiGraphics gui, int mouseX, int mouseY, float partialTicks) {
        this.drawMenuBackground(gui, mouseX, mouseY, partialTicks);
        this.boxL.m_87963_(gui, mouseX, mouseY, partialTicks);
        this.boxM.m_87963_(gui, mouseX, mouseY, partialTicks);
        super.m_88315_(gui, mouseX, mouseY, partialTicks);
        if (this.inventory.isEmpty()) {
            return;
        }
        int listHeight = ((MenuStockItem)((Object)this.inventory.get(this.inventory.size() - 1))).m_252907_() + 20 - ((MenuStockItem)((Object)this.inventory.get(0))).m_252907_() + 3;
        this.scrollBar.setContentHeight(listHeight);
        if (this.selectedItemStack != ItemStack.f_41583_) {
            IPlayerCapabilities playerData = ModCapabilities.getPlayer((Player)this.f_96541_.f_91074_);
            boolean enoughMunny = false;
            boolean enoughTier = false;
            List<ShopItem> list = ShopListRegistry.getInstance().getRegistry().get(new ResourceLocation(this.parent.invFile)).getList();
            ShopItem item = null;
            for (ShopItem shopItem : list) {
                Object it = shopItem.getResult();
                if (it instanceof KeychainItem) {
                    it = ((KeychainItem)it).getKeyblade();
                }
                if (!ItemStack.m_41656_((ItemStack)new ItemStack((ItemLike)it, shopItem.getAmount()), (ItemStack)this.selectedItemStack)) continue;
                item = shopItem;
                break;
            }
            if (item != null) {
                enoughMunny = playerData.getMunny() >= item.getCost();
                enoughTier = !ModConfigs.requireSynthTier || playerData.getSynthLevel() >= item.getTier();
                this.create.f_93624_ = true;
                boolean bl = this.create.f_93623_ = enoughMunny && enoughTier;
                if (this.f_96541_.f_91074_.m_150109_().m_36062_() == -1) {
                    this.create.f_93623_ = false;
                    this.create.m_93666_((Component)Component.m_237115_((String)"gui.shop.no_empty_slot"));
                }
            }
            this.create.f_93624_ = item != null;
        } else {
            this.create.f_93624_ = false;
        }
        for (Renderable renderable : this.inventory) {
            if (renderable instanceof MenuStockItem) {
                MenuStockItem menuStockItem = (MenuStockItem)renderable;
                menuStockItem.f_93623_ = true;
                gui.m_280588_(this.boxL.m_252754_() + 2, this.scrollBar.m_252907_() + 2, this.boxL.m_252754_() + this.boxL.m_5711_(), this.scrollBar.getBottom() - 5);
                renderable.m_88315_(gui, mouseX, mouseY, partialTicks);
                gui.m_280618_();
                continue;
            }
            renderable.m_88315_(gui, mouseX, mouseY, partialTicks);
        }
        this.create.m_88315_(gui, mouseX, mouseY, partialTicks);
        this.back.m_88315_(gui, mouseX, mouseY, partialTicks);
    }

    @Override
    protected void renderSelectedData(GuiGraphics gui, int mouseX, int mouseY, float partialTicks) {
        Object line;
        PoseStack matrixStack = gui.m_280168_();
        float tooltipPosX = (float)this.f_96543_ * 0.3333f;
        float tooltipPosY = (float)this.f_96544_ * 0.8f;
        float iconPosY = this.boxM.getPosY() + 25;
        IPlayerCapabilities playerData = ModCapabilities.getPlayer((Player)this.f_96541_.f_91074_);
        matrixStack.m_85836_();
        double offset = (float)this.boxM.m_5711_() * 0.1f;
        matrixStack.m_85837_((double)this.boxM.m_252754_() + offset / 2.0, (double)iconPosY, 1.0);
        List<ShopItem> list = ShopListRegistry.getInstance().getRegistry().get(new ResourceLocation(this.parent.invFile)).getList();
        ShopItem item = null;
        for (ShopItem shopItem : list) {
            Object it = shopItem.getResult();
            if (it instanceof KeychainItem) {
                it = ((KeychainItem)it).getKeyblade();
            }
            if (!ItemStack.m_41656_((ItemStack)new ItemStack((ItemLike)it, shopItem.getAmount()), (ItemStack)this.selectedItemStack)) continue;
            item = shopItem;
            break;
        }
        if (item != null) {
            gui.m_280488_(this.f_96541_.f_91062_, Utils.translateToLocal("gui.shop.cost", new Object[0]) + " ", 2, -20, Color.yellow.getRGB());
            line = item.getCost() + " " + Utils.translateToLocal("gui.menu.main.munny", new Object[0]);
            gui.m_280488_(this.f_96541_.f_91062_, (String)line, this.boxM.m_5711_() - this.f_96541_.f_91062_.m_92895_((String)line) - 10, -20, item.getCost() > playerData.getMunny() ? Color.RED.getRGB() : Color.GREEN.getRGB());
            if (ModConfigs.requireSynthTier) {
                gui.m_280488_(this.f_96541_.f_91062_, Utils.translateToLocal("gui.shop.tier", new Object[0]) + " ", 2, -10, Color.yellow.getRGB());
                line = Utils.getTierFromInt(item.getTier()) + " - " + (10 + item.getTier() * 2) + " " + Utils.translateToLocal("gui.synthesis.exp", new Object[0]);
                gui.m_280488_(this.f_96541_.f_91062_, (String)line, this.boxM.m_5711_() - this.f_96541_.f_91062_.m_92895_((String)line) - 10, -10, item.getTier() > playerData.getSynthLevel() ? Color.RED.getRGB() : Color.GREEN.getRGB());
            }
            matrixStack.m_85836_();
            float size = 80.0f;
            matrixStack.m_252880_((float)this.boxM.m_5711_() * 0.7f / 2.0f, (float)this.boxM.m_93694_() * 0.6f - size / 2.0f, 0.0f);
            ClientUtils.drawItemAsIcon(this.selectedItemStack, matrixStack, 0, -30, (int)size);
            matrixStack.m_85849_();
        }
        matrixStack.m_85849_();
        if (this.selectedItemStack != null && this.selectedItemStack.m_41720_() instanceof KeybladeItem || this.selectedItemStack.m_41720_() instanceof KKAccessoryItem || this.selectedItemStack.m_41720_() instanceof KKArmorItem) {
            Ability a;
            String desc = "";
            String ability = "";
            line = this.selectedItemStack.m_41720_();
            if (line instanceof KeybladeItem) {
                KeybladeItem kb = (KeybladeItem)line;
                desc = kb.getDesc();
                ability = kb.data.getLevelAbility(0);
            } else {
                line = this.selectedItemStack.m_41720_();
                if (line instanceof KKAccessoryItem) {
                    KKAccessoryItem accessory = (KKAccessoryItem)line;
                    ability = !accessory.getAbilities().isEmpty() ? accessory.getAbilities().get(0) : null;
                }
            }
            matrixStack.m_85836_();
            matrixStack.m_85837_((double)(this.boxM.m_252754_() + 20), (double)this.f_96544_ * 0.58, 1.0);
            List<Component> stats = Utils.getResistancesStats(this.selectedItemStack);
            float scale = stats.size() > 4 ? 1.0f - (float)(stats.size() - 4) * 0.25f : 1.0f;
            matrixStack.m_85841_(scale, scale, scale);
            int offset2 = -15;
            for (int i = 0; i < stats.size(); ++i) {
                Component c = stats.get(i);
                gui.m_280430_(this.f_96541_.f_91062_, c, 0, offset2 + 10 * i, 0x4444FF);
            }
            if (ability != null && (a = (Ability)ModAbilities.registry.get().getValue(new ResourceLocation(ability))) != null) {
                String abilityName = Utils.translateToLocal(a.getTranslationKey(), new Object[0]);
                gui.m_280488_(this.f_96541_.f_91062_, abilityName, -20 + this.boxM.m_5711_() / 2 - this.f_96541_.f_91062_.m_92895_(abilityName) / 2, (stats.size() - 1) * 10, 0xFFAA44);
            }
            matrixStack.m_85849_();
            if (!desc.equals("")) {
                matrixStack.m_85836_();
                String text = Utils.translateToLocal(this.selectedItemStack.m_41778_(), new Object[0]);
                gui.m_280488_(this.f_96541_.f_91062_, text, (int)(tooltipPosX + 5.0f), (int)tooltipPosY + 5, 0xFF9900);
                int n = (int)tooltipPosX + 5;
                int n2 = (int)tooltipPosY + 5;
                Objects.requireNonNull(this.f_96541_.f_91062_);
                ClientUtils.drawSplitString(gui, desc, n, n2 + 9, (int)((float)this.f_96543_ * 0.6f), 0xFFFFFF);
                matrixStack.m_85849_();
            }
        }
    }

    public boolean m_7043_() {
        return false;
    }

    public void m_7379_() {
        if (this.parent.moogle != -1) {
            PacketHandler.sendToServer(new CSCloseMoogleGUI(this.parent.moogle));
        }
        super.m_7379_();
    }

    public boolean m_6375_(double mouseX, double mouseY, int mouseButton) {
        this.scrollBar.m_6375_(mouseX, mouseY, mouseButton);
        return super.m_6375_(mouseX, mouseY, mouseButton);
    }

    public boolean m_6348_(double pMouseX, double pMouseY, int pButton) {
        this.scrollBar.m_6348_(pMouseX, pMouseY, pButton);
        return super.m_6348_(pMouseX, pMouseY, pButton);
    }

    public boolean m_7979_(double pMouseX, double pMouseY, int pButton, double pDragX, double pDragY) {
        this.scrollBar.m_7979_(pMouseX, pMouseY, pButton, pDragX, pDragY);
        this.updateScroll();
        return super.m_7979_(pMouseX, pMouseY, pButton, pDragX, pDragY);
    }

    public void updateScroll() {
        this.inventory.forEach(button -> {
            button.offsetY = (int)this.scrollBar.scrollOffset;
        });
    }

    public boolean m_6050_(double mouseX, double mouseY, double delta) {
        this.scrollBar.m_6050_(mouseX, mouseY, delta);
        this.updateScroll();
        return false;
    }
}

