/*
 * Decompiled with CFR 0.152.
 */
package online.kingdomkeys.kingdomkeys.client.gui.synthesis;

import com.mojang.blaze3d.vertex.PoseStack;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.ConcurrentModificationException;
import java.util.Map;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.Renderable;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.registries.ForgeRegistries;
import online.kingdomkeys.kingdomkeys.KingdomKeys;
import online.kingdomkeys.kingdomkeys.capability.IPlayerCapabilities;
import online.kingdomkeys.kingdomkeys.capability.ModCapabilities;
import online.kingdomkeys.kingdomkeys.client.ClientUtils;
import online.kingdomkeys.kingdomkeys.client.gui.elements.MenuBox;
import online.kingdomkeys.kingdomkeys.client.gui.elements.MenuFilterable;
import online.kingdomkeys.kingdomkeys.client.gui.elements.buttons.MenuButton;
import online.kingdomkeys.kingdomkeys.client.gui.elements.buttons.MenuScrollBar;
import online.kingdomkeys.kingdomkeys.client.gui.elements.buttons.MenuStockItem;
import online.kingdomkeys.kingdomkeys.client.gui.synthesis.SynthesisScreen;
import online.kingdomkeys.kingdomkeys.client.sound.ModSounds;
import online.kingdomkeys.kingdomkeys.lib.Tags;
import online.kingdomkeys.kingdomkeys.network.PacketHandler;
import online.kingdomkeys.kingdomkeys.network.cts.CSCloseMoogleGUI;
import online.kingdomkeys.kingdomkeys.network.cts.CSDepositMaterials;
import online.kingdomkeys.kingdomkeys.network.cts.CSTakeMaterials;
import online.kingdomkeys.kingdomkeys.util.Utils;
import org.jetbrains.annotations.NotNull;

public class SynthesisMaterialScreen
extends MenuFilterable {
    MenuButton deposit;
    MenuButton back;
    MenuButton take;
    MenuBox boxL;
    MenuBox boxR;
    EditBox amountBox;
    SynthesisScreen parent;

    public SynthesisMaterialScreen(SynthesisScreen parent) {
        super("gui.synthesis.materials", new Color(0, 255, 0));
        this.drawPlayerInfo = true;
        this.parent = parent;
    }

    public SynthesisMaterialScreen(String inv, String name, int moogle) {
        this(new SynthesisScreen(inv, name, moogle));
    }

    @Override
    public void action(ResourceLocation stackRL, ItemStack stack) {
        super.action(stackRL, stack);
        int amount = ModCapabilities.getPlayer((Player)this.f_96541_.f_91074_).getMaterialAmount(stack.m_41720_());
        this.amountBox.m_94144_("" + Math.min(64, amount));
    }

    protected void action(String string) {
        IPlayerCapabilities playerData = ModCapabilities.getPlayer((Player)this.f_96541_.f_91074_);
        switch (string) {
            case "deposit": {
                this.f_96541_.f_91073_.m_5594_((Player)this.f_96541_.f_91074_, this.f_96541_.f_91074_.m_20183_(), (SoundEvent)ModSounds.menu_in.get(), SoundSource.MASTER, 1.0f, 1.0f);
                LocalPlayer player = this.f_96541_.f_91074_;
                try {
                    for (int i = 0; i < player.m_150109_().m_6643_(); ++i) {
                        ItemStack stack = player.m_150109_().m_8020_(i);
                        if (ItemStack.m_41728_((ItemStack)stack, (ItemStack)ItemStack.f_41583_) || !stack.m_204117_(Tags.MATERIALS)) continue;
                        playerData.addMaterial(stack.m_41720_(), stack.m_41613_());
                        player.m_150109_().m_6836_(i, ItemStack.f_41583_);
                    }
                }
                catch (ConcurrentModificationException e) {
                    e.printStackTrace();
                }
                PacketHandler.sendToServer(new CSDepositMaterials(this.parent.invFile, this.parent.name, this.parent.moogle));
                break;
            }
            case "back": {
                this.f_96541_.m_91152_((Screen)new SynthesisScreen(this.parent.invFile, this.parent.name, this.parent.moogle));
                break;
            }
            case "take": {
                ItemStack selectedItemstack = new ItemStack((ItemLike)ForgeRegistries.ITEMS.getValue(this.selectedRL));
                if (ItemStack.m_41656_((ItemStack)selectedItemstack, (ItemStack)ItemStack.f_41583_) || this.f_96541_.f_91074_.m_150109_().m_36062_() <= -1) break;
                try {
                    Integer.parseInt(this.amountBox.m_94155_());
                    PacketHandler.sendToServer(new CSTakeMaterials(selectedItemstack.m_41720_(), Integer.parseInt(this.amountBox.m_94155_()), this.parent.invFile, this.parent.name == null ? "" : this.parent.name, this.parent.moogle));
                    break;
                }
                catch (NumberFormatException e) {
                    KingdomKeys.LOGGER.error("NaN " + this.amountBox.m_94155_());
                }
            }
        }
    }

    @Override
    public void m_7856_() {
        float boxPosX = (float)this.f_96543_ * 0.2f;
        float topBarHeight = (float)this.f_96544_ * 0.17f;
        float boxWidth = (float)this.f_96543_ * 0.33f;
        float middleHeight = (float)this.f_96544_ * 0.6f;
        this.boxL = new MenuBox((int)boxPosX, (int)topBarHeight, (int)boxWidth, (int)middleHeight, 1.0f, new Color(40, 4, 255));
        this.boxR = new MenuBox(this.boxL.m_252754_() + this.boxL.m_5711_(), (int)topBarHeight, (int)boxWidth, (int)middleHeight, 1.0f, new Color(69, 69, 69));
        this.scrollBar = new MenuScrollBar((int)(boxPosX + boxWidth - 17.0f), this.boxL.m_252907_(), this.boxL.getPosY() + this.boxL.m_93694_(), (int)middleHeight, 0);
        this.m_142416_((GuiEventListener)this.scrollBar);
        super.m_7856_();
        this.initItems();
    }

    @Override
    public void initItems() {
        float buttonPosX = (float)this.f_96543_ * 0.008f;
        int button_statsY = (int)this.topBarHeight + 10;
        float buttonWidth = (float)this.f_96543_ * 0.1744f - 20.0f;
        float invPosX = this.boxL.m_252754_();
        float invPosY = (float)this.f_96544_ * 0.1851f;
        this.inventory.clear();
        this.m_6702_().clear();
        this.f_169369_.clear();
        ArrayList<ItemStack> items = new ArrayList<ItemStack>();
        IPlayerCapabilities playerData = ModCapabilities.getPlayer((Player)this.f_96541_.f_91074_);
        for (Map.Entry<ResourceLocation, Integer> mat : playerData.getMaterialMap().entrySet()) {
            Item item = (Item)BuiltInRegistries.f_257033_.m_7745_(mat.getKey());
            items.add(new ItemStack((ItemLike)item, mat.getValue().intValue()));
        }
        items.sort(Comparator.comparing(Utils::getCategoryForStack).thenComparing(ItemStack::m_41778_));
        for (int i = 0; i < items.size(); ++i) {
            MenuStockItem item = new MenuStockItem(this, (ItemStack)items.get(i), (int)invPosX, (int)invPosY + i * 14, this.boxL.m_5711_() - this.scrollBar.m_5711_() - 4, true);
            item.setBackgroundColor(new Color(30, 30, 100));
            this.inventory.add(item);
        }
        this.inventory.forEach(x$0 -> {
            MenuStockItem cfr_ignored_0 = (MenuStockItem)this.m_7787_((GuiEventListener)x$0);
        });
        this.deposit = new MenuButton((int)buttonPosX, button_statsY, (int)buttonWidth, Utils.translateToLocal("gui.synthesis.materials.deposit", new Object[0]), MenuButton.ButtonType.BUTTON, e -> this.action("deposit"));
        this.m_142416_((GuiEventListener)this.deposit);
        this.back = new MenuButton((int)buttonPosX, button_statsY + 18, (int)buttonWidth, Utils.translateToLocal("gui.menu.back", new Object[0]), MenuButton.ButtonType.BUTTON, e -> this.action("back"));
        this.m_142416_((GuiEventListener)this.back);
        this.amountBox = new EditBox(this.f_96541_.f_91062_, this.boxR.m_252754_() + 30, (int)(this.topBarHeight + this.middleHeight - 30.0f), this.f_96541_.f_91062_.m_92895_("#####"), 16, (Component)Component.m_237115_((String)"test")){

            public boolean m_5534_(char c, int i) {
                if (Utils.isNumber(c)) {
                    String text = new StringBuilder(this.m_94155_()).insert(this.m_94207_(), c).toString();
                    if (Integer.parseInt(text) > 64) {
                        return false;
                    }
                } else {
                    return false;
                }
                return super.m_5534_(c, i);
            }
        };
        this.m_142416_((GuiEventListener)this.amountBox);
        this.take = new MenuButton(this.amountBox.m_252754_() + this.amountBox.m_5711_() + 5, (int)(this.topBarHeight + this.middleHeight - 32.0f), 58, "gui.synthesis.materials.take", MenuButton.ButtonType.ROUNDBUTTON, e -> this.action("take"));
        this.take.setCenterText(true);
        this.m_142416_((GuiEventListener)this.take);
        this.take.f_93624_ = false;
    }

    @Override
    public void m_88315_(@NotNull GuiGraphics gui, int mouseX, int mouseY, float partialTicks) {
        this.drawMenuBackground(gui, mouseX, mouseY, partialTicks);
        this.boxL.m_87963_(gui, mouseX, mouseY, partialTicks);
        this.boxR.m_87963_(gui, mouseX, mouseY, partialTicks);
        gui.m_280246_(1.0f, 1.0f, 1.0f, 1.0f);
        super.m_88315_(gui, mouseX, mouseY, partialTicks);
        if (!this.inventory.isEmpty()) {
            int listHeight = ((MenuStockItem)((Object)this.inventory.get(this.inventory.size() - 1))).m_252907_() + 20 - ((MenuStockItem)((Object)this.inventory.get(0))).m_252907_() + 3;
            this.scrollBar.setContentHeight(listHeight);
        }
        if (this.f_96541_.f_91074_.m_150109_().m_36062_() == -1) {
            this.take.f_93623_ = false;
            this.take.m_93666_((Component)Component.m_237115_((String)"gui.shop.no_empty_slot"));
        }
        for (MenuStockItem stockItem : this.inventory) {
            stockItem.f_93623_ = false;
        }
        for (Renderable renderable : this.inventory) {
            if (renderable instanceof MenuStockItem) {
                MenuStockItem menuStockItem = (MenuStockItem)renderable;
                menuStockItem.f_93623_ = true;
                gui.m_280588_(this.boxL.m_252754_() + 2, this.scrollBar.m_252907_() + 2, this.boxL.m_252754_() + this.boxL.m_5711_(), this.scrollBar.getBottom() - 5);
                renderable.m_88315_(gui, mouseX, mouseY, partialTicks);
                gui.m_280618_();
                continue;
            }
            renderable.m_88315_(gui, mouseX, mouseY, partialTicks);
        }
        this.deposit.m_88315_(gui, mouseX, mouseY, partialTicks);
        this.back.m_88315_(gui, mouseX, mouseY, partialTicks);
    }

    @Override
    protected void renderSelectedData(GuiGraphics gui, int mouseX, int mouseY, float partialTicks) {
        PoseStack matrixStack = gui.m_280168_();
        this.amountBox.m_88315_(gui, mouseX, mouseY, partialTicks);
        this.take.m_88315_(gui, mouseX, mouseY, partialTicks);
        this.take.f_93624_ = true;
        float iconPosX = this.boxR.m_252754_();
        float iconPosY = this.boxR.m_252907_() + 15;
        matrixStack.m_85836_();
        String name = this.selectedItemStack.m_41786_().getString();
        matrixStack.m_252880_((float)(this.boxR.m_252754_() + this.boxR.m_5711_() / 2 - this.f_96541_.f_91062_.m_92895_(name) / 2), (float)(this.boxR.m_252907_() + 3), 1.0f);
        gui.m_280488_(this.f_96541_.f_91062_, Utils.translateToLocal(name, new Object[0]), 0, 0, 0xFF9900);
        matrixStack.m_85849_();
        matrixStack.m_85836_();
        float size = 80.0f;
        double offset = (float)this.boxR.m_5711_() * 0.1f;
        matrixStack.m_85837_((double)this.boxR.m_252754_() + offset / 2.0, (double)iconPosY, 1.0);
        matrixStack.m_252880_((float)this.boxR.m_5711_() * 0.7f / 2.0f, (float)(this.boxR.m_93694_() / 2) - size / 2.0f, 0.0f);
        ClientUtils.drawItemAsIcon(this.selectedItemStack, matrixStack, 0, 0, (int)size);
        matrixStack.m_85849_();
    }

    public boolean m_6375_(double mouseX, double mouseY, int mouseButton) {
        this.scrollBar.m_6375_(mouseX, mouseY, mouseButton);
        return super.m_6375_(mouseX, mouseY, mouseButton);
    }

    public boolean m_6348_(double pMouseX, double pMouseY, int pButton) {
        this.scrollBar.m_6348_(pMouseX, pMouseY, pButton);
        return super.m_6348_(pMouseX, pMouseY, pButton);
    }

    public boolean m_7979_(double pMouseX, double pMouseY, int pButton, double pDragX, double pDragY) {
        this.scrollBar.m_7979_(pMouseX, pMouseY, pButton, pDragX, pDragY);
        this.updateScroll();
        return super.m_7979_(pMouseX, pMouseY, pButton, pDragX, pDragY);
    }

    public void updateScroll() {
        this.inventory.forEach(button -> {
            button.offsetY = (int)this.scrollBar.scrollOffset;
        });
    }

    public boolean m_6050_(double mouseX, double mouseY, double deltaY) {
        if (mouseX >= (double)this.boxL.m_252754_() && mouseX <= (double)(this.scrollBar.m_252754_() + this.scrollBar.m_5711_())) {
            this.scrollBar.m_6050_(mouseX, mouseY, deltaY);
        }
        this.updateScroll();
        return false;
    }

    public boolean m_7043_() {
        return false;
    }

    public void m_7379_() {
        if (this.parent.moogle != -1) {
            PacketHandler.sendToServer(new CSCloseMoogleGUI(this.parent.moogle));
        }
        super.m_7379_();
    }
}

