/*
 * Decompiled with CFR 0.152.
 */
package online.kingdomkeys.kingdomkeys.client.gui.synthesis;

import java.awt.Color;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.items.IItemHandler;
import online.kingdomkeys.kingdomkeys.KingdomKeys;
import online.kingdomkeys.kingdomkeys.capability.IPlayerCapabilities;
import online.kingdomkeys.kingdomkeys.capability.ModCapabilities;
import online.kingdomkeys.kingdomkeys.client.gui.elements.MenuBackground;
import online.kingdomkeys.kingdomkeys.client.gui.elements.buttons.MenuButton;
import online.kingdomkeys.kingdomkeys.client.gui.synthesis.ShopScreen;
import online.kingdomkeys.kingdomkeys.client.gui.synthesis.SynthesisCreateScreen;
import online.kingdomkeys.kingdomkeys.client.gui.synthesis.SynthesisForgeScreen;
import online.kingdomkeys.kingdomkeys.client.gui.synthesis.SynthesisMaterialScreen;
import online.kingdomkeys.kingdomkeys.client.sound.ModSounds;
import online.kingdomkeys.kingdomkeys.config.ModConfigs;
import online.kingdomkeys.kingdomkeys.item.KeychainItem;
import online.kingdomkeys.kingdomkeys.item.SynthesisBagItem;
import online.kingdomkeys.kingdomkeys.lib.Tags;
import online.kingdomkeys.kingdomkeys.network.PacketHandler;
import online.kingdomkeys.kingdomkeys.network.cts.CSCloseMoogleGUI;
import online.kingdomkeys.kingdomkeys.synthesis.shop.ShopListRegistry;
import online.kingdomkeys.kingdomkeys.util.Utils;
import org.jetbrains.annotations.NotNull;

public class SynthesisScreen
extends MenuBackground {
    MenuButton synthesise;
    MenuButton forge;
    MenuButton materials;
    MenuButton shop;
    String invFile = ModConfigs.projectorHasShop ? "kingdomkeys:default" : "";
    int moogle = -1;
    String name;

    public SynthesisScreen(String name) {
        super(!name.isEmpty() ? name : "gui.synthesis", new Color(0, 255, 0));
        this.drawPlayerInfo = true;
    }

    public SynthesisScreen(String inv, String name, int moogle) {
        this(name == null || name.isEmpty() ? "gui.synthesis" : Component.m_237110_((String)"gui.synthesis.moogle.title", (Object[])new Object[]{name}).getString());
        this.moogle = moogle;
        this.name = name;
        if (ShopListRegistry.getInstance().containsKey(new ResourceLocation(inv)) || inv.isEmpty()) {
            this.invFile = inv;
        } else {
            KingdomKeys.LOGGER.error("The Shop '" + inv + "' does not exist or didn't get registered");
            this.invFile = "";
        }
    }

    protected void action(String string) {
        switch (string) {
            case "synthesise": {
                this.f_96541_.f_91073_.m_5594_((Player)this.f_96541_.f_91074_, this.f_96541_.f_91074_.m_20183_(), (SoundEvent)ModSounds.menu_in.get(), SoundSource.MASTER, 1.0f, 1.0f);
                this.f_96541_.m_91152_((Screen)new SynthesisCreateScreen(this));
                break;
            }
            case "forge": {
                this.f_96541_.f_91073_.m_5594_((Player)this.f_96541_.f_91074_, this.f_96541_.f_91074_.m_20183_(), (SoundEvent)ModSounds.menu_in.get(), SoundSource.MASTER, 1.0f, 1.0f);
                this.f_96541_.m_91152_((Screen)new SynthesisForgeScreen(this));
                break;
            }
            case "materials": {
                this.f_96541_.f_91073_.m_5594_((Player)this.f_96541_.f_91074_, this.f_96541_.f_91074_.m_20183_(), (SoundEvent)ModSounds.menu_in.get(), SoundSource.MASTER, 1.0f, 1.0f);
                this.f_96541_.m_91152_((Screen)new SynthesisMaterialScreen(this));
                break;
            }
            case "shop": {
                this.f_96541_.f_91073_.m_5594_((Player)this.f_96541_.f_91074_, this.f_96541_.f_91074_.m_20183_(), (SoundEvent)ModSounds.menu_in.get(), SoundSource.MASTER, 1.0f, 1.0f);
                this.f_96541_.m_91152_((Screen)new ShopScreen(this));
            }
        }
    }

    public void m_7379_() {
        if (this.moogle != -1) {
            PacketHandler.sendToServer(new CSCloseMoogleGUI(this.moogle));
        }
        super.m_7379_();
    }

    @Override
    public void m_7856_() {
        super.m_7856_();
        this.f_169369_.clear();
        float topBarHeight = (float)this.f_96544_ * 0.17f;
        int button_statsY = (int)topBarHeight + 5;
        float buttonPosX = (float)this.f_96543_ * 0.03f;
        float buttonWidth = (float)this.f_96543_ * 0.1744f - 20.0f;
        int pos = 0;
        if (this.invFile != null && !this.invFile.equals("")) {
            this.shop = new MenuButton((int)buttonPosX, button_statsY + pos++ * 18, (int)buttonWidth, Utils.translateToLocal("gui.shop", new Object[0]), MenuButton.ButtonType.BUTTON, e -> this.action("shop"));
            this.m_142416_((GuiEventListener)this.shop);
        }
        this.synthesise = new MenuButton((int)buttonPosX, button_statsY + pos++ * 18, (int)buttonWidth, Utils.translateToLocal("gui.synthesis.synthesise", new Object[0]), MenuButton.ButtonType.BUTTON, e -> this.action("synthesise"));
        this.m_142416_((GuiEventListener)this.synthesise);
        this.forge = new MenuButton((int)buttonPosX, button_statsY + pos++ * 18, (int)buttonWidth, Utils.translateToLocal("gui.synthesis.forge", new Object[0]), MenuButton.ButtonType.BUTTON, e -> this.action("forge"));
        this.m_142416_((GuiEventListener)this.forge);
        this.materials = new MenuButton((int)buttonPosX, button_statsY + pos++ * 18, (int)buttonWidth, Utils.translateToLocal("gui.synthesis.materials", new Object[0]), MenuButton.ButtonType.BUTTON, e -> this.action("materials"));
        this.m_142416_((GuiEventListener)this.materials);
        boolean hasKeychain = false;
        boolean hasMaterial = false;
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        for (int i = 0; i < player.m_150109_().m_6643_(); ++i) {
            if (!hasKeychain && player.m_150109_().m_8020_(i).m_41720_() instanceof KeychainItem) {
                hasKeychain = true;
            }
            if (!hasMaterial && player.m_150109_().m_8020_(i).m_204117_(Tags.MATERIALS)) {
                hasMaterial = true;
            }
            if (!(player.m_150109_().m_8020_(i).m_41720_() instanceof SynthesisBagItem)) continue;
            IItemHandler bagInv = (IItemHandler)player.m_150109_().m_8020_(i).getCapability(ForgeCapabilities.ITEM_HANDLER, null).orElse(null);
            for (int j = 0; j < bagInv.getSlots(); ++j) {
                ItemStack bagItem = bagInv.getStackInSlot(j);
                if (ItemStack.m_41728_((ItemStack)bagItem, (ItemStack)ItemStack.f_41583_) || !bagItem.m_204117_(Tags.MATERIALS)) continue;
                hasMaterial = true;
            }
        }
        IPlayerCapabilities playerData = ModCapabilities.getPlayer((Player)player);
        for (ItemStack stack : playerData.getEquippedKeychains().values()) {
            if (stack.m_41619_()) continue;
            hasKeychain = true;
            break;
        }
        if (playerData.getKnownRecipeList().isEmpty()) {
            this.synthesise.f_93623_ = false;
        }
        if (!hasKeychain) {
            this.forge.f_93623_ = false;
        }
        if (playerData.getMaterialMap().isEmpty() && !hasMaterial) {
            this.materials.f_93623_ = false;
        }
    }

    @Override
    public void m_88315_(@NotNull GuiGraphics gui, int mouseX, int mouseY, float partialTicks) {
        super.m_88315_(gui, mouseX, mouseY, partialTicks);
    }

    public boolean m_7043_() {
        return false;
    }
}

