/*
 * Decompiled with CFR 0.152.
 */
package online.kingdomkeys.kingdomkeys.client.render.entity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.Sheets;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.client.model.data.ModelData;
import online.kingdomkeys.kingdomkeys.client.model.entity.WhiteMushroomModel;
import online.kingdomkeys.kingdomkeys.entity.EntityHelper;
import online.kingdomkeys.kingdomkeys.entity.mob.WhiteMushroomEntity;

public class WhiteMushroomRenderer<Type extends WhiteMushroomEntity>
extends MobRenderer<Type, WhiteMushroomModel<Type>> {
    int prevState = 0;
    int ticksDespawning = 0;

    public WhiteMushroomRenderer(EntityRendererProvider.Context context) {
        super(context, new WhiteMushroomModel(context.m_174023_(WhiteMushroomModel.LAYER_LOCATION)), 0.5f);
    }

    public void render(Type entity, float entityYaw, float partialTicks, PoseStack matrixStackIn, MultiBufferSource bufferIn, int packedLightIn) {
        matrixStackIn.m_85836_();
        if (EntityHelper.getState(entity) == -2) {
            if (this.prevState != -2) {
                this.ticksDespawning = ((WhiteMushroomEntity)entity).f_19797_;
            }
            VertexConsumer buffer = bufferIn.m_6299_(Sheets.m_110792_());
            BakedModel model = Minecraft.m_91087_().m_91304_().getModel(new ResourceLocation("kingdomkeys", "entity/portal"));
            matrixStackIn.m_85836_();
            float[] rgb = new float[]{0.2f, 0.1f, 0.3f, 0.9f};
            int offsetTicks = 25;
            int maxTicks = 20;
            float ticks = ((WhiteMushroomEntity)entity).f_19797_ - this.ticksDespawning - offsetTicks;
            if (ticks < 10.0f) {
                matrixStackIn.m_85841_(ticks * 0.2f, ticks * 0.2f, ticks * 0.2f);
            } else if (ticks > (float)(maxTicks - 10 - offsetTicks)) {
                matrixStackIn.m_85841_(((float)maxTicks - ticks) * 0.2f, ((float)maxTicks - ticks) * 0.2f, ((float)maxTicks - ticks) * 0.2f);
            } else {
                matrixStackIn.m_85841_(2.0f, 2.0f, 2.0f);
            }
            matrixStackIn.m_85841_(1.0f, 0.5f, 1.0f);
            matrixStackIn.m_252781_(Axis.f_252392_.m_252977_(Minecraft.m_91087_().f_91074_.m_20155_().f_82471_));
            for (BakedQuad quad : model.getQuads(null, null, entity.m_9236_().f_46441_, ModelData.EMPTY, RenderType.m_110466_())) {
                buffer.putBulkData(matrixStackIn.m_85850_(), quad, rgb[0], rgb[1], rgb[2], rgb[3], 0xF000F0, OverlayTexture.f_118083_, true);
            }
            matrixStackIn.m_85849_();
        }
        super.m_7392_(entity, entityYaw, partialTicks, matrixStackIn, bufferIn, packedLightIn);
        matrixStackIn.m_85849_();
        this.prevState = EntityHelper.getState(entity);
    }

    protected void scale(Type entitylivingbaseIn, PoseStack matrixStackIn, float partialTickTime) {
        matrixStackIn.m_85841_(0.6f, 0.6f, 0.6f);
        super.m_7546_(entitylivingbaseIn, matrixStackIn, partialTickTime);
    }

    public ResourceLocation getTextureLocation(Type pEntity) {
        return new ResourceLocation("kingdomkeys", "textures/entity/mob/white_mushroom.png");
    }
}

