/*
 * Decompiled with CFR 0.152.
 */
package online.kingdomkeys.kingdomkeys.command;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;
import online.kingdomkeys.kingdomkeys.KingdomKeys;
import online.kingdomkeys.kingdomkeys.api.event.ChoiceEvent;
import online.kingdomkeys.kingdomkeys.capability.IPlayerCapabilities;
import online.kingdomkeys.kingdomkeys.capability.ModCapabilities;
import online.kingdomkeys.kingdomkeys.command.BaseCommand;
import online.kingdomkeys.kingdomkeys.lib.SoAState;
import online.kingdomkeys.kingdomkeys.network.PacketHandler;
import online.kingdomkeys.kingdomkeys.network.stc.SCSyncCapabilityPacket;

public class ChoiceCommand
extends BaseCommand {
    public static SuggestionProvider<CommandSourceStack> SUGGEST_CHOICES = (p_198296_0_, p_198296_1_) -> {
        List<String> list = Arrays.asList("WARRIOR", "GUARDIAN", "MYSTIC");
        try {
            String chosen = StringArgumentType.getString((CommandContext)p_198296_0_, (String)"chosen");
            if (list.contains(chosen)) {
                return SharedSuggestionProvider.m_82981_(list.stream().filter(s -> !s.equals(chosen)).map(StringArgumentType::escapeIfRequired), (SuggestionsBuilder)p_198296_1_);
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        return SharedSuggestionProvider.m_82981_(list.stream().map(StringArgumentType::escapeIfRequired), (SuggestionsBuilder)p_198296_1_);
    };

    public static ArgumentBuilder<CommandSourceStack, ?> register() {
        LiteralArgumentBuilder builder = (LiteralArgumentBuilder)Commands.m_82127_((String)"choice").requires(source -> source.m_6761_(2));
        builder.then(Commands.m_82129_((String)"chosen", (ArgumentType)StringArgumentType.string()).suggests(SUGGEST_CHOICES).then(((RequiredArgumentBuilder)Commands.m_82129_((String)"sacrificed", (ArgumentType)StringArgumentType.string()).suggests(SUGGEST_CHOICES).then(Commands.m_82129_((String)"targets", (ArgumentType)EntityArgument.m_91470_()).executes(ChoiceCommand::makeChoice))).executes(ChoiceCommand::makeChoice)));
        builder.then(((LiteralArgumentBuilder)Commands.m_82127_((String)"_reset").then(Commands.m_82129_((String)"targets", (ArgumentType)EntityArgument.m_91470_()).executes(ChoiceCommand::resetChoice))).executes(ChoiceCommand::resetChoice));
        KingdomKeys.LOGGER.warn("Registered command " + builder.getLiteral());
        return builder;
    }

    public static SoAState stringToChoice(String choice) {
        return switch (choice) {
            case "WARRIOR" -> SoAState.WARRIOR;
            case "GUARDIAN" -> SoAState.GUARDIAN;
            case "MYSTIC" -> SoAState.MYSTIC;
            default -> SoAState.NONE;
        };
    }

    private static int resetChoice(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        Collection<ServerPlayer> players = ChoiceCommand.getPlayers(context, 3);
        for (ServerPlayer target : players) {
            IPlayerCapabilities targetData = ModCapabilities.getPlayer((Player)target);
            if (targetData.getSoAState() == SoAState.COMPLETE) {
                SoAState.applyStatsForChoices((Player)target, targetData, true);
                MinecraftForge.EVENT_BUS.post((Event)new ChoiceEvent((Player)target, SoAState.NONE, SoAState.NONE));
            }
            targetData.setSoAState(SoAState.NONE);
            targetData.setChoice(SoAState.NONE);
            targetData.setSacrifice(SoAState.NONE);
            PacketHandler.sendTo(new SCSyncCapabilityPacket(targetData), target);
            if (players.size() > 1) {
                ((CommandSourceStack)context.getSource()).m_288197_(() -> Component.m_237110_((String)"Station of Awakening choice has been reset for %s", (Object[])new Object[]{target.m_7755_().getString()}), true);
            }
            target.m_213846_((Component)Component.m_237115_((String)"Your Station of Awakening choice has been reset"));
        }
        return 1;
    }

    private static int makeChoice(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        Collection<ServerPlayer> players = ChoiceCommand.getPlayers(context, 4);
        String chosenStr = StringArgumentType.getString(context, (String)"chosen");
        SoAState chosen = ChoiceCommand.stringToChoice(chosenStr);
        String sacrificedStr = StringArgumentType.getString(context, (String)"sacrificed");
        SoAState sacrificed = ChoiceCommand.stringToChoice(sacrificedStr);
        if (chosen != SoAState.NONE && sacrificed != SoAState.NONE) {
            if (!chosen.equals((Object)sacrificed)) {
                for (ServerPlayer target : players) {
                    IPlayerCapabilities targetData = ModCapabilities.getPlayer((Player)target);
                    boolean noChange = false;
                    if (targetData.getSoAState() == SoAState.COMPLETE) {
                        if (targetData.getChosen() == chosen && targetData.getSacrificed() == sacrificed) {
                            noChange = true;
                        } else {
                            SoAState.applyStatsForChoices((Player)target, targetData, true);
                        }
                    }
                    if (!noChange) {
                        targetData.setSoAState(SoAState.COMPLETE);
                        targetData.setSacrifice(sacrificed);
                        targetData.setChoice(chosen);
                        SoAState.applyStatsForChoices((Player)target, targetData, false);
                    }
                    PacketHandler.sendTo(new SCSyncCapabilityPacket(targetData), target);
                    if (players.size() > 1) {
                        ((CommandSourceStack)context.getSource()).m_288197_(() -> Component.m_237110_((String)"Station of Awakening choice has been set to %s and %s for %s", (Object[])new Object[]{chosenStr, sacrificedStr, target.m_7755_().getString()}), true);
                    }
                    target.m_213846_((Component)Component.m_237110_((String)"Your Station of Awakening choice has been set to %s and %s", (Object[])new Object[]{chosenStr, sacrificedStr}));
                }
            } else {
                ((CommandSourceStack)context.getSource()).m_81352_((Component)Component.m_237115_((String)"CHOSEN and SACRIFICED must not be the same"));
            }
        } else {
            ((CommandSourceStack)context.getSource()).m_81352_((Component)Component.m_237115_((String)"CHOSEN or SACRIFICED value is invalid"));
        }
        return 1;
    }
}

