/*
 * Decompiled with CFR 0.152.
 */
package online.kingdomkeys.kingdomkeys.command;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.Collection;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import online.kingdomkeys.kingdomkeys.KingdomKeys;
import online.kingdomkeys.kingdomkeys.capability.IPlayerCapabilities;
import online.kingdomkeys.kingdomkeys.capability.ModCapabilities;
import online.kingdomkeys.kingdomkeys.command.BaseCommand;
import online.kingdomkeys.kingdomkeys.network.PacketHandler;
import online.kingdomkeys.kingdomkeys.network.stc.SCSyncCapabilityPacket;

public class FocusPointsCommand
extends BaseCommand {
    public static ArgumentBuilder<CommandSourceStack, ?> register() {
        LiteralArgumentBuilder builder = (LiteralArgumentBuilder)Commands.m_82127_((String)"focus").requires(source -> source.m_6761_(2));
        builder.then(Commands.m_82127_((String)"set").then(((RequiredArgumentBuilder)Commands.m_82129_((String)"value", (ArgumentType)IntegerArgumentType.integer((int)1, (int)Integer.MAX_VALUE)).then(Commands.m_82129_((String)"targets", (ArgumentType)EntityArgument.m_91470_()).executes(FocusPointsCommand::setValue))).executes(FocusPointsCommand::setValue)));
        builder.then(Commands.m_82127_((String)"give").then(((RequiredArgumentBuilder)Commands.m_82129_((String)"value", (ArgumentType)IntegerArgumentType.integer((int)1, (int)Integer.MAX_VALUE)).then(Commands.m_82129_((String)"targets", (ArgumentType)EntityArgument.m_91470_()).executes(FocusPointsCommand::addValue))).executes(FocusPointsCommand::addValue)));
        builder.then(Commands.m_82127_((String)"take").then(((RequiredArgumentBuilder)Commands.m_82129_((String)"value", (ArgumentType)IntegerArgumentType.integer((int)1, (int)Integer.MAX_VALUE)).then(Commands.m_82129_((String)"targets", (ArgumentType)EntityArgument.m_91470_()).executes(FocusPointsCommand::removeValue))).executes(FocusPointsCommand::removeValue)));
        KingdomKeys.LOGGER.warn("Registered command " + builder.getLiteral());
        return builder;
    }

    private static int setValue(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        Collection<ServerPlayer> players = FocusPointsCommand.getPlayers(context, 4);
        int value = IntegerArgumentType.getInteger(context, (String)"value");
        for (ServerPlayer player : players) {
            FocusPointsCommand.setValue(context, value, player);
        }
        return 1;
    }

    private static int setValue(CommandContext<CommandSourceStack> context, int value, ServerPlayer player) throws CommandSyntaxException {
        IPlayerCapabilities playerData = ModCapabilities.getPlayer((Player)player);
        playerData.setFocus(value);
        ((CommandSourceStack)context.getSource()).m_288197_(() -> Component.m_237115_((String)("Set " + player.m_5446_().getString() + " focus to " + value)), true);
        player.m_213846_((Component)Component.m_237115_((String)("Your focus has been set to " + value)));
        PacketHandler.sendTo(new SCSyncCapabilityPacket(playerData), player);
        return 1;
    }

    private static int addValue(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        Collection<ServerPlayer> players = FocusPointsCommand.getPlayers(context, 4);
        int value = IntegerArgumentType.getInteger(context, (String)"value");
        for (ServerPlayer player : players) {
            FocusPointsCommand.addValue(context, value, player);
        }
        return 1;
    }

    private static int addValue(CommandContext<CommandSourceStack> context, int value, ServerPlayer player) throws CommandSyntaxException {
        IPlayerCapabilities playerData = ModCapabilities.getPlayer((Player)player);
        playerData.addFocus(value);
        ((CommandSourceStack)context.getSource()).m_288197_(() -> Component.m_237115_((String)("Added " + value + " focus to " + player.m_5446_().getString())), true);
        player.m_213846_((Component)Component.m_237115_((String)("Your focus has been increased by " + value)));
        PacketHandler.sendTo(new SCSyncCapabilityPacket(playerData), player);
        return 1;
    }

    private static int removeValue(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        Collection<ServerPlayer> players = FocusPointsCommand.getPlayers(context, 4);
        int value = IntegerArgumentType.getInteger(context, (String)"value");
        for (ServerPlayer player : players) {
            FocusPointsCommand.removeValue(context, value, player);
        }
        return 1;
    }

    private static int removeValue(CommandContext<CommandSourceStack> context, int value, ServerPlayer player) throws CommandSyntaxException {
        IPlayerCapabilities playerData = ModCapabilities.getPlayer((Player)player);
        playerData.remFocus(value);
        ((CommandSourceStack)context.getSource()).m_288197_(() -> Component.m_237115_((String)("Taken " + value + " focus from " + player.m_5446_().getString())), true);
        player.m_213846_((Component)Component.m_237115_((String)("Your focus has been decreased by " + value)));
        PacketHandler.sendTo(new SCSyncCapabilityPacket(playerData), player);
        return 1;
    }
}

