/*
 * Decompiled with CFR 0.152.
 */
package online.kingdomkeys.kingdomkeys.command;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.Collection;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.player.Player;
import online.kingdomkeys.kingdomkeys.KingdomKeys;
import online.kingdomkeys.kingdomkeys.capability.IPlayerCapabilities;
import online.kingdomkeys.kingdomkeys.capability.ModCapabilities;
import online.kingdomkeys.kingdomkeys.client.sound.ModSounds;
import online.kingdomkeys.kingdomkeys.command.BaseCommand;
import online.kingdomkeys.kingdomkeys.lib.SoAState;
import online.kingdomkeys.kingdomkeys.network.PacketHandler;
import online.kingdomkeys.kingdomkeys.network.stc.SCSyncCapabilityPacket;
import online.kingdomkeys.kingdomkeys.util.Utils;

public class LevelCommand
extends BaseCommand {
    public static ArgumentBuilder<CommandSourceStack, ?> register() {
        LiteralArgumentBuilder builder = (LiteralArgumentBuilder)Commands.m_82127_((String)"level").requires(source -> source.m_6761_(2));
        builder.then(Commands.m_82127_((String)"set").then(((RequiredArgumentBuilder)Commands.m_82129_((String)"level", (ArgumentType)IntegerArgumentType.integer((int)1, (int)100)).then(Commands.m_82129_((String)"targets", (ArgumentType)EntityArgument.m_91470_()).executes(LevelCommand::setValue))).executes(LevelCommand::setValue)));
        KingdomKeys.LOGGER.warn("Registered command " + builder.getLiteral());
        return builder;
    }

    private static int setValue(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        Collection<ServerPlayer> players = LevelCommand.getPlayers(context, 4);
        int level = IntegerArgumentType.getInteger(context, (String)"level");
        for (ServerPlayer player : players) {
            IPlayerCapabilities playerData = ModCapabilities.getPlayer((Player)player);
            Utils.restartLevel(playerData, (Player)player);
            if (playerData.getSoAState() == SoAState.COMPLETE) {
                while (playerData.getLevel() < level) {
                    playerData.addExperience((Player)player, playerData.getExpNeeded(level - 1, playerData.getExperience()), false, false);
                }
                ((CommandSourceStack)context.getSource()).m_288197_(() -> Component.m_237115_((String)("Set " + player.m_5446_().getString() + " level to " + level)), true);
                player.m_213846_((Component)Component.m_237115_((String)("Your level is now " + level)));
                player.m_9236_().m_5594_((Player)null, player.m_20183_(), (SoundEvent)ModSounds.levelup.get(), SoundSource.MASTER, 1.0f, 1.0f);
            } else {
                ((CommandSourceStack)context.getSource()).m_288197_(() -> Component.m_237115_((String)(player.m_5446_().getString() + " has to make a choice first")), true);
            }
            Utils.restartLevel2(playerData, (Player)player);
            PacketHandler.sendTo(new SCSyncCapabilityPacket(playerData), player);
        }
        return 1;
    }
}

