/*
 * Decompiled with CFR 0.152.
 */
package online.kingdomkeys.kingdomkeys.datagen.init;

import java.util.Objects;
import java.util.function.Supplier;
import net.minecraft.data.DataGenerator;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.client.model.generators.BlockModelBuilder;
import net.minecraftforge.client.model.generators.BlockStateProvider;
import net.minecraftforge.client.model.generators.ConfiguredModel;
import net.minecraftforge.client.model.generators.ModelBuilder;
import net.minecraftforge.client.model.generators.ModelFile;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.RegistryObject;
import online.kingdomkeys.kingdomkeys.block.GhostBloxBlock;
import online.kingdomkeys.kingdomkeys.block.INoDataGen;
import online.kingdomkeys.kingdomkeys.block.KKOreBlock;
import online.kingdomkeys.kingdomkeys.block.ModBlocks;
import online.kingdomkeys.kingdomkeys.block.PairBloxBlock;

public class BlockStates
extends BlockStateProvider {
    public BlockStates(DataGenerator gen, ExistingFileHelper exFileHelper) {
        super(gen.getPackOutput(), "kingdomkeys", exFileHelper);
    }

    protected void registerStatesAndModels() {
        for (RegistryObject itemRegistryObject : ModBlocks.BLOCKS.getEntries()) {
            Block block = (Block)itemRegistryObject.get();
            String name = Objects.requireNonNull(ForgeRegistries.BLOCKS.getKey((Object)block)).m_135815_();
            if (block instanceof GhostBloxBlock) {
                this.getVariantBuilder(block).forAllStates(state -> {
                    boolean active = (Boolean)state.m_61143_((Property)GhostBloxBlock.VISIBLE);
                    String modelName = active ? name + "_visible" : name + "_invisible";
                    ConfiguredModel.Builder builder = ConfiguredModel.builder();
                    ModelBuilder blockModel = ((BlockModelBuilder)this.models().withExistingParent(modelName, new ResourceLocation("block/cube_all"))).texture("all", new ResourceLocation("kingdomkeys", "block/" + modelName));
                    builder.modelFile((ModelFile)blockModel);
                    if (active) {
                        this.simpleBlockItem(block, (ModelFile)blockModel);
                    }
                    return builder.build();
                });
                continue;
            }
            if (block instanceof PairBloxBlock) {
                this.getVariantBuilder(block).forAllStates(state -> {
                    int pairState = (Integer)state.m_61143_((Property)PairBloxBlock.PAIR);
                    String modelName = name + "_" + pairState;
                    ConfiguredModel.Builder builder = ConfiguredModel.builder();
                    ModelBuilder blockModel = ((BlockModelBuilder)this.models().withExistingParent(modelName, new ResourceLocation("block/cube_all"))).texture("all", new ResourceLocation("kingdomkeys", "block/" + modelName));
                    builder.modelFile((ModelFile)blockModel);
                    if (pairState == 0) {
                        this.simpleBlockItem(block, (ModelFile)blockModel);
                    }
                    return builder.build();
                });
                continue;
            }
            if (block instanceof INoDataGen) continue;
            if (block instanceof KKOreBlock && name.endsWith("_n")) {
                this.simpleNetherOre((Supplier<? extends Block>)itemRegistryObject);
                continue;
            }
            this.simpleBlock((Supplier<? extends Block>)itemRegistryObject);
        }
    }

    public void simpleBlock(Supplier<? extends Block> blockSupplier) {
        this.simpleBlock(blockSupplier.get());
    }

    public void simpleBlock(Block block, ModelFile model) {
        super.simpleBlock(block, model);
        this.simpleBlockItem(block, model);
    }

    public ModelFile netherCubeAll(Block block) {
        ResourceLocation name = ForgeRegistries.BLOCKS.getKey((Object)block);
        return this.models().cubeAll(name.m_135815_(), new ResourceLocation(name.m_135827_(), "block/" + name.m_135815_() + "ether"));
    }

    public void simpleNetherOre(Supplier<? extends Block> blockSupplier) {
        this.simpleBlock(blockSupplier.get(), this.netherCubeAll(blockSupplier.get()));
    }
}

