/*
 * Decompiled with CFR 0.152.
 */
package online.kingdomkeys.kingdomkeys.driveform;

import net.minecraft.client.Minecraft;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.boss.enderdragon.EnderDragon;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import online.kingdomkeys.kingdomkeys.capability.IPlayerCapabilities;
import online.kingdomkeys.kingdomkeys.capability.ModCapabilities;
import online.kingdomkeys.kingdomkeys.config.ModConfigs;
import online.kingdomkeys.kingdomkeys.driveform.DriveForm;
import online.kingdomkeys.kingdomkeys.driveform.ModDriveForms;
import online.kingdomkeys.kingdomkeys.network.PacketHandler;
import online.kingdomkeys.kingdomkeys.network.stc.SCSyncCapabilityPacket;

@Mod.EventBusSubscriber(modid="kingdomkeys")
public class DriveFormValor
extends DriveForm {
    public DriveFormValor(String registryName, int order, ResourceLocation skinRL, boolean hasKeychain, boolean baseGrowth) {
        super(registryName, order, hasKeychain, baseGrowth);
        this.color = new float[]{1.0f, 0.0f, 0.0f};
        this.skinRL = skinRL;
    }

    @SubscribeEvent
    public static void getValorFormXP(LivingAttackEvent event) {
        Player player;
        IPlayerCapabilities playerData;
        if (!event.getEntity().m_9236_().f_46443_ && (event.getEntity() instanceof Monster || event.getEntity() instanceof EnderDragon) && event.getSource().m_7639_() instanceof Player && (playerData = ModCapabilities.getPlayer(player = (Player)event.getSource().m_7639_())) != null && playerData.getActiveDriveForm().equals("kingdomkeys:form_valor")) {
            double mult = Double.parseDouble(ModConfigs.driveFormXPMultiplier.get(0).split(",")[1]);
            playerData.setDriveFormExp(player, playerData.getActiveDriveForm(), (int)((double)playerData.getDriveFormExp(playerData.getActiveDriveForm()) + 1.0 * mult));
            PacketHandler.sendTo(new SCSyncCapabilityPacket(playerData), (ServerPlayer)player);
        }
    }

    @SubscribeEvent
    public static void onLivingUpdate(LivingEvent.LivingTickEvent event) {
        Player player;
        IPlayerCapabilities playerData;
        if (event.getEntity() instanceof Player && (playerData = ModCapabilities.getPlayer(player = (Player)event.getEntity())) != null && DriveFormValor.shouldHandleHighJump(player, playerData)) {
            DriveFormValor.handleHighJump(player, playerData);
        }
    }

    private static boolean shouldHandleHighJump(Player player, IPlayerCapabilities playerData) {
        if (playerData.getDriveFormMap() == null) {
            return false;
        }
        if (playerData.getActiveDriveForm().equals("kingdomkeys:form_valor") || playerData.getActiveDriveForm().equals(DriveForm.NONE.toString()) && playerData.getDriveFormMap().containsKey("kingdomkeys:form_valor") && playerData.getDriveFormLevel("kingdomkeys:form_valor") >= 3 && playerData.getEquippedAbilityLevel("kingdomkeys:ability_high_jump") != null && playerData.getEquippedAbilityLevel("kingdomkeys:ability_high_jump")[1] > 0) {
            return true;
        }
        DriveForm form = (DriveForm)ModDriveForms.registry.get().getValue(new ResourceLocation(playerData.getActiveDriveForm()));
        return form.getBaseGrowthAbilities() || playerData.getActiveDriveForm().equals(DriveForm.NONE.toString()) && playerData.getDriveFormMap().containsKey("kingdomkeys:form_valor") && playerData.getDriveFormLevel("kingdomkeys:form_valor") >= 3 && playerData.getEquippedAbilityLevel("kingdomkeys:ability_high_jump") != null && playerData.getEquippedAbilityLevel("kingdomkeys:ability_high_jump")[1] > 0;
    }

    private static void handleHighJump(Player player, IPlayerCapabilities playerData) {
        boolean j = false;
        if (player.m_9236_().f_46443_) {
            j = Minecraft.m_91087_().f_91066_.f_92089_.m_90857_();
        }
        if (j && player.m_20184_().f_82480_ > 0.0) {
            DriveForm form = (DriveForm)ModDriveForms.registry.get().getValue(new ResourceLocation(playerData.getActiveDriveForm()));
            if (playerData.getActiveDriveForm().equals("kingdomkeys:form_valor")) {
                player.m_20256_(player.m_20184_().m_82520_(0.0, (double)DriveForm.VALOR_JUMP_BOOST[playerData.getDriveFormLevel("kingdomkeys:form_valor")], 0.0));
            } else if (playerData.getActiveDriveForm() != null) {
                int jumpLevel;
                int n = jumpLevel = playerData.getActiveDriveForm().equals(DriveForm.NONE.toString()) || form.getBaseGrowthAbilities() ? playerData.getDriveFormLevel("kingdomkeys:form_valor") - 2 : playerData.getDriveFormLevel("kingdomkeys:form_valor");
                if (jumpLevel > -1) {
                    player.m_20256_(player.m_20184_().m_82520_(0.0, (double)DriveForm.VALOR_JUMP_BOOST[jumpLevel], 0.0));
                }
            }
        }
    }
}

