/*
 * Decompiled with CFR 0.152.
 */
package online.kingdomkeys.kingdomkeys.entity.block;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.DustParticleOptions;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.Connection;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;
import online.kingdomkeys.kingdomkeys.block.GummiEditorBlock;
import online.kingdomkeys.kingdomkeys.container.GummiEditorContainer;
import online.kingdomkeys.kingdomkeys.entity.ModEntities;
import org.joml.Vector3f;

public class GummiEditorTileEntity
extends BlockEntity
implements MenuProvider {
    public static final int NUMBER_OF_SLOTS = 1;
    private LazyOptional<IItemHandler> inventory = LazyOptional.of(this::createInventory);
    private ItemStack displayStack = ItemStack.f_41583_;
    private int ticksExisted;
    public int previousTicks;
    int ticks = 0;

    public GummiEditorTileEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)ModEntities.TYPE_GUMMI_EDITOR.get(), pos, state);
    }

    private IItemHandler createInventory() {
        return new ItemStackHandler(1){

            public boolean isItemValid(int slot, @Nonnull ItemStack stack) {
                return true;
            }
        };
    }

    public AABB getRenderBoundingBox() {
        return super.getRenderBoundingBox().m_82363_(0.0, 5.0, 0.0);
    }

    public void m_142466_(CompoundTag compound) {
        super.m_142466_(compound);
        CompoundTag invCompound = compound.m_128469_("inv");
        this.inventory.ifPresent(iih -> ((INBTSerializable)iih).deserializeNBT((Tag)invCompound));
        this.displayStack = ItemStack.m_41712_((CompoundTag)compound.m_128469_("display_stack"));
    }

    protected void m_183515_(CompoundTag compound) {
        super.m_183515_(compound);
        this.inventory.ifPresent(iih -> {
            CompoundTag invCompound = (CompoundTag)((INBTSerializable)iih).serializeNBT();
            compound.m_128365_("inv", (Tag)invCompound);
        });
        compound.m_128365_("display_stack", (Tag)this.displayStack.serializeNBT());
    }

    public Component m_5446_() {
        return Component.m_237115_((String)"container.gummi_editor");
    }

    @Nullable
    public AbstractContainerMenu m_7208_(int windowID, Inventory playerInventory, Player playerEntity) {
        return new GummiEditorContainer(windowID, playerInventory, this);
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
        if (cap == ForgeCapabilities.ITEM_HANDLER) {
            return this.inventory.cast();
        }
        return super.getCapability(cap, side);
    }

    public ItemStack getDisplayStack() {
        return this.displayStack;
    }

    public void setDisplayStack(ItemStack displayStack) {
        this.displayStack = displayStack;
        this.m_6596_();
    }

    public int ticksExisted() {
        return this.ticksExisted;
    }

    @Nullable
    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket pkt) {
        this.m_142466_(pkt.m_131708_());
    }

    public CompoundTag m_5995_() {
        return this.serializeNBT();
    }

    public void handleUpdateTag(CompoundTag tag) {
        this.m_142466_(tag);
    }

    public static <T> void tick(Level level, BlockPos pos, BlockState state, T blockEntity) {
        GummiEditorTileEntity TE = (GummiEditorTileEntity)((Object)blockEntity);
        Direction facing = (Direction)state.m_61143_((Property)GummiEditorBlock.FACING);
        ++TE.ticks;
        for (int x = 0; x < 7; ++x) {
            for (int y = 0; y < 7; ++y) {
                block8: for (int z = 0; z < 7; ++z) {
                    if (x != 0 && x != 6 && z != 0 && z != 6 || y != 0 && y != 6) continue;
                    switch (facing) {
                        case NORTH: {
                            level.m_7106_((ParticleOptions)new DustParticleOptions(new Vector3f(1.0f, 1.0f, 1.0f), 1.0f), (double)pos.m_123341_() + 0.5 - 3.0 + (double)x, (double)(pos.m_123342_() + y) + 0.5, (double)pos.m_123343_() + 1.5 + (double)z, 0.0, 0.0, 0.0);
                            continue block8;
                        }
                        case SOUTH: {
                            level.m_7106_((ParticleOptions)new DustParticleOptions(new Vector3f(1.0f, 1.0f, 1.0f), 1.0f), (double)pos.m_123341_() + 0.5 - 3.0 + (double)x, (double)(pos.m_123342_() + y) + 0.5, (double)pos.m_123343_() - 0.5 - (double)z, 0.0, 0.0, 0.0);
                            continue block8;
                        }
                        case EAST: {
                            level.m_7106_((ParticleOptions)new DustParticleOptions(new Vector3f(1.0f, 1.0f, 1.0f), 1.0f), (double)pos.m_123341_() - 0.5 - 6.0 + (double)x, (double)(pos.m_123342_() + y) + 0.5, (double)pos.m_123343_() + 0.5 + 3.0 - (double)z, 0.0, 0.0, 0.0);
                            continue block8;
                        }
                        case WEST: {
                            level.m_7106_((ParticleOptions)new DustParticleOptions(new Vector3f(1.0f, 1.0f, 1.0f), 1.0f), (double)pos.m_123341_() - 0.5 + 2.0 + (double)x, (double)(pos.m_123342_() + y) + 0.5, (double)pos.m_123343_() + 0.5 + 3.0 - (double)z, 0.0, 0.0, 0.0);
                        }
                    }
                }
            }
        }
    }
}

