/*
 * Decompiled with CFR 0.152.
 */
package online.kingdomkeys.kingdomkeys.entity.block;

import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.Connection;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;
import online.kingdomkeys.kingdomkeys.container.MagicalChestContainer;
import online.kingdomkeys.kingdomkeys.entity.ModEntities;

public class MagicalChestTileEntity
extends BlockEntity
implements MenuProvider {
    public static final int NUMBER_OF_SLOTS = 36;
    private LazyOptional<IItemHandler> inventory = LazyOptional.of(this::createInventory);
    private UUID keyblade;
    private UUID owner;

    public MagicalChestTileEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)ModEntities.TYPE_MAGICAL_CHEST.get(), pos, state);
    }

    private IItemHandler createInventory() {
        return new ItemStackHandler(36);
    }

    public UUID getKeyblade() {
        return this.keyblade;
    }

    public void setKeyblade(UUID keyblade) {
        this.keyblade = keyblade;
        this.m_6596_();
    }

    public UUID getOwner() {
        return this.owner;
    }

    public void setOwner(UUID owner) {
        this.owner = owner;
        this.m_6596_();
    }

    protected void m_183515_(CompoundTag compound) {
        this.inventory.ifPresent(iih -> {
            CompoundTag invCompound = (CompoundTag)((INBTSerializable)iih).serializeNBT();
            compound.m_128365_("inv", (Tag)invCompound);
        });
        if (this.owner != null) {
            compound.m_128362_("owner", this.owner);
            if (this.keyblade != null && !this.keyblade.equals(new UUID(0L, 0L))) {
                compound.m_128362_("keyblade", this.keyblade);
            }
        }
    }

    public void m_142466_(CompoundTag compound) {
        super.m_142466_(compound);
        CompoundTag invCompound = compound.m_128469_("inv");
        this.inventory.ifPresent(iih -> ((INBTSerializable)iih).deserializeNBT((Tag)invCompound));
        if (compound.m_128403_("owner")) {
            this.owner = compound.m_128342_("owner");
        }
        if (compound.m_128403_("keyblade")) {
            this.keyblade = compound.m_128342_("keyblade");
        }
    }

    @Nullable
    public Packet<ClientGamePacketListener> m_58483_() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    public CompoundTag m_5995_() {
        CompoundTag tag = super.m_5995_();
        this.m_183515_(tag);
        return tag;
    }

    public void handleUpdateTag(CompoundTag tag) {
        if (tag != null) {
            this.m_142466_(tag);
        }
    }

    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket pkt) {
        this.m_142466_(pkt.m_131708_());
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
        if (cap == ForgeCapabilities.ITEM_HANDLER) {
            return this.inventory.cast();
        }
        return super.getCapability(cap, side);
    }

    public Component m_5446_() {
        return Component.m_237115_((String)"container.magical_chest");
    }

    @Nullable
    public AbstractContainerMenu m_7208_(int windowId, Inventory playerInventory, Player playerEntity) {
        return new MagicalChestContainer(windowId, playerInventory, this);
    }
}

