/*
 * Decompiled with CFR 0.152.
 */
package online.kingdomkeys.kingdomkeys.entity.block;

import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.DustParticleOptions;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.Connection;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import online.kingdomkeys.kingdomkeys.block.SavePointBlock;
import online.kingdomkeys.kingdomkeys.entity.ModEntities;
import online.kingdomkeys.kingdomkeys.world.SavePointStorage;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3f;

public class SavepointTileEntity
extends BlockEntity {
    public static float[] WARP_COLOR = new float[]{0.6f, 1.0f, 1.0f};
    public static float[] SAVEPOINT_COLOR = new float[]{0.3f, 1.0f, 0.3f};
    long ticks;
    private UUID id = UUID.randomUUID();
    private int heal = 20;
    private int hunger = 20;
    private int magic = 20;
    private int drive = 20;
    private int focus = 20;

    public SavepointTileEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)ModEntities.TYPE_SAVEPOINT.get(), pos, state);
    }

    public UUID getID() {
        return this.id;
    }

    public int getHeal() {
        return this.heal;
    }

    public void setHeal(int heal) {
        this.heal = heal;
        this.m_6596_();
    }

    public int getHunger() {
        return this.hunger;
    }

    public void setHunger(int hunger) {
        this.hunger = hunger;
        this.m_6596_();
    }

    public int getMagic() {
        return this.magic;
    }

    public void setMagic(int magic) {
        this.magic = magic;
        this.m_6596_();
    }

    public int getDrive() {
        return this.drive;
    }

    public void setDrive(int drive) {
        this.drive = drive;
        this.m_6596_();
    }

    public int getFocus() {
        return this.focus;
    }

    public void setFocus(int focus) {
        this.focus = focus;
        this.m_6596_();
    }

    public void m_142466_(CompoundTag pTag) {
        super.m_142466_(pTag);
        if (this.m_58900_().m_61143_(SavePointBlock.TIER) != SavePointStorage.SavePointType.NORMAL) {
            this.id = pTag.m_128342_("savepoint_id");
        }
        this.heal = pTag.m_128451_("heal");
        this.hunger = pTag.m_128451_("hunger");
        this.magic = pTag.m_128451_("magic");
        this.drive = pTag.m_128451_("drive");
        this.focus = pTag.m_128451_("focus");
    }

    protected void m_183515_(CompoundTag pTag) {
        if (this.m_58900_().m_61143_(SavePointBlock.TIER) != SavePointStorage.SavePointType.NORMAL) {
            pTag.m_128362_("savepoint_id", this.id);
        }
        pTag.m_128405_("heal", this.heal);
        pTag.m_128405_("hunger", this.hunger);
        pTag.m_128405_("magic", this.magic);
        pTag.m_128405_("drive", this.drive);
        pTag.m_128405_("focus", this.focus);
        super.m_183515_(pTag);
    }

    public CompoundTag m_5995_() {
        return this.serializeNBT();
    }

    public void handleUpdateTag(CompoundTag tag) {
        this.m_142466_(tag);
    }

    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket pkt) {
        this.m_142466_(pkt.m_131708_());
    }

    @Nullable
    public Packet<ClientGamePacketListener> m_58483_() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    public static <T> void tick(Level level, BlockPos pos, BlockState state, T blockEntity) {
        if (blockEntity instanceof SavepointTileEntity) {
            SavepointTileEntity savepoint = (SavepointTileEntity)((Object)blockEntity);
            if (savepoint.ticks > 1800L) {
                savepoint.ticks = 0L;
            }
            double r = 0.7;
            double cx = (double)pos.m_123341_() + 0.5;
            double cy = (double)pos.m_123342_() + 0.5;
            double cz = (double)pos.m_123343_() + 0.5;
            savepoint.ticks += 10L;
            double x = cx + r * Math.cos(Math.toRadians(savepoint.ticks));
            double z = cz + r * Math.sin(Math.toRadians(savepoint.ticks));
            double x2 = cx + r * Math.cos(Math.toRadians(-savepoint.ticks));
            double z2 = cz + r * Math.sin(Math.toRadians(-savepoint.ticks));
            float[] color = state.m_61143_(SavePointBlock.TIER) == SavePointStorage.SavePointType.WARP ? WARP_COLOR : SAVEPOINT_COLOR;
            level.m_7106_((ParticleOptions)new DustParticleOptions(new Vector3f(color[0], color[1], color[2]), 1.0f), x, cy - 0.5 - (double)((float)(-savepoint.ticks) / 1800.0f), z, 0.0, 0.0, 0.0);
            level.m_7106_((ParticleOptions)new DustParticleOptions(new Vector3f(color[0], color[1], color[2]), 1.0f), x2, cy + 0.5 - (double)((float)savepoint.ticks / 1800.0f), z2, 0.0, 0.0, 0.0);
        }
    }
}

