/*
 * Decompiled with CFR 0.152.
 */
package online.kingdomkeys.kingdomkeys.entity.magic;

import java.util.List;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.ThrowableProjectile;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.HitResult;
import net.minecraftforge.network.NetworkHooks;
import net.minecraftforge.network.PlayMessages;
import online.kingdomkeys.kingdomkeys.capability.IWorldCapabilities;
import online.kingdomkeys.kingdomkeys.capability.ModCapabilities;
import online.kingdomkeys.kingdomkeys.effects.ModMobEffects;
import online.kingdomkeys.kingdomkeys.entity.ModEntities;
import online.kingdomkeys.kingdomkeys.lib.DamageCalculation;
import online.kingdomkeys.kingdomkeys.network.PacketHandler;
import online.kingdomkeys.kingdomkeys.network.stc.SCRecalculateEyeHeight;
import online.kingdomkeys.kingdomkeys.util.Utils;

public class GraviraEntity
extends ThrowableProjectile {
    int maxTicks = 100;
    float dmgMult = 1.0f;

    public GraviraEntity(EntityType<? extends ThrowableProjectile> type, Level world) {
        super(type, world);
        this.f_19850_ = true;
    }

    public GraviraEntity(PlayMessages.SpawnEntity spawnEntity, Level world) {
        super((EntityType)ModEntities.TYPE_GRAVIRA.get(), world);
    }

    public GraviraEntity(Level world, Player player, float dmgMult) {
        super((EntityType)ModEntities.TYPE_GRAVIRA.get(), (LivingEntity)player, world);
        this.dmgMult = dmgMult;
    }

    public Packet<ClientGamePacketListener> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    protected float m_7139_() {
        return 0.0f;
    }

    public void m_8119_() {
        if (this.f_19797_ > this.maxTicks) {
            this.m_142687_(Entity.RemovalReason.KILLED);
        }
        if (this.f_19797_ > 2) {
            this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123799_, this.m_20185_(), this.m_20186_(), this.m_20189_(), 0.0, 0.0, 0.0);
        }
        super.m_8119_();
    }

    protected void m_6532_(HitResult rtRes) {
        if (!this.m_9236_().f_46443_) {
            float radius = 2.5f;
            double X = this.m_20185_();
            double Y = this.m_20186_();
            double Z = this.m_20189_();
            for (int t = 1; t < 360; t += 20) {
                for (int s = 1; s < 360; s += 20) {
                    double x = X + (double)radius * Math.cos(Math.toRadians(s)) * Math.sin(Math.toRadians(t));
                    double z = Z + (double)radius * Math.sin(Math.toRadians(s)) * Math.sin(Math.toRadians(t));
                    double y = Y + (double)radius * Math.cos(Math.toRadians(t));
                    ((ServerLevel)this.m_9236_()).m_8767_((ParticleOptions)ParticleTypes.f_123799_, x, y + 1.0, z, 1, 0.0, 0.0, 0.0, 0.0);
                }
            }
            IWorldCapabilities worldData = ModCapabilities.getWorld(this.m_9236_());
            if (!this.m_9236_().f_46443_ && this.m_19749_() != null && worldData != null) {
                List oList = this.m_9236_().m_45933_(this.m_19749_(), this.m_20191_().m_82400_((double)radius));
                List<Entity> list = Utils.removePartyMembersFromList((Player)this.m_19749_(), oList);
                if (!list.isEmpty()) {
                    for (Entity e : list) {
                        if (!(e instanceof LivingEntity)) continue;
                        ((LivingEntity)e).m_7292_(new MobEffectInstance((MobEffect)ModMobEffects.GRAVITY.get(), 100, 1, false, false, false));
                        if (Utils.isHostile(e)) {
                            float dmg = this.m_19749_() instanceof Player ? ((LivingEntity)e).m_21233_() * DamageCalculation.getMagicDamage((Player)this.m_19749_()) / 100.0f : 2.0f;
                            dmg = Math.min(dmg, 99.0f);
                            e.m_6469_(e.m_269291_().m_269390_((Entity)this, this.m_19749_()), dmg * this.dmgMult);
                        }
                        if (!(e instanceof ServerPlayer)) continue;
                        PacketHandler.sendTo(new SCRecalculateEyeHeight(), (ServerPlayer)e);
                    }
                }
                this.m_142687_(Entity.RemovalReason.KILLED);
            }
        }
    }

    public int getMaxTicks() {
        return this.maxTicks;
    }

    public void setMaxTicks(int maxTicks) {
        this.maxTicks = maxTicks;
    }

    public void m_7380_(CompoundTag compound) {
    }

    public void m_7378_(CompoundTag compound) {
    }

    protected void m_8097_() {
    }
}

