/*
 * Decompiled with CFR 0.152.
 */
package online.kingdomkeys.kingdomkeys.entity.mob;

import java.util.Random;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraftforge.network.PlayMessages;
import online.kingdomkeys.kingdomkeys.entity.EntityHelper;
import online.kingdomkeys.kingdomkeys.entity.ModEntities;
import online.kingdomkeys.kingdomkeys.entity.mob.BaseKHEntity;

public class DarkballEntity
extends BaseKHEntity {
    private SpecialAttack currentAttack;
    private SpecialAttack previousAttack;

    public DarkballEntity(EntityType<? extends Monster> type, Level worldIn) {
        super(type, worldIn);
        this.f_21364_ = 8;
    }

    public DarkballEntity(PlayMessages.SpawnEntity spawnEntity, Level world) {
        this((EntityType<? extends Monster>)((EntityType)ModEntities.TYPE_DARKBALL.get()), world);
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(0, (Goal)new MeleeAttackGoal((PathfinderMob)this, 1.0, false));
        this.f_21345_.m_25352_(0, (Goal)new DarkCloudGoal(this));
        this.f_21345_.m_25352_(1, (Goal)new ChargeGoal(this));
        this.f_21345_.m_25352_(1, (Goal)new BerserkGoal(this));
        this.f_21345_.m_25352_(1, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(3, (Goal)new RandomStrollGoal((PathfinderMob)this, 1.0));
        this.f_21345_.m_25352_(4, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21346_.m_25352_(0, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.f_21346_.m_25352_(1, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true));
        this.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Villager.class, true));
    }

    public static AttributeSupplier.Builder registerAttributes() {
        return Mob.m_21183_().m_22268_(Attributes.f_22277_, 35.0).m_22268_(Attributes.f_22279_, 0.22).m_22268_(Attributes.f_22276_, 70.0).m_22268_(Attributes.f_22281_, 1.0).m_22268_(Attributes.f_22282_, 1.0);
    }

    public int m_5792_() {
        return 4;
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(EntityHelper.STATE, (Object)0);
    }

    @Override
    public EntityHelper.MobType getKHMobType() {
        return EntityHelper.MobType.HEARTLESS_PUREBLOOD;
    }

    public boolean m_6090_() {
        return true;
    }

    public boolean m_142535_(float pFallDistance, float pMultiplier, DamageSource pSource) {
        return false;
    }

    protected void m_8024_() {
        this.m_20331_(false);
        super.m_8024_();
    }

    public void setCurrentAttackState(SpecialAttack state) {
        this.currentAttack = state;
    }

    public SpecialAttack getCurrentAttackState() {
        return this.currentAttack;
    }

    public void setPreviousAttackState(SpecialAttack state) {
        this.previousAttack = state;
    }

    public SpecialAttack getPreviousAttackState() {
        return this.previousAttack;
    }

    class DarkCloudGoal
    extends Goal {
        private DarkballEntity theEntity;
        private boolean canUseAttack = true;
        private int attackTimer = 50;
        private int whileAttackTimer;
        private double[] pivotPosToMove;

        public DarkCloudGoal(DarkballEntity e) {
            this.theEntity = e;
        }

        public boolean m_8036_() {
            if (this.theEntity.m_5448_() != null && this.theEntity.getCurrentAttackState() == null) {
                if (!this.canUseAttack) {
                    if (this.attackTimer > 0) {
                        this.attackTimer -= 2;
                        return false;
                    }
                    return this.prevAttackCalc();
                }
                return this.prevAttackCalc();
            }
            return false;
        }

        public boolean prevAttackCalc() {
            if (this.theEntity.getPreviousAttackState() == SpecialAttack.DARKCLOUD) {
                return this.theEntity.f_19796_.m_188501_() <= 0.3f;
            }
            return true;
        }

        public boolean m_8045_() {
            boolean flag = this.canUseAttack;
            if (!flag) {
                this.theEntity.setPreviousAttackState(this.theEntity.getCurrentAttackState());
                this.theEntity.setCurrentAttackState(null);
                EntityHelper.setState((Entity)this.theEntity, 0);
                for (Entity entity : EntityHelper.getEntitiesNear((Entity)this.theEntity, 1.4)) {
                    this.theEntity.m_7327_(entity);
                }
            }
            return flag;
        }

        public void m_8056_() {
            this.canUseAttack = true;
            this.attackTimer = 50;
            this.whileAttackTimer = 0;
            this.theEntity.setCurrentAttackState(SpecialAttack.DARKCLOUD);
            EntityHelper.setState((Entity)this.theEntity, 0);
        }

        public void m_8037_() {
            if (this.theEntity.m_5448_() != null && this.canUseAttack) {
                this.whileAttackTimer += 2;
                EntityHelper.setState((Entity)this.theEntity, 3);
                LivingEntity target = this.theEntity.m_5448_();
                for (int i = 0; i < 20; ++i) {
                    double d = (double)new Random().nextInt(5) + 1.0 + 5.0 - 5.0;
                    double offsetY = (double)new Random().nextInt(5) + 1.0 + 5.0 - 5.0;
                    double offsetZ = (double)new Random().nextInt(5) + 1.0 + 5.0 - 5.0;
                    this.theEntity.m_21573_().m_26519_((double)target.m_20183_().m_123341_(), (double)target.m_20183_().m_123342_(), (double)target.m_20183_().m_123343_(), 1.5);
                }
                for (Entity entity : EntityHelper.getEntitiesNear((Entity)this.theEntity, 1.0)) {
                    if (entity != target) continue;
                    this.canUseAttack = false;
                }
                if (this.whileAttackTimer > 80) {
                    this.canUseAttack = false;
                }
            }
        }
    }

    class ChargeGoal
    extends Goal {
        private DarkballEntity theEntity;
        private boolean canUseAttack = true;
        private int attackTimer = 50;
        private int whileAttackTimer;
        private double[] posToCharge;
        private float initialHealth;

        public ChargeGoal(DarkballEntity e) {
            this.theEntity = e;
        }

        public boolean m_8036_() {
            if (this.theEntity.m_5448_() != null && this.theEntity.getCurrentAttackState() == null && this.theEntity.m_20280_((Entity)this.theEntity.m_5448_()) > 4.0) {
                if (!this.canUseAttack) {
                    if (this.attackTimer > 0) {
                        this.attackTimer -= 2;
                        return false;
                    }
                    return this.prevAttackCalc();
                }
                return this.prevAttackCalc();
            }
            return false;
        }

        public boolean prevAttackCalc() {
            if (this.theEntity.getPreviousAttackState() == SpecialAttack.CHARGE) {
                return this.theEntity.f_19796_.m_188501_() <= 0.1f;
            }
            return true;
        }

        public boolean m_8045_() {
            boolean flag = this.canUseAttack;
            if (!flag) {
                this.theEntity.setPreviousAttackState(this.theEntity.getCurrentAttackState());
                this.theEntity.setCurrentAttackState(null);
                EntityHelper.setState((Entity)this.theEntity, 0);
            }
            return flag;
        }

        public void m_8056_() {
            this.canUseAttack = true;
            this.attackTimer = 50;
            this.whileAttackTimer = 0;
            this.theEntity.setCurrentAttackState(SpecialAttack.CHARGE);
            EntityHelper.setState((Entity)this.theEntity, 0);
            LivingEntity target = this.theEntity.m_5448_();
            this.initialHealth = this.theEntity.m_21223_();
            if (target != null) {
                this.posToCharge = new double[]{target.m_20185_(), target.m_20186_(), target.m_20189_()};
            }
        }

        public void m_8037_() {
            if (this.theEntity.m_5448_() != null && this.canUseAttack) {
                this.whileAttackTimer += 2;
                EntityHelper.setState((Entity)this.theEntity, 1);
                LivingEntity target = this.theEntity.m_5448_();
                this.theEntity.m_21573_().m_26519_(this.posToCharge[0], this.posToCharge[1], this.posToCharge[2], 3.0);
                if (this.whileAttackTimer > 100) {
                    this.canUseAttack = false;
                }
                if (this.theEntity.m_20183_().m_123341_() == (int)this.posToCharge[0] && this.theEntity.m_20183_().m_123342_() == (int)this.posToCharge[1] && this.theEntity.m_20183_().m_123343_() == (int)this.posToCharge[2]) {
                    this.canUseAttack = false;
                }
                if (this.theEntity.m_20280_((Entity)this.theEntity.m_5448_()) < 3.0) {
                    this.canUseAttack = false;
                }
                if (this.initialHealth > this.theEntity.m_21223_()) {
                    this.canUseAttack = false;
                }
            }
        }
    }

    class BerserkGoal
    extends Goal {
        private DarkballEntity theEntity;
        private boolean canUseAttack = true;
        private int attackTimer = 70;
        private int whileAttackTimer;
        private double[] pivotPosToBerserk;

        public BerserkGoal(DarkballEntity e) {
            this.theEntity = e;
        }

        public boolean m_8036_() {
            if (this.theEntity.m_5448_() != null && this.theEntity.getCurrentAttackState() == null && this.theEntity.m_20280_((Entity)this.theEntity.m_5448_()) < 15.0) {
                if (!this.canUseAttack) {
                    if (this.attackTimer > 0) {
                        this.attackTimer -= 2;
                        return false;
                    }
                    return this.prevAttackCalc();
                }
                return this.prevAttackCalc();
            }
            return false;
        }

        public boolean prevAttackCalc() {
            if (this.theEntity.getPreviousAttackState() == SpecialAttack.BERSERK) {
                return this.theEntity.f_19796_.m_188501_() <= 0.5f;
            }
            return true;
        }

        public boolean m_8045_() {
            boolean flag = this.canUseAttack;
            if (!flag) {
                this.theEntity.setPreviousAttackState(this.theEntity.getCurrentAttackState());
                this.theEntity.setCurrentAttackState(null);
                EntityHelper.setState((Entity)this.theEntity, 0);
            }
            return flag;
        }

        public void m_8056_() {
            this.canUseAttack = true;
            this.attackTimer = 70;
            this.whileAttackTimer = 0;
            this.theEntity.setCurrentAttackState(SpecialAttack.BERSERK);
            EntityHelper.setState((Entity)this.theEntity, 0);
            this.pivotPosToBerserk = new double[]{this.theEntity.m_20183_().m_123341_(), this.theEntity.m_20183_().m_123342_(), this.theEntity.m_20183_().m_123343_()};
        }

        public void m_8037_() {
            if (this.theEntity.m_5448_() != null && this.canUseAttack) {
                this.whileAttackTimer += 2;
                EntityHelper.setState((Entity)this.theEntity, 2);
                for (int i = 0; i < 20; ++i) {
                    double offsetX = (double)new Random().nextInt(5) + 1.0 + 5.0 - 5.0;
                    double offsetY = (double)new Random().nextInt(5) + 1.0 + 5.0 - 5.0;
                    double offsetZ = (double)new Random().nextInt(5) + 1.0 + 5.0 - 5.0;
                    LivingEntity target = this.theEntity.m_5448_();
                    this.theEntity.m_21573_().m_26519_(this.pivotPosToBerserk[0] + offsetX, this.pivotPosToBerserk[1] + offsetY, this.pivotPosToBerserk[2] + offsetZ, 5.0);
                }
                if (this.whileAttackTimer > 40) {
                    this.canUseAttack = false;
                }
            }
        }
    }

    static enum SpecialAttack {
        CHARGE,
        BERSERK,
        DARKCLOUD;

    }
}

