/*
 * Decompiled with CFR 0.152.
 */
package online.kingdomkeys.kingdomkeys.entity.mob.goal;

import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.target.TargetGoal;
import online.kingdomkeys.kingdomkeys.client.sound.ModSounds;
import online.kingdomkeys.kingdomkeys.entity.EntityHelper;

public class DragoonGoal
extends TargetGoal {
    private final int MAX_BALL_TICKS = 60;
    private int ballTicks = 0;
    private final int MAX_FALL_TICKS = 20;
    private int fallTicks = 0;
    private int ticksToChooseAI = 20;

    public DragoonGoal(PathfinderMob creature) {
        super((Mob)creature, true);
    }

    public boolean m_8045_() {
        if (this.f_26135_.m_5448_() != null) {
            if (this.ticksToChooseAI <= 0 && EntityHelper.getState((Entity)this.f_26135_) == 0) {
                if ((double)this.f_26135_.m_9236_().f_46441_.m_188503_(100) + this.f_26135_.m_9236_().f_46441_.m_188500_() <= 40.0) {
                    this.setBall(this.f_26135_);
                    this.ticksToChooseAI = 120;
                } else {
                    this.doJump(this.f_26135_);
                    this.ticksToChooseAI = 80;
                }
            } else if (EntityHelper.getState((Entity)this.f_26135_) == 0) {
                this.ticksToChooseAI -= 2;
            }
            if (this.isBall()) {
                this.ballAI();
            }
            if (this.isFalling()) {
                this.fallingAI();
            }
            return true;
        }
        this.setDefault(this.f_26135_);
        return false;
    }

    private void doJump(Mob mob) {
        this.f_26135_.m_20256_(mob.m_20184_().m_82520_(0.0, 0.8, 0.0));
        EntityHelper.Dir dir = EntityHelper.get8Directions((Entity)this.f_26135_);
        float jumpSpeed = 1.0f;
        switch (dir) {
            case NORTH: {
                mob.m_20256_(mob.m_20184_().m_82520_(0.0, 0.0, (double)(-jumpSpeed)));
                break;
            }
            case NORTH_WEST: {
                mob.m_20256_(mob.m_20184_().m_82520_((double)(-jumpSpeed), 0.0, (double)(-jumpSpeed)));
                break;
            }
            case SOUTH: {
                mob.m_20256_(mob.m_20184_().m_82520_(0.0, 0.0, (double)jumpSpeed));
                break;
            }
            case NORTH_EAST: {
                mob.m_20256_(mob.m_20184_().m_82520_((double)jumpSpeed, 0.0, (double)(-jumpSpeed)));
                break;
            }
            case WEST: {
                mob.m_20256_(mob.m_20184_().m_82520_((double)(-jumpSpeed), 0.0, 0.0));
                break;
            }
            case SOUTH_WEST: {
                mob.m_20256_(mob.m_20184_().m_82520_((double)(-jumpSpeed), 0.0, (double)jumpSpeed));
                break;
            }
            case EAST: {
                mob.m_20256_(mob.m_20184_().m_82520_((double)jumpSpeed, 0.0, 0.0));
                break;
            }
            case SOUTH_EAST: {
                mob.m_20256_(mob.m_20184_().m_82520_((double)jumpSpeed, 0.0, (double)jumpSpeed));
            }
        }
    }

    private void ballAI() {
        this.ballTicks += 2;
        if (this.ballTicks >= 60) {
            this.setFall(this.f_26135_);
            this.ballTicks = 0;
        }
    }

    private void fallingAI() {
        this.fallTicks += 2;
        for (LivingEntity enemy : EntityHelper.getEntitiesNear((Entity)this.f_26135_, 3.0)) {
            this.f_26135_.m_7327_((Entity)enemy);
        }
        if (this.fallTicks >= 20) {
            this.fallTicks = 0;
            this.setDefault(this.f_26135_);
        }
    }

    public void setFall(Mob mob) {
        this.fallTicks = 0;
        EntityHelper.setState((Entity)mob, 2);
        mob.m_9236_().m_5594_(null, mob.m_20183_(), (SoundEvent)ModSounds.portal.get(), SoundSource.HOSTILE, 1.0f, 2.0f);
        mob.m_9236_().m_5594_(null, mob.m_5448_().m_20183_(), (SoundEvent)ModSounds.portal.get(), SoundSource.HOSTILE, 1.0f, 2.0f);
        mob.m_6021_(mob.m_5448_().m_20185_(), mob.m_5448_().m_20186_() + 5.0, mob.m_5448_().m_20189_());
        mob.m_21051_(Attributes.f_22279_).m_22100_(0.0);
    }

    public void setBall(Mob mob) {
        this.ballTicks = 0;
        EntityHelper.setState((Entity)mob, 1);
        mob.m_21051_(Attributes.f_22279_).m_22100_(0.0);
    }

    public void setDefault(Mob mob) {
        EntityHelper.setState((Entity)mob, 0);
        mob.m_21051_(Attributes.f_22279_).m_22100_(0.27);
    }

    public void m_8056_() {
        EntityHelper.setState((Entity)this.f_26135_, 0);
    }

    private boolean isBall() {
        return EntityHelper.getState((Entity)this.f_26135_) == 1;
    }

    private boolean isFalling() {
        return EntityHelper.getState((Entity)this.f_26135_) == 2;
    }

    public boolean m_8036_() {
        return this.f_26135_.m_5448_() != null;
    }
}

