/*
 * Decompiled with CFR 0.152.
 */
package online.kingdomkeys.kingdomkeys.entity.organization;

import java.util.Optional;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LightningBolt;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.ThrowableProjectile;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.network.NetworkHooks;
import net.minecraftforge.network.PlayMessages;
import online.kingdomkeys.kingdomkeys.entity.ModEntities;
import online.kingdomkeys.kingdomkeys.entity.magic.ThunderBoltEntity;

public class ThunderTrailCoreEntity
extends ThrowableProjectile {
    int maxTicks = 240;
    float dmg;
    BlockPos ogPos;
    private static final EntityDataAccessor<Optional<UUID>> OWNER = SynchedEntityData.m_135353_(ThunderTrailCoreEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135041_);
    private static final EntityDataAccessor<Optional<UUID>> TARGET = SynchedEntityData.m_135353_(ThunderTrailCoreEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135041_);
    private static final EntityDataAccessor<BlockPos> OGPOS = SynchedEntityData.m_135353_(ThunderTrailCoreEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135038_);

    public ThunderTrailCoreEntity(EntityType<? extends ThrowableProjectile> type, Level world) {
        super(type, world);
        this.f_19850_ = true;
    }

    public ThunderTrailCoreEntity(PlayMessages.SpawnEntity spawnEntity, Level world) {
        super((EntityType)ModEntities.TYPE_THUNDER_TRAIL.get(), world);
    }

    public ThunderTrailCoreEntity(Level world, Player player, LivingEntity target, float dmg) {
        super((EntityType)ModEntities.TYPE_THUNDER_TRAIL.get(), (LivingEntity)player, world);
        this.setCaster(player.m_20148_());
        this.setTarget(target.m_20148_());
        this.dmg = dmg;
        this.setOgPos(player.m_20183_());
    }

    public Packet<ClientGamePacketListener> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    protected float m_7139_() {
        return 0.0f;
    }

    public void m_8119_() {
        if (this.getOgPos() == null) {
            return;
        }
        if (this.f_19797_ > this.maxTicks || this.getCaster() == null || this.m_20275_(this.getOgPos().m_123341_(), this.getOgPos().m_123342_(), this.getOgPos().m_123343_()) > 900.0) {
            this.m_142687_(Entity.RemovalReason.KILLED);
        }
        if (this.getCaster() != null && this.f_19797_ % 3 == 0) {
            ThunderBoltEntity shot = new ThunderBoltEntity(this.getCaster().m_9236_(), this.getCaster(), this.m_20185_(), this.m_20186_() - 1.0, this.m_20189_(), this.dmg);
            shot.setCaster(this.getCaster().m_20148_());
            this.m_9236_().m_7967_((Entity)shot);
            LightningBolt lightningBoltEntity = (LightningBolt)EntityType.f_20465_.m_20615_(this.m_9236_());
            lightningBoltEntity.m_20874_(true);
            lightningBoltEntity.m_20219_(Vec3.m_82539_((Vec3i)this.m_20183_().m_7495_()));
            lightningBoltEntity.m_20879_(this.getCaster() instanceof ServerPlayer ? (ServerPlayer)this.getCaster() : null);
            this.m_9236_().m_7967_((Entity)lightningBoltEntity);
        }
        super.m_8119_();
    }

    protected void m_6532_(HitResult rtRes) {
    }

    public int getMaxTicks() {
        return this.maxTicks;
    }

    public void setMaxTicks(int maxTicks) {
        this.maxTicks = maxTicks;
    }

    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        if (this.f_19804_.m_135370_(OWNER) != null) {
            compound.m_128359_("OwnerUUID", ((UUID)((Optional)this.f_19804_.m_135370_(OWNER)).get()).toString());
            compound.m_128359_("TargetUUID", ((UUID)((Optional)this.f_19804_.m_135370_(TARGET)).get()).toString());
            int[] intArray = new int[]{((BlockPos)this.f_19804_.m_135370_(OGPOS)).m_123341_(), ((BlockPos)this.f_19804_.m_135370_(OGPOS)).m_123342_(), ((BlockPos)this.f_19804_.m_135370_(OGPOS)).m_123343_()};
            compound.m_128385_("OgPos", intArray);
        }
    }

    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        this.f_19804_.m_135381_(OWNER, Optional.of(UUID.fromString(compound.m_128461_("OwnerUUID"))));
        this.f_19804_.m_135381_(TARGET, Optional.of(UUID.fromString(compound.m_128461_("TargetUUID"))));
        int[] coords = compound.m_128465_("OgPos");
        BlockPos blockpos = new BlockPos(coords[0], coords[1], coords[2]);
        this.f_19804_.m_135381_(OGPOS, (Object)blockpos);
    }

    public Player getCaster() {
        return ((Optional)this.m_20088_().m_135370_(OWNER)).isPresent() ? this.m_9236_().m_46003_((UUID)((Optional)this.m_20088_().m_135370_(OWNER)).get()) : null;
    }

    public void setCaster(UUID uuid) {
        this.f_19804_.m_135381_(OWNER, Optional.of(uuid));
    }

    public BlockPos getOgPos() {
        return (BlockPos)this.m_20088_().m_135370_(OGPOS);
    }

    public void setOgPos(BlockPos blockpos) {
        this.f_19804_.m_135381_(OGPOS, (Object)blockpos);
    }

    public Player getTarget() {
        return ((Optional)this.m_20088_().m_135370_(TARGET)).isPresent() ? this.m_9236_().m_46003_((UUID)((Optional)this.m_20088_().m_135370_(TARGET)).get()) : null;
    }

    public void setTarget(UUID uuid) {
        this.f_19804_.m_135381_(TARGET, Optional.of(uuid));
    }

    protected void m_8097_() {
        this.f_19804_.m_135372_(OWNER, Optional.of(new UUID(0L, 0L)));
        this.f_19804_.m_135372_(TARGET, Optional.of(new UUID(0L, 0L)));
        this.f_19804_.m_135372_(OGPOS, (Object)new BlockPos(0, 0, 0));
    }
}

