/*
 * Decompiled with CFR 0.152.
 */
package online.kingdomkeys.kingdomkeys.integration.jei;

import com.mojang.blaze3d.platform.InputConstants;
import java.util.List;
import java.util.Map;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.builder.IRecipeSlotBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.registries.ForgeRegistries;
import online.kingdomkeys.kingdomkeys.block.ModBlocks;
import online.kingdomkeys.kingdomkeys.capability.ModCapabilities;
import online.kingdomkeys.kingdomkeys.integration.jei.TextDrawable;
import online.kingdomkeys.kingdomkeys.synthesis.recipe.Recipe;
import online.kingdomkeys.kingdomkeys.util.Utils;

public class SynthesisRecipeCategory
implements IRecipeCategory<Recipe> {
    IDrawable icon;
    IDrawable background;
    IDrawable munny;
    public static final RecipeType<Recipe> TYPE = RecipeType.create((String)"kingdomkeys", (String)"synthesis", Recipe.class);

    public SynthesisRecipeCategory(IGuiHelper guiHelper) {
        this.icon = guiHelper.createDrawableIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)new ItemStack((ItemLike)ModBlocks.moogleProjector.get()));
        this.background = guiHelper.drawableBuilder(new ResourceLocation("kingdomkeys", "textures/gui/synthesis_recipe_background.png"), 0, 0, 170, 86).build();
        this.munny = guiHelper.drawableBuilder(new ResourceLocation("kingdomkeys", "textures/entity/munny.png"), 0, 0, 16, 16).setTextureSize(16, 16).build();
    }

    public List<Component> getTooltipStrings(Recipe recipe, IRecipeSlotsView recipeSlotsView, double mouseX, double mouseY) {
        return super.getTooltipStrings((Object)recipe, recipeSlotsView, mouseX, mouseY);
    }

    public boolean handleInput(Recipe recipe, double mouseX, double mouseY, InputConstants.Key input) {
        return super.handleInput((Object)recipe, mouseX, mouseY, input);
    }

    public void draw(Recipe recipe, IRecipeSlotsView recipeSlotsView, GuiGraphics guiGraphics, double mouseX, double mouseY) {
        if (recipe.getCost() > 0) {
            this.munny.draw(guiGraphics, 5, 57);
            new TextDrawable((Component)Component.m_237115_((String)String.valueOf(recipe.getCost())), 0xFFFF55).draw(guiGraphics, 5, 57);
        }
        new TextDrawable((Component)Component.m_237115_((String)(Utils.translateToLocal("gui.shop.tier", new Object[0]) + " " + Utils.getTierFromInt(recipe.getTier()))), 0xFFFF55).draw(guiGraphics, 70, 57);
        Minecraft.m_91087_().f_91074_.getCapability(ModCapabilities.PLAYER_CAPABILITIES).ifPresent(cap -> {
            if (cap.hasKnownRecipe(recipe.getRegistryName())) {
                new TextDrawable((Component)Component.m_237115_((String)"jei.category.kingdomkeys.synthesis.unlocked"), 0x55FF55).draw(guiGraphics, 5, 72);
            } else {
                new TextDrawable((Component)Component.m_237115_((String)"jei.category.kingdomkeys.synthesis.locked"), 0xFF5555).draw(guiGraphics, 5, 72);
            }
        });
    }

    public Component getTitle() {
        return Component.m_237115_((String)"jei.category.kingdomkeys.synthesis");
    }

    public IDrawable getBackground() {
        return this.background;
    }

    public IDrawable getIcon() {
        return this.icon;
    }

    public void setRecipe(IRecipeLayoutBuilder builder, Recipe recipe, IFocusGroup focuses) {
        ((IRecipeSlotBuilder)builder.addSlot(RecipeIngredientRole.OUTPUT, 145, 62).addItemStack(new ItemStack((ItemLike)recipe.getResult()))).setSlotName("result");
        int startX = 5;
        int startY = 4;
        int currentX = startX;
        int currentY = startY;
        for (Map.Entry<Item, Integer> ingredient : recipe.getMaterials().entrySet()) {
            TextDrawable quantityOverlay = new TextDrawable((Component)Component.m_237115_((String)ingredient.getValue().toString()));
            ((IRecipeSlotBuilder)builder.addSlot(RecipeIngredientRole.INPUT, currentX, currentY).addItemStack(new ItemStack((ItemLike)ingredient.getKey()))).setSlotName(ForgeRegistries.ITEMS.getKey((Object)ingredient.getKey()).toString()).setOverlay((IDrawable)quantityOverlay, 16 - quantityOverlay.getWidth(), 16 - quantityOverlay.getHeight());
            if ((currentX += 16) <= 164) continue;
            currentY += 16;
            currentX = startX;
        }
    }

    public RecipeType<Recipe> getRecipeType() {
        return TYPE;
    }
}

