/*
 * Decompiled with CFR 0.152.
 */
package online.kingdomkeys.kingdomkeys.integration.jer;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import jeresources.api.IWorldGenRegistry;
import jeresources.api.conditionals.Conditional;
import jeresources.api.distributions.DistributionBase;
import jeresources.api.distributions.DistributionSquare;
import jeresources.api.distributions.DistributionTriangular;
import jeresources.api.drop.LootDrop;
import jeresources.api.restrictions.BiomeRestriction;
import jeresources.api.restrictions.DimensionRestriction;
import jeresources.api.restrictions.Restriction;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.registries.VanillaRegistries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BiomeTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.common.Tags;
import net.minecraftforge.registries.RegistryObject;
import online.kingdomkeys.kingdomkeys.block.ModBlocks;
import online.kingdomkeys.kingdomkeys.item.ModItems;

public class WorldGen {
    IWorldGenRegistry registry;
    private static Restriction overworld = new Restriction(WorldGen.createBiomeRestriction((TagKey<Biome>)BiomeTags.f_215817_), DimensionRestriction.OVERWORLD);
    private static Restriction nether = new Restriction(WorldGen.createBiomeRestriction((TagKey<Biome>)BiomeTags.f_207612_), DimensionRestriction.NETHER);
    private static Restriction end = new Restriction(WorldGen.createBiomeRestriction((TagKey<Biome>)BiomeTags.f_215818_), DimensionRestriction.END);
    private static Restriction hot = new Restriction(WorldGen.createBiomeRestriction((TagKey<Biome>)Tags.Biomes.IS_HOT_OVERWORLD), DimensionRestriction.OVERWORLD);
    private static Restriction cold = new Restriction(WorldGen.createBiomeRestriction((TagKey<Biome>)Tags.Biomes.IS_COLD_OVERWORLD), DimensionRestriction.OVERWORLD);
    private static Restriction wet = new Restriction(WorldGen.createBiomeRestriction((TagKey<Biome>)Tags.Biomes.IS_WET_OVERWORLD), DimensionRestriction.OVERWORLD);
    private static Restriction wetCold = new Restriction(WorldGen.createBiomeRestriction((TagKey<Biome>)TagKey.m_203882_((ResourceKey)Registries.f_256952_, (ResourceLocation)new ResourceLocation("forge", "wet_cold"))));
    private static OreConfig BETWIXT_ORE_CONFIG = new OreConfig(4, 7, -64, 20, overworld);
    private static OreConfig BLAZING_ORE_HOT_CONFIG = new OreConfig(4, 7, -64, 100, hot);
    private static OreConfig BLAZING_ORE_NETHER_CONFIG = new OreConfig(10, 8, 0, 100, nether);
    private static OreConfig BLOX_CLUSTER_CONFIG = new OreConfig(10, 4, 64, 64, overworld);
    private static OreConfig BLOX_CLUSTER_END_CONFIG = new OreConfig(6, 8, 0, 200, end);
    private static OreConfig FROST_ORE_COLD_CONFIG = new OreConfig(4, 7, -64, 100, cold);
    private static OreConfig HUNGRY_ORE_CONFIG = new OreConfig(4, 7, -64, 100, overworld);
    private static OreConfig LIGHTNING_ORE_CONFIG = new OreConfig(4, 7, -64, 100, overworld);
    private static OreConfig LUCID_ORE_CONFIG = new OreConfig(4, 7, -64, 100, overworld);
    private static OreConfig PRIZE_BLOX_CLUSTER_CONFIG = new OreConfig(4, 2, 64, 64, overworld);
    private static OreConfig PRIZE_BLOX_CLUSTER_END_CONFIG = new OreConfig(4, 6, 0, 200, end);
    private static OreConfig PULSING_ORE_WET_COLD_CONFIG = new OreConfig(10, 7, -64, 20, wetCold);
    private static OreConfig PULSING_ORE_END_CONFIG = new OreConfig(10, 8, 0, 200, end);
    private static OreConfig REMEMBRANCE_ORE_CONFIG = new OreConfig(4, 7, -64, 100, overworld);
    private static OreConfig SINISTER_ORE_CONFIG = new OreConfig(4, 7, -64, 20, overworld);
    private static OreConfig SOOTHING_ORE_CONFIG = new OreConfig(4, 7, -64, 100, overworld);
    private static OreConfig STORMY_ORE_CONFIG = new OreConfig(4, 7, -64, 20, overworld);
    private static OreConfig STORMY_ORE_WET_CONFIG = new OreConfig(4, 7, -64, 20, wet);
    private static OreConfig TRANQUILITY_ORE_CONFIG = new OreConfig(4, 7, -64, 100, overworld);
    private static OreConfig TWILIGHT_ORE_CONFIG = new OreConfig(4, 7, -64, 100, overworld);
    private static OreConfig TWILIGHT_ORE_NETHER_CONFIG = new OreConfig(10, 8, 0, 100, nether);
    private static OreConfig WELLSPRING_ORE_CONFIG = new OreConfig(4, 7, -64, 100, overworld);
    private static OreConfig WELLSPRING_ORE_NETHER_CONFIG = new OreConfig(10, 8, 0, 100, nether);
    private static OreConfig WRITHING_ORE_CONFIG = new OreConfig(4, 7, -64, 20, overworld);
    private static OreConfig WRITHING_ORE_END_CONFIG = new OreConfig(10, 8, 0, 200, end);
    private static OreConfig WRITHING_ORE_NETHER_CONFIG = new OreConfig(10, 8, 0, 100, nether);

    public WorldGen(IWorldGenRegistry registry) {
        this.registry = registry;
    }

    public void setup() {
        List<Block> BLOX_LIST = Arrays.asList((Block)ModBlocks.normalBlox.get(), (Block)ModBlocks.hardBlox.get(), (Block)ModBlocks.metalBlox.get(), (Block)ModBlocks.dangerBlox.get());
        List<Block> PRIZE_BLOX_LIST = Arrays.asList((Block)ModBlocks.prizeBlox.get(), (Block)ModBlocks.rarePrizeBlox.get(), (Block)ModBlocks.dangerBlox.get(), (Block)ModBlocks.blastBlox.get());
        this.registerSynthOre(ModBlocks.twilightOreN, TWILIGHT_ORE_NETHER_CONFIG, ModItems.twilight_shard, ModItems.twilight_stone, ModItems.twilight_gem, ModItems.twilight_crystal);
        this.registerSynthOre(ModBlocks.wellspringOreN, WELLSPRING_ORE_NETHER_CONFIG, ModItems.wellspring_shard, ModItems.wellspring_stone, ModItems.wellspring_gem, ModItems.wellspring_crystal);
        this.registerSynthOre(ModBlocks.writhingOreN, WRITHING_ORE_NETHER_CONFIG, ModItems.writhing_shard, ModItems.writhing_stone, ModItems.writhing_gem, ModItems.writhing_crystal);
        this.registerSynthOre(ModBlocks.blazingOreN, BLAZING_ORE_NETHER_CONFIG, ModItems.blazing_shard, ModItems.blazing_stone, ModItems.blazing_gem, ModItems.blazing_crystal);
        this.registerSynthOre(ModBlocks.writhingOreE, WRITHING_ORE_END_CONFIG, ModItems.writhing_shard, ModItems.writhing_stone, ModItems.writhing_gem, ModItems.writhing_crystal);
        this.registerSynthOre(ModBlocks.pulsingOreE, PULSING_ORE_END_CONFIG, ModItems.pulsing_shard, ModItems.pulsing_stone, ModItems.pulsing_gem, ModItems.pulsing_crystal);
        this.registerBlox(BLOX_LIST, BLOX_CLUSTER_END_CONFIG);
        this.registerBlox(PRIZE_BLOX_LIST, PRIZE_BLOX_CLUSTER_END_CONFIG);
        this.registerBlox(BLOX_LIST, BLOX_CLUSTER_CONFIG);
        this.registerBlox(PRIZE_BLOX_LIST, PRIZE_BLOX_CLUSTER_CONFIG);
        this.registerSynthOre(ModBlocks.betwixtOre, BETWIXT_ORE_CONFIG, ModItems.betwixt_shard, ModItems.betwixt_stone, ModItems.betwixt_gem, ModItems.betwixt_crystal);
        this.registerSynthOre(ModBlocks.sinisterOre, SINISTER_ORE_CONFIG, ModItems.sinister_shard, ModItems.sinister_stone, ModItems.sinister_gem, ModItems.sinister_crystal);
        this.registerSynthOre(ModBlocks.stormyOre, STORMY_ORE_CONFIG, ModItems.stormy_shard, ModItems.stormy_stone, ModItems.stormy_gem, ModItems.stormy_crystal);
        this.registerSynthOre(ModBlocks.writhingOre, WRITHING_ORE_CONFIG, ModItems.writhing_shard, ModItems.writhing_stone, ModItems.writhing_gem, ModItems.writhing_crystal);
        this.registerSynthOre(ModBlocks.hungryOre, HUNGRY_ORE_CONFIG, ModItems.hungry_shard, ModItems.hungry_stone, ModItems.hungry_gem, ModItems.hungry_crystal);
        this.registerSynthOre(ModBlocks.lightningOre, LIGHTNING_ORE_CONFIG, ModItems.lightning_shard, ModItems.lightning_stone, ModItems.lightning_gem, ModItems.lightning_crystal);
        this.registerSynthOre(ModBlocks.lucidOre, LUCID_ORE_CONFIG, ModItems.lucid_shard, ModItems.lucid_stone, ModItems.lucid_gem, ModItems.lucid_crystal);
        this.registerSynthOre(ModBlocks.remembranceOre, REMEMBRANCE_ORE_CONFIG, ModItems.remembrance_shard, ModItems.remembrance_stone, ModItems.remembrance_gem, ModItems.remembrance_crystal);
        this.registerSynthOre(ModBlocks.soothingOre, SOOTHING_ORE_CONFIG, ModItems.soothing_shard, ModItems.soothing_stone, ModItems.soothing_gem, ModItems.soothing_crystal);
        this.registerSynthOre(ModBlocks.tranquilityOre, TRANQUILITY_ORE_CONFIG, ModItems.tranquility_shard, ModItems.tranquility_stone, ModItems.tranquility_gem, ModItems.tranquility_crystal);
        this.registerSynthOre(ModBlocks.twilightOre, TWILIGHT_ORE_CONFIG, ModItems.twilight_shard, ModItems.twilight_stone, ModItems.twilight_gem, ModItems.twilight_crystal);
        this.registerSynthOre(ModBlocks.wellspringOre, WELLSPRING_ORE_CONFIG, ModItems.wellspring_shard, ModItems.wellspring_stone, ModItems.wellspring_gem, ModItems.wellspring_crystal);
        this.registerSynthOre(ModBlocks.blazingOre, BLAZING_ORE_HOT_CONFIG, ModItems.blazing_shard, ModItems.blazing_stone, ModItems.blazing_gem, ModItems.blazing_crystal);
        this.registerSynthOre(ModBlocks.frostOre, FROST_ORE_COLD_CONFIG, ModItems.frost_shard, ModItems.frost_stone, ModItems.frost_gem, ModItems.frost_crystal);
        this.registerSynthOre(ModBlocks.pulsingOre, PULSING_ORE_WET_COLD_CONFIG, ModItems.pulsing_shard, ModItems.pulsing_stone, ModItems.pulsing_gem, ModItems.pulsing_crystal);
        this.registerSynthOre(ModBlocks.stormyOre, STORMY_ORE_WET_CONFIG, ModItems.stormy_shard, ModItems.stormy_stone, ModItems.stormy_gem, ModItems.stormy_crystal);
    }

    private LootDrop[] createOreDrops(RegistryObject<Item> shard, RegistryObject<Item> stone, RegistryObject<Item> gem, RegistryObject<Item> crystal) {
        return new LootDrop[]{this.createWithFortune((Item)shard.get(), 40.0f), this.createWithFortune((Item)stone.get(), 30.0f), this.createWithFortune((Item)gem.get(), 20.0f), this.createWithFortune((Item)crystal.get(), 10.0f)};
    }

    private LootDrop createWithFortune(Item item, float chance) {
        LootDrop drop = new LootDrop(new ItemStack((ItemLike)item));
        drop.addConditional(Conditional.affectedByFortune);
        drop.chance = chance / 100.0f;
        drop.minDrop = 0;
        drop.maxDrop = 4;
        return drop;
    }

    private LootDrop loot(RegistryObject<Item> item, int weight, int totalDrops) {
        return new LootDrop((Item)item.get(), 0, 1, 100.0f / (float)totalDrops * (float)weight, new Conditional[0]);
    }

    private LootDrop[] createPrizeBloxDrops() {
        int drops = 31;
        return new LootDrop[]{this.loot(ModItems.fireSpell, 1, drops), this.loot(ModItems.blizzardSpell, 1, drops), this.loot(ModItems.waterSpell, 1, drops), this.loot(ModItems.thunderSpell, 1, drops), this.loot(ModItems.cureSpell, 1, drops), this.loot(ModItems.aeroSpell, 1, drops), this.loot(ModItems.magnetSpell, 1, drops), this.loot(ModItems.gravitySpell, 1, drops)};
    }

    private LootDrop[] createRarePrizeBloxDrops() {
        int drops = 27;
        return new LootDrop[]{this.loot(ModItems.valorOrb, 1, drops), this.loot(ModItems.wisdomOrb, 1, drops), this.loot(ModItems.masterOrb, 1, drops), this.loot(ModItems.finalOrb, 1, drops), this.loot(ModItems.limitOrb, 1, drops), this.loot(ModItems.orichalcum, 3, drops), this.loot(ModItems.orichalcumplus, 2, drops), this.loot(ModItems.manifest_illusion, 3, drops)};
    }

    private void registerSynthOre(RegistryObject<Block> block, OreConfig config, RegistryObject<Item> shard, RegistryObject<Item> stone, RegistryObject<Item> gem, RegistryObject<Item> crystal) {
        this.registry.register(new ItemStack((ItemLike)block.get()), (DistributionBase)new DistributionSquare(config.veinSize(), config.count(), config.minHeight(), config.maxHeight()), config.restriction(), true, this.createOreDrops(shard, stone, gem, crystal));
    }

    private void registerBlox(List<Block> blocks, OreConfig config) {
        blocks.forEach(block -> {
            LootDrop[] drops = new LootDrop[]{new LootDrop(new ItemStack((ItemLike)block))};
            boolean silkTouch = false;
            if (block == ModBlocks.prizeBlox.get()) {
                silkTouch = true;
                drops = this.createPrizeBloxDrops();
            }
            if (block == ModBlocks.rarePrizeBlox.get()) {
                silkTouch = true;
                drops = this.createRarePrizeBloxDrops();
            }
            this.registry.register(new ItemStack((ItemLike)block), (DistributionBase)new DistributionTriangular(config.veinSize(), config.count(), (config.maxHeight() - config.minHeight()) / 2, config.maxHeight() - config.minHeight()), config.restriction(), silkTouch, drops);
        });
    }

    private static BiomeRestriction createBiomeRestriction(TagKey<Biome> tag) {
        ArrayList biomes = new ArrayList();
        VanillaRegistries.m_255371_().m_255025_(Registries.f_256952_).m_214062_().forEach(biome_entry -> {
            if (biome_entry.m_203656_(tag)) {
                biomes.add((Biome)biome_entry.m_203334_());
            }
        });
        if (!biomes.isEmpty()) {
            Biome biome1 = (Biome)biomes.get(0);
            biomes.remove(0);
            return new BiomeRestriction(Restriction.Type.WHITELIST, biome1, biomes.toArray(new Biome[0]));
        }
        return new BiomeRestriction();
    }

    public record OreConfig(int veinSize, int count, int minHeight, int maxHeight, Restriction restriction) {
    }

    static enum ClimateType {
        DOWNFALL,
        TEMPERATURE;

    }
}

