/*
 * Decompiled with CFR 0.152.
 */
package online.kingdomkeys.kingdomkeys.item;

import java.util.List;
import java.util.UUID;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.extensions.common.IClientItemExtensions;
import net.minecraftforge.event.entity.EntityJoinLevelEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import online.kingdomkeys.kingdomkeys.api.item.IItemCategory;
import online.kingdomkeys.kingdomkeys.api.item.ItemCategory;
import online.kingdomkeys.kingdomkeys.client.ClientSetup;
import online.kingdomkeys.kingdomkeys.client.model.armor.ArmorBaseModel;
import online.kingdomkeys.kingdomkeys.item.KKArmorMaterial;
import online.kingdomkeys.kingdomkeys.util.Utils;

public class BaseArmorItem
extends ArmorItem
implements IItemCategory {
    String textureName;

    public BaseArmorItem(KKArmorMaterial materialIn, ArmorItem.Type slot, String textureName) {
        super((ArmorMaterial)materialIn, slot, new Item.Properties());
        this.textureName = textureName;
    }

    @Nonnull
    public String getArmorTexture(ItemStack stack, Entity entity, EquipmentSlot slot, String type) {
        if (this.textureName != null) {
            if (slot == EquipmentSlot.LEGS) {
                return "kingdomkeys:textures/models/armor/" + this.textureName + "2.png";
            }
            if (slot == EquipmentSlot.HEAD || slot == EquipmentSlot.CHEST || slot == EquipmentSlot.FEET) {
                return "kingdomkeys:textures/models/armor/" + this.textureName + "1.png";
            }
        }
        return null;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void initializeClient(Consumer<IClientItemExtensions> consumer) {
        consumer.accept(new IClientItemExtensions(){

            @Nullable
            public HumanoidModel<?> getHumanoidArmorModel(LivingEntity entityLiving, ItemStack itemStack, EquipmentSlot armorSlot, HumanoidModel<?> _default) {
                ArmorBaseModel<LivingEntity> armorModel = ClientSetup.armorModels.get(itemStack.m_41720_());
                if (armorModel != null) {
                    armorModel.head.f_104207_ = armorSlot == EquipmentSlot.HEAD;
                    armorModel.body.f_104207_ = armorSlot == EquipmentSlot.CHEST || armorSlot == EquipmentSlot.LEGS;
                    armorModel.rightArm.f_104207_ = armorSlot == EquipmentSlot.CHEST;
                    armorModel.leftArm.f_104207_ = armorSlot == EquipmentSlot.CHEST;
                    armorModel.rightLeg.f_104207_ = armorSlot == EquipmentSlot.LEGS || armorSlot == EquipmentSlot.FEET;
                    armorModel.leftLeg.f_104207_ = armorSlot == EquipmentSlot.LEGS || armorSlot == EquipmentSlot.FEET;
                    return new HumanoidModel(armorModel.root);
                }
                return _default;
            }
        });
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_7373_(ItemStack stack, @Nullable Level worldIn, List<Component> tooltip, TooltipFlag flagIn) {
        if (flagIn.m_7050_() && Utils.hasArmorID(stack)) {
            tooltip.add((Component)Component.m_237115_((String)(String.valueOf(ChatFormatting.RED) + "DEBUG:")));
            tooltip.add((Component)Component.m_237115_((String)(String.valueOf(ChatFormatting.WHITE) + Utils.getArmorID(stack).toString())));
        }
    }

    public void m_6883_(ItemStack stack, Level worldIn, Entity entityIn, int itemSlot, boolean isSelected) {
        Utils.armourTick(stack, entityIn, worldIn, itemSlot);
        super.m_6883_(stack, worldIn, entityIn, itemSlot, isSelected);
    }

    @Override
    public ItemCategory getCategory() {
        return ItemCategory.EQUIPMENT;
    }

    @Mod.EventBusSubscriber
    public static class BaseArmorItemEvents {
        @SubscribeEvent
        public static void onItemDropped(EntityJoinLevelEvent event) {
            ItemStack droppedItem;
            UUID droppedID;
            if (event.getEntity() instanceof ItemEntity && (droppedID = Utils.getArmorID(droppedItem = ((ItemEntity)event.getEntity()).m_32055_())) != null && droppedItem.m_41720_() instanceof BaseArmorItem) {
                event.setCanceled(true);
            }
        }
    }
}

