/*
 * Decompiled with CFR 0.152.
 */
package online.kingdomkeys.kingdomkeys.item;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import online.kingdomkeys.kingdomkeys.api.item.IItemCategory;
import online.kingdomkeys.kingdomkeys.api.item.ItemCategory;
import online.kingdomkeys.kingdomkeys.capability.IPlayerCapabilities;
import online.kingdomkeys.kingdomkeys.capability.ModCapabilities;
import online.kingdomkeys.kingdomkeys.item.KeychainItem;
import online.kingdomkeys.kingdomkeys.network.PacketHandler;
import online.kingdomkeys.kingdomkeys.network.stc.SCSyncCapabilityPacket;
import online.kingdomkeys.kingdomkeys.synthesis.recipe.Recipe;
import online.kingdomkeys.kingdomkeys.synthesis.recipe.RecipeRegistry;
import online.kingdomkeys.kingdomkeys.util.Utils;

public class RecipeItem
extends Item
implements IItemCategory {
    int tier = 0;

    public RecipeItem(int tier, Item.Properties properties) {
        super(properties);
        this.tier = tier;
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level world, Player player, InteractionHand hand) {
        if (hand == InteractionHand.MAIN_HAND && !world.f_46443_) {
            ItemStack stack = player.m_21205_();
            IPlayerCapabilities playerData = ModCapabilities.getPlayer(player);
            if (this.tier <= playerData.getSynthLevel()) {
                if (stack.m_41782_()) {
                    this.learnRecipes(player, stack);
                } else {
                    List<ResourceLocation> missingKeyblades = this.getMissingRecipes(playerData, "keyblade", this.tier);
                    List<ResourceLocation> missingItems = this.getMissingRecipes(playerData, "item", this.tier);
                    ArrayList<String> types = new ArrayList<String>();
                    types.add("keyblade");
                    types.add("item");
                    if (missingKeyblades.size() == 0) {
                        types.remove("keyblade");
                    }
                    if (missingItems.size() == 0) {
                        types.remove("item");
                    }
                    String type = "";
                    if (types.size() > 1) {
                        int num = world.f_46441_.m_188503_(types.size());
                        type = (String)types.get(num);
                    } else if (types.size() == 1) {
                        type = (String)types.get(0);
                    } else {
                        player.m_5661_((Component)Component.m_237115_((String)"message.recipe.no_more_to_learn"), true);
                        return super.m_7203_(world, player, hand);
                    }
                    this.shuffleRecipes(stack, player, type);
                }
            } else {
                player.m_5661_((Component)Component.m_237115_((String)"message.recipe.cant_learn_yet"), true);
            }
        }
        return super.m_7203_(world, player, hand);
    }

    private void learnRecipes(Player player, ItemStack stack) {
        CompoundTag stackTag = stack.m_41783_();
        String[] recipes = new String[]{stackTag.m_128461_("recipe1"), stackTag.m_128461_("recipe2"), stackTag.m_128461_("recipe3")};
        IPlayerCapabilities playerData = ModCapabilities.getPlayer(player);
        if (this.tier > playerData.getSynthLevel()) {
            player.m_5661_((Component)Component.m_237115_((String)"message.recipe.cant_learn_yet"), true);
            return;
        }
        boolean consume = false;
        for (String recipe : recipes) {
            ResourceLocation rl = new ResourceLocation(recipe);
            if (!RecipeRegistry.getInstance().containsKey(rl)) continue;
            ItemStack outputStack = new ItemStack((ItemLike)RecipeRegistry.getInstance().getValue(rl).getResult());
            if (recipe == null || !RecipeRegistry.getInstance().containsKey(rl)) {
                String message = "ERROR: Recipe for " + Utils.translateToLocal(rl.toString(), new Object[0]) + " was not learnt because it is not a valid recipe, Report this to a dev";
                player.m_213846_((Component)Component.m_237115_((String)(String.valueOf(ChatFormatting.RED) + message)));
                continue;
            }
            if (playerData.hasKnownRecipe(rl)) {
                player.m_213846_((Component)Component.m_237110_((String)"message.recipe.already_learnt", (Object[])new Object[]{String.valueOf(ChatFormatting.YELLOW) + Utils.translateToLocal(outputStack.m_41778_(), new Object[0])}));
                continue;
            }
            playerData.addKnownRecipe(rl);
            consume = true;
            player.m_213846_((Component)Component.m_237110_((String)"message.recipe.learnt", (Object[])new Object[]{String.valueOf(ChatFormatting.GREEN) + Utils.translateToLocal(outputStack.m_41778_(), new Object[0])}));
            PacketHandler.sendTo(new SCSyncCapabilityPacket(playerData), (ServerPlayer)player);
        }
        if (consume) {
            stack.m_41749_("recipe1");
            stack.m_41749_("recipe2");
            stack.m_41749_("recipe3");
            stack.m_41749_("type");
            player.m_21205_().m_41774_(1);
        } else {
            this.shuffleRecipes(stack, player, stackTag.m_128461_("type"));
        }
    }

    public void shuffleRecipes(ItemStack stack, Player player, String type) {
        IPlayerCapabilities playerData = ModCapabilities.getPlayer(player);
        ResourceLocation recipe1 = null;
        ResourceLocation recipe2 = null;
        ResourceLocation recipe3 = null;
        switch (type) {
            case "keyblade": {
                List<ResourceLocation> list = this.getMissingRecipes(playerData, "keyblade", this.tier);
                if (list.size() == 0) {
                    return;
                }
                if (list.size() > 0) {
                    recipe1 = list.get(Utils.randomWithRange(0, list.size() - 1));
                }
                if (list.size() > 1) {
                    while ((recipe2 = list.get(Utils.randomWithRange(0, list.size() - 1))) == recipe1) {
                    }
                }
                if (list.size() <= 2) break;
                while ((recipe3 = list.get(Utils.randomWithRange(0, list.size() - 1))) == recipe1 || recipe3 == recipe2) {
                }
                break;
            }
            case "item": {
                List<ResourceLocation> list = this.getMissingRecipes(playerData, "item", this.tier);
                if (list.size() <= 0) break;
                recipe1 = list.get(Utils.randomWithRange(0, list.size() - 1));
            }
        }
        stack.m_41784_().m_128359_("type", type);
        if (recipe1 != null) {
            stack.m_41784_().m_128359_("recipe1", recipe1.toString());
        }
        if (recipe2 != null) {
            stack.m_41784_().m_128359_("recipe2", recipe2.toString());
        }
        if (recipe3 != null) {
            stack.m_41784_().m_128359_("recipe3", recipe3.toString());
        }
        if (recipe1 != null) {
            this.learnRecipes(player, stack);
        }
    }

    private List<ResourceLocation> getMissingRecipes(IPlayerCapabilities playerData, String type, int tier) {
        ArrayList<ResourceLocation> list = new ArrayList<ResourceLocation>();
        for (Recipe r : RecipeRegistry.getInstance().getValues()) {
            if (playerData.hasKnownRecipe(r.getRegistryName()) || !r.getType().equals(type)) continue;
            if (tier == 0) {
                list.add(r.getRegistryName());
                continue;
            }
            if (r.getTier() != tier) continue;
            list.add(r.getRegistryName());
        }
        return list;
    }

    public void m_7373_(ItemStack stack, Level worldIn, List<Component> tooltip, TooltipFlag flagIn) {
        if (stack.m_41782_()) {
            for (int i = 1; i <= 3; ++i) {
                String name;
                Recipe recipe;
                String recipeName = stack.m_41783_().m_128461_("recipe" + i);
                if (!RecipeRegistry.getInstance().containsKey(new ResourceLocation(recipeName)) || (recipe = RecipeRegistry.getInstance().getValue(new ResourceLocation(recipeName))) == null) continue;
                if (recipe.getType().equals("keyblade")) {
                    KeychainItem item = (KeychainItem)recipe.getResult();
                    name = new ItemStack((ItemLike)item.keyblade).m_41778_();
                } else {
                    name = new ItemStack((ItemLike)recipe.getResult()).m_41778_();
                }
                tooltip.add((Component)Component.m_237115_((String)Utils.translateToLocal(name, new Object[0])));
            }
        }
    }

    @Override
    public ItemCategory getCategory() {
        return ItemCategory.MISC;
    }
}

