/*
 * Decompiled with CFR 0.152.
 */
package online.kingdomkeys.kingdomkeys.lib;

import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.Locale;
import net.minecraft.nbt.ListTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import online.kingdomkeys.kingdomkeys.capability.IPlayerCapabilities;
import online.kingdomkeys.kingdomkeys.capability.ModCapabilities;
import online.kingdomkeys.kingdomkeys.driveform.DriveForm;
import online.kingdomkeys.kingdomkeys.driveform.ModDriveForms;
import online.kingdomkeys.kingdomkeys.item.KeybladeItem;
import online.kingdomkeys.kingdomkeys.item.KeychainItem;
import online.kingdomkeys.kingdomkeys.item.organization.IOrgWeapon;

public class DamageCalculation {
    public static float getMagicDamage(Player player, ItemStack stack) {
        if (player != null) {
            IPlayerCapabilities playerData = ModCapabilities.getPlayer(player);
            if (playerData == null) {
                return 0.0f;
            }
            float damage = 0.0f;
            KeybladeItem keyblade = null;
            if (stack.m_41720_() instanceof KeychainItem) {
                keyblade = ((KeychainItem)stack.m_41720_()).getKeyblade();
            } else if (stack.m_41720_() instanceof KeybladeItem) {
                keyblade = (KeybladeItem)stack.m_41720_();
            }
            if (keyblade != null) {
                damage = keyblade.getMagic(stack) + playerData.getMagic(true);
                if (!playerData.getActiveDriveForm().equals(DriveForm.NONE.toString())) {
                    DriveForm form = (DriveForm)ModDriveForms.registry.get().getValue(new ResourceLocation(playerData.getActiveDriveForm()));
                    damage *= form.getMagMult();
                }
            }
            return damage;
        }
        return 0.0f;
    }

    public static float getOrgMagicDamage(Player player, IOrgWeapon weapon) {
        if (player != null) {
            IPlayerCapabilities playerData = ModCapabilities.getPlayer(player);
            if (playerData == null) {
                return 0.0f;
            }
            return weapon.getMagic() + playerData.getMagic(true);
        }
        return 0.0f;
    }

    public static float getMagicDamage(Player player) {
        if (player != null) {
            IPlayerCapabilities playerData = ModCapabilities.getPlayer(player);
            if (playerData == null) {
                return 0.0f;
            }
            float finalDamage = 0.0f;
            if (player.m_21120_(InteractionHand.MAIN_HAND) != null && player.m_21120_(InteractionHand.MAIN_HAND).m_41720_() instanceof KeybladeItem || player.m_21120_(InteractionHand.MAIN_HAND).m_41720_() instanceof IOrgWeapon) {
                if (player.m_21120_(InteractionHand.MAIN_HAND).m_41720_() instanceof KeybladeItem) {
                    finalDamage = DamageCalculation.getMagicDamage(player, player.m_21205_());
                } else if (player.m_21120_(InteractionHand.MAIN_HAND).m_41720_() instanceof IOrgWeapon) {
                    finalDamage = DamageCalculation.getOrgMagicDamage(player, (IOrgWeapon)player.m_21205_().m_41720_());
                }
            } else {
                finalDamage = playerData.getMagic(true);
            }
            return finalDamage;
        }
        return 0.0f;
    }

    public static float getStrengthDamage(Player player) {
        if (player != null) {
            IPlayerCapabilities playerData = ModCapabilities.getPlayer(player);
            if (playerData == null) {
                return 0.0f;
            }
            float finalDamage = 0.0f;
            if (!player.m_21120_(InteractionHand.MAIN_HAND).m_41619_() && player.m_21120_(InteractionHand.MAIN_HAND).m_41720_() instanceof KeybladeItem || player.m_21120_(InteractionHand.MAIN_HAND).m_41720_() instanceof IOrgWeapon) {
                if (player.m_21120_(InteractionHand.MAIN_HAND).m_41720_() instanceof KeybladeItem) {
                    finalDamage = DamageCalculation.getKBStrengthDamage(player, player.m_21205_());
                } else if (player.m_21120_(InteractionHand.MAIN_HAND).m_41720_() instanceof IOrgWeapon) {
                    finalDamage = DamageCalculation.getOrgStrengthDamage(player, player.m_21205_());
                }
            } else {
                finalDamage = playerData.getStrength(true);
            }
            return finalDamage;
        }
        return 0.0f;
    }

    public static float getKBStrengthDamage(Player player, ItemStack stack) {
        if (player != null) {
            IPlayerCapabilities playerData = ModCapabilities.getPlayer(player);
            if (playerData == null) {
                return 0.0f;
            }
            float damage = 0.0f;
            float finalDamage = 0.0f;
            KeybladeItem keyblade = null;
            if (stack.m_41720_() instanceof KeychainItem) {
                keyblade = ((KeychainItem)stack.m_41720_()).getKeyblade();
            } else if (stack.m_41720_() instanceof KeybladeItem) {
                keyblade = (KeybladeItem)stack.m_41720_();
            }
            if (keyblade != null) {
                damage = keyblade.getStrength(stack) + playerData.getStrength(true);
                if (!playerData.getActiveDriveForm().equals(DriveForm.NONE.toString())) {
                    DriveForm form = (DriveForm)ModDriveForms.registry.get().getValue(new ResourceLocation(playerData.getActiveDriveForm()));
                    damage *= form.getStrMult();
                }
            }
            finalDamage = damage;
            DecimalFormatSymbols otherSymbols = new DecimalFormatSymbols(Locale.getDefault());
            otherSymbols.setDecimalSeparator('.');
            DecimalFormat df = new DecimalFormat("###.##", otherSymbols);
            return Float.parseFloat(df.format(finalDamage));
        }
        return 0.0f;
    }

    public static float getOrgStrengthDamage(Player player, ItemStack stack) {
        if (player != null) {
            IPlayerCapabilities playerData = ModCapabilities.getPlayer(player);
            float damage = 0.0f;
            float finalDamage = 0.0f;
            if (stack.m_41720_() instanceof IOrgWeapon) {
                IOrgWeapon org = (IOrgWeapon)stack.m_41720_();
                finalDamage = damage = (float)org.getStrength() + (float)playerData.getStrength(true);
            }
            return finalDamage;
        }
        return 0.0f;
    }

    public static float getSharpnessDamage(ItemStack stack) {
        ListTag nbttaglist = stack.m_41785_();
        float sharpnessDamage = 0.0f;
        for (int i = 0; i < nbttaglist.size(); ++i) {
            String id = nbttaglist.m_128728_(i).m_128461_("id");
            short lvl = nbttaglist.m_128728_(i).m_128448_("lvl");
            if (!id.equals("minecraft:sharpness")) continue;
            sharpnessDamage = DamageCalculation.getSharpnessDamageFromLevel(lvl);
        }
        return sharpnessDamage;
    }

    private static float getSharpnessDamageFromLevel(float lvl) {
        return lvl / 2.0f + 0.5f;
    }
}

