/*
 * Decompiled with CFR 0.152.
 */
package online.kingdomkeys.kingdomkeys.network.cts;

import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraftforge.network.NetworkEvent;
import online.kingdomkeys.kingdomkeys.capability.CastleOblivionCapabilities;
import online.kingdomkeys.kingdomkeys.capability.ModCapabilities;
import online.kingdomkeys.kingdomkeys.entity.block.CardDoorTileEntity;
import online.kingdomkeys.kingdomkeys.item.card.MapCardItem;
import online.kingdomkeys.kingdomkeys.world.dimension.castle_oblivion.system.room.Room;
import online.kingdomkeys.kingdomkeys.world.dimension.castle_oblivion.system.room.RoomData;
import online.kingdomkeys.kingdomkeys.world.dimension.castle_oblivion.system.room.RoomGenerator;
import online.kingdomkeys.kingdomkeys.world.dimension.castle_oblivion.system.room.RoomType;

public class CSGenerateRoom {
    ItemStack stack;
    int slot;
    BlockPos pos;

    public CSGenerateRoom() {
    }

    public CSGenerateRoom(ItemStack stack, int slot, BlockPos pos) {
        this.stack = stack;
        this.slot = slot;
        this.pos = pos;
    }

    public void encode(FriendlyByteBuf buffer) {
        buffer.m_130055_(this.stack);
        buffer.writeInt(this.slot);
        buffer.m_130064_(this.pos);
    }

    public static CSGenerateRoom decode(FriendlyByteBuf buffer) {
        CSGenerateRoom msg = new CSGenerateRoom();
        msg.stack = buffer.m_130267_();
        msg.slot = buffer.readInt();
        msg.pos = buffer.m_130135_();
        return msg;
    }

    public static void handle(CSGenerateRoom message, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            ServerPlayer player = ((NetworkEvent.Context)ctx.get()).getSender();
            Level level = player.m_9236_();
            CastleOblivionCapabilities.ICastleOblivionInteriorCapability cap = ModCapabilities.getCastleOblivionInterior(level);
            CardDoorTileEntity te = (CardDoorTileEntity)player.m_9236_().m_7702_(message.pos);
            RoomType type = ((MapCardItem)message.stack.m_41720_()).getRoomType();
            Room currentRoom = cap.getRoomAtPos(player.m_9236_(), message.pos);
            RoomData data = te.getParentRoom().getParentFloor(level).getAdjacentRoom(te.getParentRoom(), te.getDirection());
            Room newRoom = RoomGenerator.INSTANCE.generateRoom(level, data, type, currentRoom, te.getDirection());
            BlockPos destination = newRoom.doors.get((Object)te.getDirection().opposite()).pos();
            CardDoorTileEntity destTe = (CardDoorTileEntity)level.m_7702_(destination);
            te.openDoor(true);
            destTe.openDoor(true);
            destTe.setDestinationRoom(te.getParentRoom());
            player.m_150109_().m_8020_(message.slot).m_41774_(1);
        });
        ctx.get().setPacketHandled(true);
    }
}

