/*
 * Decompiled with CFR 0.152.
 */
package online.kingdomkeys.kingdomkeys.network.cts;

import java.util.function.Supplier;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.util.ITeleporter;
import net.minecraftforge.network.NetworkEvent;
import online.kingdomkeys.kingdomkeys.capability.IPlayerCapabilities;
import online.kingdomkeys.kingdomkeys.capability.ModCapabilities;
import online.kingdomkeys.kingdomkeys.world.utils.BaseTeleporter;

public class CSOrgPortalTPPacket {
    ResourceKey<Level> dim;
    double x;
    double y;
    double z;

    public CSOrgPortalTPPacket() {
    }

    public CSOrgPortalTPPacket(ResourceKey<Level> dimension, double x, double y, double z) {
        this.dim = dimension;
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public void encode(FriendlyByteBuf buffer) {
        buffer.m_130085_(this.dim.m_135782_());
        buffer.writeDouble(this.x);
        buffer.writeDouble(this.y);
        buffer.writeDouble(this.z);
    }

    public static CSOrgPortalTPPacket decode(FriendlyByteBuf buffer) {
        CSOrgPortalTPPacket msg = new CSOrgPortalTPPacket();
        msg.dim = ResourceKey.m_135785_((ResourceKey)Registries.f_256858_, (ResourceLocation)buffer.m_130281_());
        msg.x = buffer.readDouble();
        msg.y = buffer.readDouble();
        msg.z = buffer.readDouble();
        return msg;
    }

    public static void handle(CSOrgPortalTPPacket message, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            ServerPlayer player = ((NetworkEvent.Context)ctx.get()).getSender();
            ServerLevel serverWorld = player.m_9236_().m_7654_().m_129880_(message.dim);
            IPlayerCapabilities playerData = ModCapabilities.getPlayer((Player)player);
            playerData.setRespawnROD(message.dim.m_135782_().m_135815_().equals("realm_of_darkness"));
            if (player.m_9236_().m_46472_().equals(message.dim)) {
                ServerPlayer playerMP = player;
                playerMP.m_6021_(message.x + 0.5, message.y, message.z + 0.5);
                playerMP.m_20334_(0.0, 0.0, 0.0);
            } else {
                player.changeDimension(serverWorld, (ITeleporter)new BaseTeleporter(message.x, message.y, message.z));
            }
        });
        ctx.get().setPacketHandled(true);
    }
}

