/*
 * Decompiled with CFR 0.152.
 */
package online.kingdomkeys.kingdomkeys.network.cts;

import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraftforge.network.NetworkEvent;
import online.kingdomkeys.kingdomkeys.capability.IWorldCapabilities;
import online.kingdomkeys.kingdomkeys.capability.ModCapabilities;
import online.kingdomkeys.kingdomkeys.lib.Party;
import online.kingdomkeys.kingdomkeys.util.Utils;

public class CSPartySettings {
    String name;
    boolean priv;
    byte size;
    boolean friendlyFire;

    public CSPartySettings() {
    }

    public CSPartySettings(Party party) {
        this.name = party.getName();
        this.priv = party.getPriv();
        this.size = party.getSize();
        this.friendlyFire = party.getFriendlyFire();
    }

    public void encode(FriendlyByteBuf buffer) {
        buffer.writeInt(this.name.length());
        buffer.m_130070_(this.name);
        buffer.writeBoolean(this.priv);
        buffer.writeByte((int)this.size);
        buffer.writeBoolean(this.friendlyFire);
    }

    public static CSPartySettings decode(FriendlyByteBuf buffer) {
        CSPartySettings msg = new CSPartySettings();
        int length = buffer.readInt();
        msg.name = buffer.m_130136_(length);
        msg.priv = buffer.readBoolean();
        msg.size = buffer.readByte();
        msg.friendlyFire = buffer.readBoolean();
        return msg;
    }

    public static void handle(CSPartySettings message, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            ServerPlayer player = ((NetworkEvent.Context)ctx.get()).getSender();
            IWorldCapabilities worldData = ModCapabilities.getWorld(player.m_9236_());
            Party p = worldData.getPartyFromName(message.name);
            p.setPriv(message.priv);
            p.setSize(message.size);
            p.setFriendlyFire(message.friendlyFire);
            Utils.syncWorldData(player.m_9236_(), worldData);
        });
        ctx.get().setPacketHandled(true);
    }
}

