/*
 * Decompiled with CFR 0.152.
 */
package online.kingdomkeys.kingdomkeys.network.cts;

import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.network.NetworkEvent;
import online.kingdomkeys.kingdomkeys.ability.Ability;
import online.kingdomkeys.kingdomkeys.ability.ModAbilities;
import online.kingdomkeys.kingdomkeys.api.event.AbilityEvent;
import online.kingdomkeys.kingdomkeys.capability.IPlayerCapabilities;
import online.kingdomkeys.kingdomkeys.capability.ModCapabilities;
import online.kingdomkeys.kingdomkeys.util.Utils;

public class CSSetEquippedAbilityPacket {
    String ability;
    int level;

    public CSSetEquippedAbilityPacket() {
    }

    public CSSetEquippedAbilityPacket(String ability, int level) {
        this.ability = ability;
        this.level = level;
    }

    public void encode(FriendlyByteBuf buffer) {
        buffer.writeInt(this.ability.length());
        buffer.m_130070_(this.ability);
        buffer.writeInt(this.level);
    }

    public static CSSetEquippedAbilityPacket decode(FriendlyByteBuf buffer) {
        CSSetEquippedAbilityPacket msg = new CSSetEquippedAbilityPacket();
        int length = buffer.readInt();
        msg.ability = buffer.m_130136_(length);
        msg.level = buffer.readInt();
        return msg;
    }

    public static void handle(CSSetEquippedAbilityPacket message, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            ServerPlayer player = ((NetworkEvent.Context)ctx.get()).getSender();
            IPlayerCapabilities playerData = ModCapabilities.getPlayer((Player)player);
            boolean cancelled = playerData.isAbilityEquipped(message.ability, message.level) ? MinecraftForge.EVENT_BUS.post((Event)new AbilityEvent.Unequip((Ability)ModAbilities.registry.get().getValue(new ResourceLocation(message.ability)), message.level, (Player)player, false)) : MinecraftForge.EVENT_BUS.post((Event)new AbilityEvent.Equip((Ability)ModAbilities.registry.get().getValue(new ResourceLocation(message.ability)), message.level, (Player)player, false));
            if (!cancelled) {
                playerData.equipAbilityToggle(message.ability, message.level);
                Utils.RefreshAbilityAttributes((Player)player, playerData);
            }
        });
        ctx.get().setPacketHandled(true);
    }
}

