/*
 * Decompiled with CFR 0.152.
 */
package online.kingdomkeys.kingdomkeys.network.cts;

import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.network.NetworkEvent;
import online.kingdomkeys.kingdomkeys.capability.IPlayerCapabilities;
import online.kingdomkeys.kingdomkeys.capability.ModCapabilities;
import online.kingdomkeys.kingdomkeys.network.PacketHandler;
import online.kingdomkeys.kingdomkeys.network.stc.SCSyncCapabilityPacket;

public class CSSetShortcutPacket {
    int position;
    int level;
    String magic;

    public CSSetShortcutPacket() {
    }

    public CSSetShortcutPacket(int positon, int level, String magic) {
        this.position = positon;
        this.level = level;
        this.magic = magic;
    }

    public void encode(FriendlyByteBuf buffer) {
        buffer.writeInt(this.position);
        buffer.writeInt(this.level);
        buffer.m_130072_(this.magic, 100);
    }

    public static CSSetShortcutPacket decode(FriendlyByteBuf buffer) {
        CSSetShortcutPacket msg = new CSSetShortcutPacket();
        msg.position = buffer.readInt();
        msg.level = buffer.readInt();
        msg.magic = buffer.m_130136_(100);
        return msg;
    }

    public static void handle(CSSetShortcutPacket message, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            ServerPlayer player = ((NetworkEvent.Context)ctx.get()).getSender();
            IPlayerCapabilities playerData = ModCapabilities.getPlayer((Player)player);
            if (message.magic.equals("")) {
                playerData.removeShortcut(message.position);
            } else {
                playerData.changeShortcut(message.position, message.magic, message.level);
            }
            PacketHandler.sendTo(new SCSyncCapabilityPacket(playerData), player);
        });
        ctx.get().setPacketHandled(true);
    }
}

