/*
 * Decompiled with CFR 0.152.
 */
package online.kingdomkeys.kingdomkeys.network.cts;

import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.network.NetworkEvent;
import online.kingdomkeys.kingdomkeys.capability.IPlayerCapabilities;
import online.kingdomkeys.kingdomkeys.capability.ModCapabilities;
import online.kingdomkeys.kingdomkeys.limit.Limit;
import online.kingdomkeys.kingdomkeys.limit.ModLimits;
import online.kingdomkeys.kingdomkeys.network.PacketHandler;
import online.kingdomkeys.kingdomkeys.network.stc.SCSyncCapabilityPacket;

public class CSUseLimitPacket {
    ResourceLocation limit;
    int targetID;

    public CSUseLimitPacket() {
    }

    public CSUseLimitPacket(ResourceLocation limit) {
        this.limit = limit;
        this.targetID = -1;
    }

    public CSUseLimitPacket(LivingEntity target, ResourceLocation limit) {
        this.limit = limit;
        this.targetID = target.m_19879_();
    }

    public void encode(FriendlyByteBuf buffer) {
        buffer.m_130085_(this.limit);
        buffer.writeInt(this.targetID);
    }

    public static CSUseLimitPacket decode(FriendlyByteBuf buffer) {
        CSUseLimitPacket msg = new CSUseLimitPacket();
        msg.limit = buffer.m_130281_();
        msg.targetID = buffer.readInt();
        return msg;
    }

    public static void handle(CSUseLimitPacket message, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            ServerPlayer player = ((NetworkEvent.Context)ctx.get()).getSender();
            IPlayerCapabilities playerData = ModCapabilities.getPlayer((Player)player);
            Limit limit = (Limit)ModLimits.registry.get().getValue(message.limit);
            int cost = limit.getCost();
            if (playerData.getDP() >= (double)cost) {
                playerData.remDP(cost);
                playerData.setLimitCooldownTicks(limit.getCooldown());
                PacketHandler.sendTo(new SCSyncCapabilityPacket(playerData), player);
                if (message.targetID > -1) {
                    limit.onUse((Player)player, (LivingEntity)player.m_9236_().m_6815_(message.targetID));
                } else {
                    limit.onUse((Player)player, (LivingEntity)player);
                }
            }
            PacketHandler.syncToAllAround((Player)player, playerData);
        });
        ctx.get().setPacketHandled(true);
    }
}

