/*
 * Decompiled with CFR 0.152.
 */
package online.kingdomkeys.kingdomkeys.network.stc;

import com.mojang.datafixers.util.Pair;
import java.time.Instant;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.network.NetworkEvent;
import online.kingdomkeys.kingdomkeys.capability.ModCapabilities;
import online.kingdomkeys.kingdomkeys.client.ClientUtils;
import online.kingdomkeys.kingdomkeys.entity.block.SavepointTileEntity;
import online.kingdomkeys.kingdomkeys.world.SavePointStorage;

public record SCOpenSavePointScreen(BlockPos tileEntity, Map<UUID, Pair<SavePointStorage.SavePoint, Instant>> savePoints, boolean create) {
    public SCOpenSavePointScreen(FriendlyByteBuf buf) {
        this(buf.m_130135_(), SCOpenSavePointScreen.readSavePoints(buf), buf.readBoolean());
    }

    public SCOpenSavePointScreen(SavepointTileEntity tileEntity, Player player) {
        this(tileEntity.m_58899_(), SCOpenSavePointScreen.getAndAddSavePoints(tileEntity, player), SCOpenSavePointScreen.shouldCreate(tileEntity, player));
    }

    public static Map<UUID, Pair<SavePointStorage.SavePoint, Instant>> readSavePoints(FriendlyByteBuf buf) {
        HashMap<UUID, Pair<SavePointStorage.SavePoint, Instant>> points = new HashMap<UUID, Pair<SavePointStorage.SavePoint, Instant>>();
        int size = buf.readInt();
        for (int i = 0; i < size; ++i) {
            SavePointStorage.SavePoint savePoint = new SavePointStorage.SavePoint(buf.m_130260_());
            points.put(savePoint.id(), (Pair<SavePointStorage.SavePoint, Instant>)Pair.of((Object)savePoint, (Object)Instant.ofEpochSecond(buf.readLong(), buf.readInt())));
        }
        return points;
    }

    private static Map<UUID, Pair<SavePointStorage.SavePoint, Instant>> getAndAddSavePoints(SavepointTileEntity tileEntity, Player player) {
        SavePointStorage storage = SavePointStorage.getStorage(player.m_20194_());
        Map<UUID, Pair<SavePointStorage.SavePoint, Instant>> savePoints = storage.getDiscoveredSavePoints(player);
        if (storage.savePointRegistered(tileEntity.getID()) && !storage.getSavePoint(tileEntity.getID()).global() && !savePoints.containsKey(tileEntity.getID())) {
            Instant instant = Instant.now();
            savePoints.put(tileEntity.getID(), (Pair<SavePointStorage.SavePoint, Instant>)Pair.of((Object)storage.getSavePoint(tileEntity.getID()), (Object)instant));
            ModCapabilities.getPlayer(player).addDiscoveredSavePoint(tileEntity.getID(), instant);
        }
        return savePoints;
    }

    private static boolean shouldCreate(SavepointTileEntity tileEntity, Player player) {
        SavePointStorage storage = SavePointStorage.getStorage(player.m_20194_());
        return !storage.savePointRegistered(tileEntity.getID());
    }

    public void encode(FriendlyByteBuf buf) {
        buf.m_130064_(this.tileEntity);
        buf.writeInt(this.savePoints.size());
        this.savePoints.values().forEach(savePoint -> {
            buf.m_130079_(((SavePointStorage.SavePoint)savePoint.getFirst()).serializeNBT());
            buf.writeLong(((Instant)savePoint.getSecond()).getEpochSecond());
            buf.writeInt(((Instant)savePoint.getSecond()).getNano());
        });
        buf.writeBoolean(this.create);
    }

    public static void handle(SCOpenSavePointScreen message, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> DistExecutor.safeRunWhenOn((Dist)Dist.CLIENT, () -> ClientUtils.openSavePointScreen(message)));
        ctx.get().setPacketHandled(true);
    }
}

