/*
 * Decompiled with CFR 0.152.
 */
package online.kingdomkeys.kingdomkeys.network.stc;

import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.network.NetworkEvent;
import online.kingdomkeys.kingdomkeys.client.gui.overlay.GuiOverlay;

public class SCShowOverlayPacket {
    String type;
    int munny;
    String driveForm;
    String playerName;
    UUID player;
    int level;
    int color;
    List<String> messages = new ArrayList<String>();

    public SCShowOverlayPacket() {
    }

    public SCShowOverlayPacket(String type) {
        this.type = type;
        this.driveForm = "";
        this.playerName = "";
        this.player = Util.f_137441_;
        this.messages = List.of();
    }

    public SCShowOverlayPacket(String type, int munny) {
        this.type = type;
        this.munny = munny;
        this.driveForm = "";
        this.playerName = "";
        this.player = Util.f_137441_;
        this.messages = List.of();
    }

    public SCShowOverlayPacket(String type, String driveForm) {
        this.type = type;
        this.driveForm = driveForm;
        this.playerName = "";
        this.player = Util.f_137441_;
        this.messages = List.of();
    }

    public SCShowOverlayPacket(String type, UUID player, String playerName, int level, int color, List<String> messages) {
        this.type = type;
        this.player = player;
        this.playerName = playerName;
        this.messages = messages;
        this.level = level;
        this.color = color;
        this.driveForm = "";
    }

    public void encode(FriendlyByteBuf buffer) {
        buffer.m_130072_(this.type, 50);
        buffer.writeInt(this.munny);
        buffer.m_130072_(this.driveForm, 50);
        buffer.m_130072_(this.playerName, 50);
        buffer.m_130077_(this.player);
        buffer.writeInt(this.level);
        buffer.writeInt(this.color);
        int size = this.messages.size();
        buffer.writeInt(size);
        for (int i = 0; i < size; ++i) {
            buffer.m_130072_(this.messages.get(i), 150);
        }
    }

    public static SCShowOverlayPacket decode(FriendlyByteBuf buffer) {
        SCShowOverlayPacket msg = new SCShowOverlayPacket();
        msg.type = buffer.m_130136_(50);
        msg.munny = buffer.readInt();
        msg.driveForm = buffer.m_130136_(50);
        msg.playerName = buffer.m_130136_(50);
        msg.player = buffer.m_130259_();
        msg.level = buffer.readInt();
        msg.color = buffer.readInt();
        int size = buffer.readInt();
        for (int i = 0; i < size; ++i) {
            msg.messages.add(buffer.m_130136_(150));
        }
        return msg;
    }

    public static void handle(SCShowOverlayPacket msg, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            Minecraft mc = Minecraft.m_91087_();
            long time = System.currentTimeMillis() / 1000L;
            switch (msg.type) {
                case "exp": {
                    GuiOverlay.showExp = true;
                    GuiOverlay.timeExp = time;
                    break;
                }
                case "munny": {
                    GuiOverlay.showMunny = true;
                    GuiOverlay.timeMunny = time;
                    GuiOverlay.munnyGet = msg.munny;
                    break;
                }
                case "levelup": {
                    GuiOverlay.LevelUpData instance = new GuiOverlay.LevelUpData();
                    instance.timeLevelUp = time;
                    instance.notifTicks = 0;
                    instance.playerUUID = msg.player;
                    instance.playerName = msg.playerName;
                    instance.messages = msg.messages;
                    instance.lvl = msg.level;
                    instance.color = msg.color;
                    GuiOverlay.levelUpList.add(0, instance);
                    break;
                }
                case "drivelevelup": {
                    GuiOverlay.showDriveLevelUp = true;
                    GuiOverlay.timeDriveLevelUp = time;
                    GuiOverlay.driveForm = msg.driveForm;
                    GuiOverlay.driveNotifTicks = 0.0f;
                }
            }
        });
        ctx.get().setPacketHandled(true);
    }
}

