/*
 * Decompiled with CFR 0.152.
 */
package online.kingdomkeys.kingdomkeys.network.stc;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.network.NetworkEvent;
import online.kingdomkeys.kingdomkeys.client.ClientUtils;
import online.kingdomkeys.kingdomkeys.synthesis.shop.names.NamesListRegistry;

public class SCSyncMoogleNames {
    public Map<ResourceLocation, List<String>> names;

    public SCSyncMoogleNames() {
    }

    public SCSyncMoogleNames(NamesListRegistry names) {
        this.names = names.getRegistry();
    }

    public void encode(FriendlyByteBuf buffer) {
        List keys = this.names.keySet().stream().toList();
        List<List<String>> values = this.names.values().stream().toList();
        int size = this.names.size();
        buffer.writeInt(size);
        for (int i = 0; i < size; ++i) {
            int valueSize = values.get(i).size();
            buffer.writeInt(valueSize);
            buffer.m_130070_(((ResourceLocation)keys.get(i)).toString());
            for (int j = 0; j < valueSize; ++j) {
                buffer.m_130070_(values.get(i).get(j));
            }
        }
    }

    public static SCSyncMoogleNames decode(FriendlyByteBuf buffer) {
        SCSyncMoogleNames msg = new SCSyncMoogleNames();
        HashMap<ResourceLocation, List<String>> registry = new HashMap<ResourceLocation, List<String>>();
        int size = buffer.readInt();
        for (int i = 0; i < size; ++i) {
            int valueSize = buffer.readInt();
            ResourceLocation location = new ResourceLocation(buffer.m_130277_());
            ArrayList<String> list = new ArrayList<String>();
            for (int j = 0; j < valueSize; ++j) {
                list.add(buffer.m_130277_());
            }
            registry.put(location, list);
        }
        msg.names = registry;
        return msg;
    }

    public static void handle(SCSyncMoogleNames message, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> DistExecutor.safeRunWhenOn((Dist)Dist.CLIENT, () -> ClientUtils.syncMoogleNames(message)));
        ctx.get().setPacketHandled(true);
    }
}

