/*
 * Decompiled with CFR 0.152.
 */
package online.kingdomkeys.kingdomkeys.network.stc;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.util.LinkedList;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.network.NetworkEvent;
import online.kingdomkeys.kingdomkeys.client.ClientUtils;
import online.kingdomkeys.kingdomkeys.item.organization.OrganizationData;
import online.kingdomkeys.kingdomkeys.item.organization.OrganizationDataDeserializer;

public class SCSyncOrganizationData {
    public static final Gson GSON_BUILDER = new GsonBuilder().registerTypeAdapter(OrganizationData.class, (Object)new OrganizationDataDeserializer()).setPrettyPrinting().create();
    public List<String> names = new LinkedList<String>();
    public List<String> data = new LinkedList<String>();

    public SCSyncOrganizationData() {
    }

    public SCSyncOrganizationData(List<String> names, List<String> data) {
        this.names = names;
        this.data = data;
    }

    public void encode(FriendlyByteBuf buffer) {
        int i;
        buffer.writeInt(this.names.size());
        buffer.writeInt(this.data.size());
        for (i = 0; i < this.names.size(); ++i) {
            String n = this.names.get(i);
            buffer.writeInt(n.length());
            buffer.m_130070_(n);
        }
        for (i = 0; i < this.data.size(); ++i) {
            String d = this.data.get(i);
            buffer.writeInt(d.length());
            buffer.m_130070_(d);
        }
    }

    public static SCSyncOrganizationData decode(FriendlyByteBuf buffer) {
        int l;
        int i;
        SCSyncOrganizationData msg = new SCSyncOrganizationData();
        int nLen = buffer.readInt();
        int dLen = buffer.readInt();
        for (i = 0; i < nLen; ++i) {
            l = buffer.readInt();
            msg.names.add(buffer.m_130136_(l));
        }
        for (i = 0; i < dLen; ++i) {
            l = buffer.readInt();
            msg.data.add(buffer.m_130136_(l));
        }
        return msg;
    }

    public static void handle(SCSyncOrganizationData message, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> DistExecutor.safeRunWhenOn((Dist)Dist.CLIENT, () -> ClientUtils.syncOrgData(message)));
        ctx.get().setPacketHandled(true);
    }
}

