/*
 * Decompiled with CFR 0.152.
 */
package online.kingdomkeys.kingdomkeys.network.stc;

import java.util.LinkedList;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.network.NetworkEvent;
import online.kingdomkeys.kingdomkeys.client.ClientUtils;
import online.kingdomkeys.kingdomkeys.synthesis.recipe.Recipe;

public class SCSyncSynthesisData {
    public List<Recipe> recipes = new LinkedList<Recipe>();

    public SCSyncSynthesisData() {
    }

    public SCSyncSynthesisData(List<Recipe> recipes) {
        this.recipes = recipes;
    }

    public void encode(FriendlyByteBuf buffer) {
        buffer.writeInt(this.recipes.size());
        CompoundTag compoundNBT = new CompoundTag();
        for (int i = 0; i < this.recipes.size(); ++i) {
            compoundNBT.m_128365_("recipe" + i, (Tag)this.recipes.get(i).serializeNBT());
        }
        buffer.m_130079_(compoundNBT);
    }

    public static SCSyncSynthesisData decode(FriendlyByteBuf buffer) {
        SCSyncSynthesisData msg = new SCSyncSynthesisData();
        int size = buffer.readInt();
        CompoundTag compoundNBT = buffer.m_130260_();
        for (int i = 0; i < size; ++i) {
            Recipe r = new Recipe();
            r.deserializeNBT((CompoundTag)compoundNBT.m_128423_("recipe" + i));
            msg.recipes.add(r);
        }
        return msg;
    }

    public static void handle(SCSyncSynthesisData message, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> DistExecutor.safeRunWhenOn((Dist)Dist.CLIENT, () -> ClientUtils.syncSynthesisData(message)));
        ctx.get().setPacketHandled(true);
    }
}

