/*
 * Decompiled with CFR 0.152.
 */
package online.kingdomkeys.kingdomkeys.network.stc;

import com.mojang.datafixers.util.Pair;
import java.time.Instant;
import java.util.Map;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.network.NetworkEvent;
import online.kingdomkeys.kingdomkeys.client.ClientUtils;
import online.kingdomkeys.kingdomkeys.network.stc.SCOpenSavePointScreen;
import online.kingdomkeys.kingdomkeys.world.SavePointStorage;

public record SCUpdateSavePoints(Map<UUID, Pair<SavePointStorage.SavePoint, Instant>> savePoints) {
    public SCUpdateSavePoints(FriendlyByteBuf buf) {
        this(SCOpenSavePointScreen.readSavePoints(buf));
    }

    public void encode(FriendlyByteBuf buf) {
        buf.writeInt(this.savePoints.size());
        this.savePoints.values().forEach(savePoint -> {
            buf.m_130079_(((SavePointStorage.SavePoint)savePoint.getFirst()).serializeNBT());
            buf.writeLong(((Instant)savePoint.getSecond()).getEpochSecond());
            buf.writeInt(((Instant)savePoint.getSecond()).getNano());
        });
    }

    public static void handle(SCUpdateSavePoints message, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> DistExecutor.safeRunWhenOn((Dist)Dist.CLIENT, () -> ClientUtils.updateSavePoints(message)));
        ctx.get().setPacketHandled(true);
    }
}

